/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.sphincs;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA3Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA512Digest;
import com.timevale.tgtext.bouncycastle.crypto.digests.SHA512tDigest;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.pqc.crypto.sphincs.SPHINCS256Signer;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.sphincs.BCSphincs256PublicKey;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureSpi
extends java.security.SignatureSpi {
    private Digest digest;
    private SPHINCS256Signer signer;
    private SecureRandom random;

    protected SignatureSpi(Digest digest, SPHINCS256Signer sPHINCS256Signer) {
        this.digest = digest;
        this.signer = sPHINCS256Signer;
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (publicKey instanceof BCSphincs256PublicKey) {
            CipherParameters cipherParameters = ((BCSphincs256PublicKey)publicKey).getKeyParams();
            this.digest.reset();
            this.signer.init(false, cipherParameters);
            return;
        }
        throw new InvalidKeyException("unknown public key passed to SPHINCS-256");
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.random = secureRandom;
        this.engineInitSign(privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey instanceof BCSphincs256PrivateKey) {
            CipherParameters cipherParameters = ((BCSphincs256PrivateKey)privateKey).getKeyParams();
            if (this.random != null) {
                cipherParameters = new ParametersWithRandom(cipherParameters, this.random);
            }
            this.digest.reset();
            this.signer.init(true, cipherParameters);
            return;
        }
        throw new InvalidKeyException("unknown private key passed to SPHINCS-256");
    }

    @Override
    protected void engineUpdate(byte by2) throws SignatureException {
        this.digest.update(by2);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        this.digest.update(byArray, n2, n3);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        try {
            byte[] byArray2 = this.signer.generateSignature(byArray);
            return byArray2;
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2 = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray2, 0);
        return this.signer.verifySignature(byArray2, byArray);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected void engineSetParameter(String string, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    protected Object engineGetParameter(String string) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    public static class withSha3_512
    extends SignatureSpi {
        public withSha3_512() {
            super(new SHA3Digest(512), new SPHINCS256Signer(new SHA3Digest(256), new SHA3Digest(512)));
        }
    }

    public static class withSha512
    extends SignatureSpi {
        public withSha512() {
            super(new SHA512Digest(), new SPHINCS256Signer(new SHA512tDigest(256), new SHA512Digest()));
        }
    }
}

