/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.xmss;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.pqc.asn1.XMSSKeyParams;
import com.timevale.tgtext.bouncycastle.pqc.asn1.XMSSPrivateKey;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.BDS;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.interfaces.XMSSKey;
import com.timevale.tgtext.bouncycastle.pqc.jcajce.provider.xmss.DigestUtil;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.PrivateKey;

public class BCXMSSPrivateKey
implements XMSSKey,
PrivateKey {
    private final XMSSPrivateKeyParameters keyParams;
    private final ASN1ObjectIdentifier treeDigest;

    public BCXMSSPrivateKey(ASN1ObjectIdentifier aSN1ObjectIdentifier, XMSSPrivateKeyParameters xMSSPrivateKeyParameters) {
        this.treeDigest = aSN1ObjectIdentifier;
        this.keyParams = xMSSPrivateKeyParameters;
    }

    public BCXMSSPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        XMSSKeyParams xMSSKeyParams = XMSSKeyParams.getInstance(privateKeyInfo.getPrivateKeyAlgorithm().getParameters());
        this.treeDigest = xMSSKeyParams.getTreeDigest().getAlgorithm();
        XMSSPrivateKey xMSSPrivateKey = XMSSPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        try {
            XMSSPrivateKeyParameters.Builder builder = new XMSSPrivateKeyParameters.Builder(new XMSSParameters(xMSSKeyParams.getHeight(), DigestUtil.getDigest(this.treeDigest))).withIndex(xMSSPrivateKey.getIndex()).withSecretKeySeed(xMSSPrivateKey.getSecretKeySeed()).withSecretKeyPRF(xMSSPrivateKey.getSecretKeyPRF()).withPublicSeed(xMSSPrivateKey.getPublicSeed()).withRoot(xMSSPrivateKey.getRoot());
            if (xMSSPrivateKey.getBdsState() != null) {
                builder.withBDSState((BDS)XMSSUtil.deserialize(xMSSPrivateKey.getBdsState()));
            }
            this.keyParams = builder.build();
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("ClassNotFoundException processing BDS state: " + classNotFoundException.getMessage());
        }
    }

    @Override
    public String getAlgorithm() {
        return "XMSS";
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public byte[] getEncoded() {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PQCObjectIdentifiers.xmss, new XMSSKeyParams(this.keyParams.getParameters().getHeight(), new AlgorithmIdentifier(this.treeDigest)));
            PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(algorithmIdentifier, this.createKeyStructure());
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCXMSSPrivateKey) {
            BCXMSSPrivateKey bCXMSSPrivateKey = (BCXMSSPrivateKey)object;
            return this.treeDigest.equals(bCXMSSPrivateKey.treeDigest) && Arrays.areEqual(this.keyParams.toByteArray(), bCXMSSPrivateKey.keyParams.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return this.treeDigest.hashCode() + 37 * Arrays.hashCode(this.keyParams.toByteArray());
    }

    CipherParameters getKeyParams() {
        return this.keyParams;
    }

    private XMSSPrivateKey createKeyStructure() {
        int n2;
        byte[] byArray = this.keyParams.toByteArray();
        int n3 = this.keyParams.getParameters().getDigestSize();
        int n4 = this.keyParams.getParameters().getHeight();
        if (!XMSSUtil.isIndexValid(n4, n2 = (int)XMSSUtil.bytesToXBigEndian(byArray, 0, 4))) {
            throw new IllegalArgumentException("index out of bounds");
        }
        byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, 4, n3);
        int n5 = n3 + 4;
        byte[] byArray3 = XMSSUtil.extractBytesAtOffset(byArray, n5, n3);
        byte[] byArray4 = XMSSUtil.extractBytesAtOffset(byArray, n5 += n3, n3);
        byte[] byArray5 = XMSSUtil.extractBytesAtOffset(byArray, n5 += n3, n3);
        byte[] byArray6 = XMSSUtil.extractBytesAtOffset(byArray, n5 += n3, byArray.length - n5);
        return new XMSSPrivateKey(n2, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    ASN1ObjectIdentifier getTreeDigestOID() {
        return this.treeDigest;
    }

    @Override
    public int getHeight() {
        return this.keyParams.getParameters().getHeight();
    }

    @Override
    public String getTreeDigest() {
        return DigestUtil.getXMSSDigestName(this.treeDigest);
    }
}

