/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.tsp.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.cms.AttributeTable;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.asn1.cms.Evidence;
import com.timevale.tgtext.bouncycastle.asn1.cms.TimeStampAndCRL;
import com.timevale.tgtext.bouncycastle.asn1.cms.TimeStampedData;
import com.timevale.tgtext.bouncycastle.asn1.cms.TimeStampedDataParser;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.cms.CMSException;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculator;
import com.timevale.tgtext.bouncycastle.operator.DigestCalculatorProvider;
import com.timevale.tgtext.bouncycastle.operator.OperatorCreationException;
import com.timevale.tgtext.bouncycastle.tsp.TSPException;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampTokenInfo;
import com.timevale.tgtext.bouncycastle.tsp.cms.ImprintDigestInvalidException;
import com.timevale.tgtext.bouncycastle.tsp.cms.MetaDataUtil;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.OutputStream;

class TimeStampDataUtil {
    private final TimeStampAndCRL[] timeStamps;
    private final MetaDataUtil metaDataUtil;

    TimeStampDataUtil(TimeStampedData timeStampedData) {
        this.metaDataUtil = new MetaDataUtil(timeStampedData.getMetaData());
        Evidence evidence = timeStampedData.getTemporalEvidence();
        this.timeStamps = evidence.getTstEvidence().toTimeStampAndCRLArray();
    }

    TimeStampDataUtil(TimeStampedDataParser timeStampedDataParser) throws IOException {
        this.metaDataUtil = new MetaDataUtil(timeStampedDataParser.getMetaData());
        Evidence evidence = timeStampedDataParser.getTemporalEvidence();
        this.timeStamps = evidence.getTstEvidence().toTimeStampAndCRLArray();
    }

    TimeStampToken getTimeStampToken(TimeStampAndCRL timeStampAndCRL) throws CMSException {
        ContentInfo contentInfo = timeStampAndCRL.getTimeStampToken();
        try {
            TimeStampToken timeStampToken = new TimeStampToken(contentInfo);
            return timeStampToken;
        }
        catch (IOException iOException) {
            throw new CMSException("unable to parse token data: " + iOException.getMessage(), iOException);
        }
        catch (TSPException tSPException) {
            TSPException tSPException2 = tSPException;
            if (tSPException.getCause() instanceof CMSException) {
                throw (CMSException)tSPException2.getCause();
            }
            throw new CMSException("token data invalid: " + tSPException2.getMessage(), tSPException2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("token data invalid: " + illegalArgumentException.getMessage(), illegalArgumentException);
        }
    }

    void initialiseMessageImprintDigestCalculator(DigestCalculator digestCalculator) throws CMSException {
        this.metaDataUtil.initialiseMessageImprintDigestCalculator(digestCalculator);
    }

    DigestCalculator getMessageImprintDigestCalculator(DigestCalculatorProvider digestCalculatorProvider) throws OperatorCreationException {
        try {
            TimeStampToken timeStampToken = this.getTimeStampToken(this.timeStamps[0]);
            TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
            ASN1ObjectIdentifier aSN1ObjectIdentifier = timeStampTokenInfo.getMessageImprintAlgOID();
            DigestCalculator digestCalculator = digestCalculatorProvider.get(new AlgorithmIdentifier(aSN1ObjectIdentifier));
            this.initialiseMessageImprintDigestCalculator(digestCalculator);
            return digestCalculator;
        }
        catch (CMSException cMSException) {
            throw new OperatorCreationException("unable to extract algorithm ID: " + cMSException.getMessage(), cMSException);
        }
    }

    TimeStampToken[] getTimeStampTokens() throws CMSException {
        TimeStampToken[] timeStampTokenArray = new TimeStampToken[this.timeStamps.length];
        for (int i2 = 0; i2 < this.timeStamps.length; ++i2) {
            timeStampTokenArray[i2] = this.getTimeStampToken(this.timeStamps[i2]);
        }
        return timeStampTokenArray;
    }

    TimeStampAndCRL[] getTimeStamps() {
        return this.timeStamps;
    }

    byte[] calculateNextHash(DigestCalculator digestCalculator) throws CMSException {
        TimeStampAndCRL timeStampAndCRL = this.timeStamps[this.timeStamps.length - 1];
        OutputStream outputStream = digestCalculator.getOutputStream();
        try {
            outputStream.write(timeStampAndCRL.getEncoded("DER"));
            outputStream.close();
            return digestCalculator.getDigest();
        }
        catch (IOException iOException) {
            throw new CMSException("exception calculating hash: " + iOException.getMessage(), iOException);
        }
    }

    void validate(DigestCalculatorProvider digestCalculatorProvider, byte[] byArray) throws ImprintDigestInvalidException, CMSException {
        byte[] byArray2 = byArray;
        for (int i2 = 0; i2 < this.timeStamps.length; ++i2) {
            try {
                TimeStampToken timeStampToken = this.getTimeStampToken(this.timeStamps[i2]);
                if (i2 > 0) {
                    TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
                    DigestCalculator digestCalculator = digestCalculatorProvider.get(timeStampTokenInfo.getHashAlgorithm());
                    digestCalculator.getOutputStream().write(this.timeStamps[i2 - 1].getEncoded("DER"));
                    byArray2 = digestCalculator.getDigest();
                }
                this.compareDigest(timeStampToken, byArray2);
                continue;
            }
            catch (IOException iOException) {
                throw new CMSException("exception calculating hash: " + iOException.getMessage(), iOException);
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("cannot create digest: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        }
    }

    void validate(DigestCalculatorProvider digestCalculatorProvider, byte[] byArray, TimeStampToken timeStampToken) throws ImprintDigestInvalidException, CMSException {
        byte[] byArray2;
        byte[] byArray3 = byArray;
        try {
            byArray2 = timeStampToken.getEncoded();
        }
        catch (IOException iOException) {
            throw new CMSException("exception encoding timeStampToken: " + iOException.getMessage(), iOException);
        }
        for (int i2 = 0; i2 < this.timeStamps.length; ++i2) {
            try {
                TimeStampToken timeStampToken2 = this.getTimeStampToken(this.timeStamps[i2]);
                if (i2 > 0) {
                    TimeStampTokenInfo timeStampTokenInfo = timeStampToken2.getTimeStampInfo();
                    DigestCalculator digestCalculator = digestCalculatorProvider.get(timeStampTokenInfo.getHashAlgorithm());
                    digestCalculator.getOutputStream().write(this.timeStamps[i2 - 1].getEncoded("DER"));
                    byArray3 = digestCalculator.getDigest();
                }
                this.compareDigest(timeStampToken2, byArray3);
                if (!Arrays.areEqual(timeStampToken2.getEncoded(), byArray2)) continue;
                return;
            }
            catch (IOException iOException) {
                throw new CMSException("exception calculating hash: " + iOException.getMessage(), iOException);
            }
            catch (OperatorCreationException operatorCreationException) {
                throw new CMSException("cannot create digest: " + operatorCreationException.getMessage(), operatorCreationException);
            }
        }
        throw new ImprintDigestInvalidException("passed in token not associated with timestamps present", timeStampToken);
    }

    private void compareDigest(TimeStampToken timeStampToken, byte[] byArray) throws ImprintDigestInvalidException {
        TimeStampTokenInfo timeStampTokenInfo = timeStampToken.getTimeStampInfo();
        byte[] byArray2 = timeStampTokenInfo.getMessageImprintDigest();
        if (!Arrays.areEqual(byArray, byArray2)) {
            throw new ImprintDigestInvalidException("hash calculated is different from MessageImprintDigest found in TimeStampToken", timeStampToken);
        }
    }

    String getFileName() {
        return this.metaDataUtil.getFileName();
    }

    String getMediaType() {
        return this.metaDataUtil.getMediaType();
    }

    AttributeTable getOtherMetaData() {
        return new AttributeTable(this.metaDataUtil.getOtherMetaData());
    }
}

