/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Enumerated;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OctetString;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DEROctetString;
import com.timevale.tgtext.bouncycastle.asn1.x509.AccessDescription;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AuthorityInformationAccess;
import com.timevale.tgtext.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.BasicConstraints;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLDistPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPointName;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralSubtree;
import com.timevale.tgtext.bouncycastle.asn1.x509.IssuingDistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.NameConstraints;
import com.timevale.tgtext.bouncycastle.asn1.x509.PolicyInformation;
import com.timevale.tgtext.bouncycastle.asn1.x509.qualified.MonetaryValue;
import com.timevale.tgtext.bouncycastle.asn1.x509.qualified.QCStatement;
import com.timevale.tgtext.bouncycastle.i18n.ErrorBundle;
import com.timevale.tgtext.bouncycastle.i18n.LocaleString;
import com.timevale.tgtext.bouncycastle.i18n.LocalizedMessage;
import com.timevale.tgtext.bouncycastle.i18n.filter.TrustedInput;
import com.timevale.tgtext.bouncycastle.i18n.filter.UntrustedInput;
import com.timevale.tgtext.bouncycastle.i18n.filter.UntrustedUrlInput;
import com.timevale.tgtext.bouncycastle.jce.provider.AnnotatedException;
import com.timevale.tgtext.bouncycastle.jce.provider.PKIXNameConstraintValidator;
import com.timevale.tgtext.bouncycastle.jce.provider.PKIXNameConstraintValidatorException;
import com.timevale.tgtext.bouncycastle.jce.provider.PKIXPolicyNode;
import com.timevale.tgtext.bouncycastle.util.Integers;
import com.timevale.tgtext.bouncycastle.x509.CertPathReviewerException;
import com.timevale.tgtext.bouncycastle.x509.CertPathValidatorUtilities;
import com.timevale.tgtext.bouncycastle.x509.X509CRLStoreSelector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PolicyNode;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;

public class PKIXCertPathReviewer
extends CertPathValidatorUtilities {
    private static final String QC_STATEMENT = Extension.qCStatements.getId();
    private static final String CRL_DIST_POINTS = Extension.cRLDistributionPoints.getId();
    private static final String AUTH_INFO_ACCESS = Extension.authorityInfoAccess.getId();
    private static final String RESOURCE_NAME = "com.timevale.tgtext.bouncycastle.x509.CertPathReviewerMessages";
    protected CertPath certPath;
    protected PKIXParameters pkixParams;
    protected Date validDate;
    protected List certs;
    protected int n;
    protected List[] notifications;
    protected List[] errors;
    protected TrustAnchor trustAnchor;
    protected PublicKey subjectPublicKey;
    protected PolicyNode policyTree;
    private boolean initialized;

    public void init(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathReviewerException {
        if (this.initialized) {
            throw new IllegalStateException("object is already initialized!");
        }
        this.initialized = true;
        if (certPath == null) {
            throw new NullPointerException("certPath was null");
        }
        this.certPath = certPath;
        this.certs = certPath.getCertificates();
        this.n = this.certs.size();
        if (this.certs.isEmpty()) {
            throw new CertPathReviewerException(new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.emptyCertPath"));
        }
        this.pkixParams = (PKIXParameters)pKIXParameters.clone();
        this.validDate = PKIXCertPathReviewer.getValidDate(this.pkixParams);
        this.notifications = null;
        this.errors = null;
        this.trustAnchor = null;
        this.subjectPublicKey = null;
        this.policyTree = null;
    }

    public PKIXCertPathReviewer(CertPath certPath, PKIXParameters pKIXParameters) throws CertPathReviewerException {
        this.init(certPath, pKIXParameters);
    }

    public PKIXCertPathReviewer() {
    }

    public CertPath getCertPath() {
        return this.certPath;
    }

    public int getCertPathSize() {
        return this.n;
    }

    public List[] getErrors() {
        this.doChecks();
        return this.errors;
    }

    public List getErrors(int n2) {
        this.doChecks();
        return this.errors[n2 + 1];
    }

    public List[] getNotifications() {
        this.doChecks();
        return this.notifications;
    }

    public List getNotifications(int n2) {
        this.doChecks();
        return this.notifications[n2 + 1];
    }

    public PolicyNode getPolicyTree() {
        this.doChecks();
        return this.policyTree;
    }

    public PublicKey getSubjectPublicKey() {
        this.doChecks();
        return this.subjectPublicKey;
    }

    public TrustAnchor getTrustAnchor() {
        this.doChecks();
        return this.trustAnchor;
    }

    public boolean isValidCertPath() {
        this.doChecks();
        boolean bl2 = true;
        for (int i2 = 0; i2 < this.errors.length; ++i2) {
            if (this.errors[i2].isEmpty()) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    protected void addNotification(ErrorBundle errorBundle) {
        this.notifications[0].add(errorBundle);
    }

    protected void addNotification(ErrorBundle errorBundle, int n2) {
        if (n2 < -1 || n2 >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.notifications[n2 + 1].add(errorBundle);
    }

    protected void addError(ErrorBundle errorBundle) {
        this.errors[0].add(errorBundle);
    }

    protected void addError(ErrorBundle errorBundle, int n2) {
        if (n2 < -1 || n2 >= this.n) {
            throw new IndexOutOfBoundsException();
        }
        this.errors[n2 + 1].add(errorBundle);
    }

    protected void doChecks() {
        if (!this.initialized) {
            throw new IllegalStateException("Object not initialized. Call init() first.");
        }
        if (this.notifications == null) {
            this.notifications = new List[this.n + 1];
            this.errors = new List[this.n + 1];
            for (int i2 = 0; i2 < this.notifications.length; ++i2) {
                this.notifications[i2] = new ArrayList();
                this.errors[i2] = new ArrayList();
            }
            this.checkSignatures();
            this.checkNameConstraints();
            this.checkPathLength();
            this.checkPolicy();
            this.checkCriticalExtensions();
        }
    }

    private void checkNameConstraints() {
        PKIXNameConstraintValidator pKIXNameConstraintValidator = new PKIXNameConstraintValidator();
        try {
            for (int i2 = this.certs.size() - 1; i2 > 0; --i2) {
                int n2;
                Object object;
                GeneralSubtree[] generalSubtreeArray;
                Object object2;
                Object object3;
                X509Certificate x509Certificate = (X509Certificate)this.certs.get(i2);
                if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                    Object object4;
                    object3 = PKIXCertPathReviewer.getSubjectPrincipal(x509Certificate);
                    object2 = new ASN1InputStream(new ByteArrayInputStream(((X500Principal)object3).getEncoded()));
                    try {
                        generalSubtreeArray = (ASN1Sequence)((ASN1InputStream)object2).readObject();
                    }
                    catch (IOException iOException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncSubjectNameError", new Object[]{new UntrustedInput(object3)});
                        throw new CertPathReviewerException(errorBundle, (Throwable)iOException, this.certPath, i2);
                    }
                    try {
                        pKIXNameConstraintValidator.checkPermittedDN((ASN1Sequence)generalSubtreeArray);
                    }
                    catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedDN", new Object[]{new UntrustedInput(((X500Principal)object3).getName())});
                        throw new CertPathReviewerException(errorBundle, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i2);
                    }
                    try {
                        pKIXNameConstraintValidator.checkExcludedDN((ASN1Sequence)generalSubtreeArray);
                    }
                    catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.excludedDN", new Object[]{new UntrustedInput(((X500Principal)object3).getName())});
                        throw new CertPathReviewerException(errorBundle, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i2);
                    }
                    try {
                        object = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, SUBJECT_ALTERNATIVE_NAME);
                    }
                    catch (AnnotatedException annotatedException) {
                        object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.subjAltNameExtError");
                        throw new CertPathReviewerException((ErrorBundle)object4, (Throwable)annotatedException, this.certPath, i2);
                    }
                    if (object != null) {
                        for (n2 = 0; n2 < ((ASN1Sequence)object).size(); ++n2) {
                            object4 = GeneralName.getInstance(((ASN1Sequence)object).getObjectAt(n2));
                            try {
                                pKIXNameConstraintValidator.checkPermitted((GeneralName)object4);
                                pKIXNameConstraintValidator.checkExcluded((GeneralName)object4);
                                continue;
                            }
                            catch (PKIXNameConstraintValidatorException pKIXNameConstraintValidatorException) {
                                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notPermittedEmail", new Object[]{new UntrustedInput(object4)});
                                throw new CertPathReviewerException(errorBundle, (Throwable)pKIXNameConstraintValidatorException, this.certPath, i2);
                            }
                        }
                    }
                }
                try {
                    object3 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, NAME_CONSTRAINTS);
                }
                catch (AnnotatedException annotatedException) {
                    generalSubtreeArray = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ncExtError");
                    throw new CertPathReviewerException((ErrorBundle)generalSubtreeArray, (Throwable)annotatedException, this.certPath, i2);
                }
                if (object3 == null) continue;
                object2 = NameConstraints.getInstance(object3);
                generalSubtreeArray = ((NameConstraints)object2).getPermittedSubtrees();
                if (generalSubtreeArray != null) {
                    pKIXNameConstraintValidator.intersectPermittedSubtree(generalSubtreeArray);
                }
                if ((object = ((NameConstraints)object2).getExcludedSubtrees()) == null) continue;
                for (n2 = 0; n2 != ((GeneralSubtree[])object).length; ++n2) {
                    pKIXNameConstraintValidator.addExcludedSubtree(object[n2]);
                }
            }
            return;
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
            return;
        }
    }

    private void checkPathLength() {
        int n2 = this.n;
        int n3 = 0;
        for (int i2 = this.certs.size() - 1; i2 > 0; --i2) {
            int n4;
            BigInteger bigInteger;
            Object object;
            X509Certificate x509Certificate = (X509Certificate)this.certs.get(i2);
            if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                if (n2 <= 0) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pathLengthExtended");
                    this.addError((ErrorBundle)object);
                }
                --n2;
                ++n3;
            }
            try {
                object = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.processLengthConstError");
                this.addError(errorBundle, i2);
                object = null;
            }
            if (object == null || (bigInteger = ((BasicConstraints)object).getPathLenConstraint()) == null || (n4 = bigInteger.intValue()) >= n2) continue;
            n2 = n4;
        }
        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.totalPathLength", new Object[]{Integers.valueOf(n3)});
        this.addNotification(errorBundle);
    }

    private void checkSignatures() {
        AlgorithmIdentifier algorithmIdentifier;
        Object object;
        Object object2;
        TrustAnchor trustAnchor = null;
        Object object3 = null;
        Object object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathValidDate", new Object[]{new TrustedInput(this.validDate), new TrustedInput(new Date())});
        this.addNotification((ErrorBundle)object4);
        try {
            object4 = (X509Certificate)this.certs.get(this.certs.size() - 1);
            object2 = this.getTrustAnchors((X509Certificate)object4, this.pkixParams.getTrustAnchors());
            if (object2.size() > 1) {
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.conflictingTrustAnchors", new Object[]{Integers.valueOf(object2.size()), new UntrustedInput(((X509Certificate)object4).getIssuerX500Principal())});
                this.addError((ErrorBundle)object);
            } else if (object2.isEmpty()) {
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noTrustAnchorFound", new Object[]{new UntrustedInput(((X509Certificate)object4).getIssuerX500Principal()), Integers.valueOf(this.pkixParams.getTrustAnchors().size())});
                this.addError((ErrorBundle)object);
            } else {
                trustAnchor = (TrustAnchor)object2.iterator().next();
                object = trustAnchor.getTrustedCert() != null ? trustAnchor.getTrustedCert().getPublicKey() : trustAnchor.getCAPublicKey();
                try {
                    CertPathValidatorUtilities.verifyX509Certificate((X509Certificate)object4, (PublicKey)object, this.pkixParams.getSigProvider());
                }
                catch (SignatureException signatureException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustButInvalidCert");
                    this.addError(errorBundle);
                }
                catch (Exception exception) {}
            }
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage());
        }
        catch (Throwable throwable) {
            object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknown", new Object[]{new UntrustedInput(throwable.getMessage()), new UntrustedInput(throwable)});
            this.addError((ErrorBundle)object2);
        }
        if (trustAnchor != null) {
            object4 = trustAnchor.getTrustedCert();
            try {
                object3 = object4 != null ? PKIXCertPathReviewer.getSubjectPrincipal((X509Certificate)object4) : new X500Principal(trustAnchor.getCAName());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustDNInvalid", new Object[]{new UntrustedInput(trustAnchor.getCAName())});
                this.addError((ErrorBundle)object);
            }
            if (object4 != null) {
                boolean[] blArray = ((X509Certificate)object4).getKeyUsage();
                object2 = blArray;
                if (blArray != null && object2[5] == false) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustKeyUsage");
                    this.addNotification((ErrorBundle)object);
                }
            }
        }
        object4 = null;
        object2 = object3;
        object = null;
        if (trustAnchor != null) {
            object = trustAnchor.getTrustedCert();
            object4 = object != null ? ((Certificate)object).getPublicKey() : trustAnchor.getCAPublicKey();
            try {
                algorithmIdentifier = PKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)object4);
                algorithmIdentifier.getAlgorithm();
                algorithmIdentifier.getParameters();
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustPubKeyError");
                this.addError(errorBundle);
            }
        }
        for (int i2 = this.certs.size() - 1; i2 >= 0; --i2) {
            Object object5;
            Iterator iterator;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            int n2 = this.n - i2;
            X509Certificate x509Certificate = (X509Certificate)this.certs.get(i2);
            if (object4 != null) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(x509Certificate, (PublicKey)object4, this.pkixParams.getSigProvider());
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{generalSecurityException.getMessage(), generalSecurityException, generalSecurityException.getClass().getName()});
                    this.addError((ErrorBundle)object9, i2);
                }
            } else if (PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                try {
                    CertPathValidatorUtilities.verifyX509Certificate(x509Certificate, x509Certificate.getPublicKey(), this.pkixParams.getSigProvider());
                    object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.rootKeyIsValidButNotATrustAnchor");
                    this.addError((ErrorBundle)object8, i2);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.signatureNotVerified", new Object[]{generalSecurityException.getMessage(), generalSecurityException, generalSecurityException.getClass().getName()});
                    this.addError((ErrorBundle)object9, i2);
                }
            } else {
                object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.NoIssuerPublicKey");
                object9 = x509Certificate.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                if (object9 != null && (object7 = ((AuthorityKeyIdentifier)(object6 = AuthorityKeyIdentifier.getInstance(DEROctetString.getInstance(object9).getOctets()))).getAuthorityCertIssuer()) != null) {
                    iterator = ((GeneralNames)object7).getNames()[0];
                    object5 = ((AuthorityKeyIdentifier)object6).getAuthorityCertSerialNumber();
                    if (object5 != null) {
                        Object[] objectArray = new Object[]{new LocaleString(RESOURCE_NAME, "missingIssuer"), " \"", iterator, "\" ", new LocaleString(RESOURCE_NAME, "missingSerial"), " ", object5};
                        ((LocalizedMessage)object8).setExtraArguments(objectArray);
                    }
                }
                this.addError((ErrorBundle)object8, i2);
            }
            try {
                x509Certificate.checkValidity(this.validDate);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateNotYetValid", new Object[]{new TrustedInput(x509Certificate.getNotBefore())});
                this.addError((ErrorBundle)object9, i2);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certificateExpired", new Object[]{new TrustedInput(x509Certificate.getNotAfter())});
                this.addError((ErrorBundle)object9, i2);
            }
            if (this.pkixParams.isRevocationEnabled()) {
                object8 = null;
                try {
                    ASN1Primitive aSN1Primitive = PKIXCertPathReviewer.getExtensionValue(x509Certificate, CRL_DIST_POINTS);
                    object9 = aSN1Primitive;
                    if (aSN1Primitive != null) {
                        object8 = CRLDistPoint.getInstance(object9);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlDistPtExtError");
                    this.addError((ErrorBundle)object6, i2);
                }
                object9 = null;
                try {
                    object6 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, AUTH_INFO_ACCESS);
                    if (object6 != null) {
                        object9 = AuthorityInformationAccess.getInstance(object6);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlAuthInfoAccError");
                    this.addError((ErrorBundle)object7, i2);
                }
                object6 = this.getCRLDistUrls((CRLDistPoint)object8);
                object7 = this.getOCSPUrls((AuthorityInformationAccess)object9);
                iterator = ((Vector)object6).iterator();
                while (iterator.hasNext()) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlDistPoint", new Object[]{new UntrustedUrlInput(iterator.next())});
                    this.addNotification((ErrorBundle)object5, i2);
                }
                iterator = ((Vector)object7).iterator();
                while (iterator.hasNext()) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.ocspLocation", new Object[]{new UntrustedUrlInput(iterator.next())});
                    this.addNotification((ErrorBundle)object5, i2);
                }
                try {
                    this.checkRevocation(this.pkixParams, x509Certificate, this.validDate, (X509Certificate)object, (PublicKey)object4, (Vector)object6, (Vector)object7, i2);
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    this.addError(certPathReviewerException.getErrorMessage(), i2);
                }
            }
            if (object2 != null && !x509Certificate.getIssuerX500Principal().equals(object2)) {
                object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certWrongIssuer", new Object[]{((X500Principal)object2).getName(), x509Certificate.getIssuerX500Principal().getName()});
                this.addError((ErrorBundle)object8, i2);
            }
            if (n2 != this.n) {
                if (x509Certificate != null && x509Certificate.getVersion() == 1) {
                    object8 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                    this.addError((ErrorBundle)object8, i2);
                }
                try {
                    object8 = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
                    if (object8 != null) {
                        if (!((BasicConstraints)object8).isCA()) {
                            object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCACert");
                            this.addError((ErrorBundle)object9, i2);
                        }
                    } else {
                        object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noBasicConstraints");
                        this.addError((ErrorBundle)object9, i2);
                    }
                }
                catch (AnnotatedException annotatedException) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.errorProcesingBC");
                    this.addError((ErrorBundle)object6, i2);
                }
                boolean[] blArray = x509Certificate.getKeyUsage();
                object9 = blArray;
                if (blArray != null && object9[5] == 0) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCertSign");
                    this.addError((ErrorBundle)object6, i2);
                }
            }
            object = x509Certificate;
            object2 = x509Certificate.getSubjectX500Principal();
            try {
                object4 = PKIXCertPathReviewer.getNextWorkingKey(this.certs, i2);
                algorithmIdentifier = PKIXCertPathReviewer.getAlgorithmIdentifier((PublicKey)object4);
                algorithmIdentifier.getAlgorithm();
                algorithmIdentifier.getParameters();
                continue;
            }
            catch (CertPathValidatorException certPathValidatorException) {
                object9 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.pubKeyError");
                this.addError((ErrorBundle)object9, i2);
            }
        }
        this.trustAnchor = trustAnchor;
        this.subjectPublicKey = object4;
    }

    /*
     * WARNING - void declaration
     */
    private void checkPolicy() {
        Set<String> set = this.pkixParams.getInitialPolicies();
        List[] listArray = new ArrayList[this.n + 1];
        for (int i2 = 0; i2 < listArray.length; ++i2) {
            listArray[i2] = new ArrayList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("2.5.29.32.0");
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet, null, new HashSet(), "2.5.29.32.0", false);
        listArray[0].add(pKIXPolicyNode);
        int n2 = this.pkixParams.isExplicitPolicyRequired() ? 0 : this.n + 1;
        int n3 = this.pkixParams.isAnyPolicyInhibited() ? 0 : this.n + 1;
        int n4 = this.pkixParams.isPolicyMappingInhibited() ? 0 : this.n + 1;
        Object object = null;
        X509Certificate x509Certificate = null;
        try {
            Object certPathValidatorException;
            Object object3;
            Object object4;
            Object object5;
            int n5;
            for (n5 = this.certs.size() - 1; n5 >= 0; --n5) {
                int n6 = this.n - n5;
                x509Certificate = (X509Certificate)this.certs.get(n5);
                try {
                    object5 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, CERTIFICATE_POLICIES);
                }
                catch (AnnotatedException annotatedException) {
                    object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                    throw new CertPathReviewerException((ErrorBundle)object4, (Throwable)annotatedException, this.certPath, n5);
                }
                if (object5 != null && pKIXPolicyNode != null) {
                    boolean n7;
                    Object object6;
                    Object object7;
                    Object object8;
                    object3 = ((ASN1Sequence)object5).getObjects();
                    object4 = new HashSet();
                    while (object3.hasMoreElements()) {
                        object8 = PolicyInformation.getInstance(object3.nextElement());
                        object7 = ((PolicyInformation)object8).getPolicyIdentifier();
                        object4.add(((ASN1ObjectIdentifier)object7).getId());
                        if ("2.5.29.32.0".equals(((ASN1ObjectIdentifier)object7).getId())) continue;
                        try {
                            object6 = PKIXCertPathReviewer.getQualifierSet(((PolicyInformation)object8).getPolicyQualifiers());
                        }
                        catch (CertPathValidatorException certPathValidatorException2) {
                            certPathValidatorException = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                            throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, (Throwable)certPathValidatorException2, this.certPath, n5);
                        }
                        n7 = PKIXCertPathReviewer.processCertD1i(n6, listArray, (ASN1ObjectIdentifier)object7, object6);
                        if (n7) continue;
                        PKIXCertPathReviewer.processCertD1ii(n6, listArray, (ASN1ObjectIdentifier)object7, object6);
                    }
                    if (object == null || object.contains("2.5.29.32.0")) {
                        object = object4;
                    } else {
                        object8 = object.iterator();
                        object7 = new HashSet();
                        while (object8.hasNext()) {
                            object6 = object8.next();
                            if (!object4.contains(object6)) continue;
                            object7.add(object6);
                        }
                        object = object7;
                    }
                    if (n3 > 0 || n6 < this.n && PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                        object3 = ((ASN1Sequence)object5).getObjects();
                        while (object3.hasMoreElements()) {
                            void pKIXPolicyNode3;
                            object8 = PolicyInformation.getInstance(object3.nextElement());
                            if (!"2.5.29.32.0".equals(((PolicyInformation)object8).getPolicyIdentifier().getId())) continue;
                            try {
                                object7 = PKIXCertPathReviewer.getQualifierSet(((PolicyInformation)object8).getPolicyQualifiers());
                            }
                            catch (CertPathValidatorException certPathValidatorException3) {
                                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException3, this.certPath, n5);
                            }
                            object6 = listArray[n6 - 1];
                            n7 = false;
                            while (pKIXPolicyNode3 < object6.size()) {
                                certPathValidatorException = (PKIXPolicyNode)object6.get((int)pKIXPolicyNode3);
                                for (Set set2 : ((PKIXPolicyNode)certPathValidatorException).getExpectedPolicies()) {
                                    Object object2;
                                    String string;
                                    if (set2 instanceof String) {
                                        string = (String)((Object)set2);
                                    } else {
                                        if (!(set2 instanceof ASN1ObjectIdentifier)) continue;
                                        string = ((ASN1ObjectIdentifier)((Object)set2)).getId();
                                    }
                                    boolean bl2 = false;
                                    Iterator iterator = ((PKIXPolicyNode)certPathValidatorException).getChildren();
                                    while (iterator.hasNext()) {
                                        object2 = (PKIXPolicyNode)iterator.next();
                                        if (!string.equals(((PKIXPolicyNode)object2).getValidPolicy())) continue;
                                        bl2 = true;
                                    }
                                    if (bl2) continue;
                                    object2 = new HashSet<String>();
                                    object2.add(string);
                                    PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n6, (Set)object2, (PolicyNode)certPathValidatorException, (Set)object7, string, false);
                                    ((PKIXPolicyNode)certPathValidatorException).addChild(pKIXPolicyNode2);
                                    listArray[n6].add(pKIXPolicyNode2);
                                }
                                ++pKIXPolicyNode3;
                            }
                            break block30;
                        }
                    }
                    for (int i3 = n6 - 1; i3 >= 0; --i3) {
                        PKIXPolicyNode i5;
                        object7 = listArray[i3];
                        for (int i4 = 0; i4 < object7.size() && ((i5 = (PKIXPolicyNode)object7.get(i4)).hasChildren() || (pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode(pKIXPolicyNode, listArray, i5)) != null); ++i4) {
                        }
                    }
                    Set<String> set3 = x509Certificate.getCriticalExtensionOIDs();
                    if (set3 != null) {
                        void aSN1Sequence;
                        boolean bl3 = set3.contains(CERTIFICATE_POLICIES);
                        List list = listArray[n6];
                        boolean aSN1ObjectIdentifier2 = false;
                        while (aSN1Sequence < list.size()) {
                            certPathValidatorException = (PKIXPolicyNode)list.get((int)aSN1Sequence);
                            ((PKIXPolicyNode)certPathValidatorException).setCritical(bl3);
                            ++aSN1Sequence;
                        }
                    }
                }
                if (object5 == null) {
                    pKIXPolicyNode = null;
                }
                if (n2 <= 0 && pKIXPolicyNode == null) {
                    object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noValidPolicyTree");
                    throw new CertPathReviewerException((ErrorBundle)object3);
                }
                if (n6 == this.n) continue;
                try {
                    object3 = PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_MAPPINGS);
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyMapExtError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException, this.certPath, n5);
                }
                if (object3 != null) {
                    object4 = (ASN1Sequence)object3;
                    for (int i6 = 0; i6 < ((ASN1Sequence)object4).size(); ++i6) {
                        ASN1Sequence aSN1Sequence = (ASN1Sequence)((ASN1Sequence)object4).getObjectAt(i6);
                        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(0);
                        ASN1ObjectIdentifier string = (ASN1ObjectIdentifier)aSN1Sequence.getObjectAt(1);
                        if ("2.5.29.32.0".equals(aSN1ObjectIdentifier.getId())) {
                            certPathValidatorException = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                            throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, this.certPath, n5);
                        }
                        if (!"2.5.29.32.0".equals(string.getId())) continue;
                        certPathValidatorException = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicyMapping");
                        throw new CertPathReviewerException((ErrorBundle)certPathValidatorException, this.certPath, n5);
                    }
                }
                if (object3 != null) {
                    Iterator iterator;
                    object4 = (ASN1Sequence)object3;
                    HashMap hashMap = new HashMap();
                    HashSet<Object> hashSet2 = new HashSet<Object>();
                    for (int i7 = 0; i7 < ((ASN1Sequence)object4).size(); ++i7) {
                        Set set2;
                        ASN1Sequence iterator2 = (ASN1Sequence)((ASN1Sequence)object4).getObjectAt(i7);
                        certPathValidatorException = ((ASN1ObjectIdentifier)iterator2.getObjectAt(0)).getId();
                        iterator = ((ASN1ObjectIdentifier)iterator2.getObjectAt(1)).getId();
                        if (!hashMap.containsKey(certPathValidatorException)) {
                            set2 = new HashSet();
                            set2.add(iterator);
                            hashMap.put(certPathValidatorException, set2);
                            hashSet2.add(certPathValidatorException);
                            continue;
                        }
                        set2 = (Set)hashMap.get(certPathValidatorException);
                        set2.add(iterator);
                    }
                    for (String pKIXPolicyNode6 : hashSet2) {
                        if (n4 > 0) {
                            try {
                                PKIXCertPathReviewer.prepareNextCertB1(n6, listArray, pKIXPolicyNode6, hashMap, x509Certificate);
                                continue;
                            }
                            catch (AnnotatedException annotatedException) {
                                iterator = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyExtError");
                                throw new CertPathReviewerException((ErrorBundle)((Object)iterator), (Throwable)annotatedException, this.certPath, n5);
                            }
                            catch (CertPathValidatorException certPathValidatorException4) {
                                iterator = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyQualifierError");
                                throw new CertPathReviewerException((ErrorBundle)((Object)iterator), (Throwable)certPathValidatorException4, this.certPath, n5);
                            }
                        }
                        if (n4 > 0) continue;
                        pKIXPolicyNode = PKIXCertPathReviewer.prepareNextCertB2(n6, listArray, pKIXPolicyNode6, pKIXPolicyNode);
                    }
                }
                if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate)) {
                    if (n2 != 0) {
                        --n2;
                    }
                    if (n4 != 0) {
                        --n4;
                    }
                    if (n3 != 0) {
                        --n3;
                    }
                }
                try {
                    object4 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS);
                    if (object4 != null) {
                        Enumeration enumeration = ((ASN1Sequence)object4).getObjects();
                        while (enumeration.hasMoreElements()) {
                            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                            switch (aSN1TaggedObject.getTagNo()) {
                                case 0: {
                                    int n8 = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue().intValue();
                                    if (n8 >= n2) break;
                                    n2 = n8;
                                    break;
                                }
                                case 1: {
                                    int n8 = ASN1Integer.getInstance(aSN1TaggedObject, false).getValue().intValue();
                                    if (n8 >= n4) break;
                                    n4 = n8;
                                }
                            }
                        }
                    }
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                    throw new CertPathReviewerException(errorBundle, this.certPath, n5);
                }
                try {
                    int n9;
                    object4 = (ASN1Integer)PKIXCertPathReviewer.getExtensionValue(x509Certificate, INHIBIT_ANY_POLICY);
                    if (object4 == null || (n9 = ((ASN1Integer)object4).getValue().intValue()) >= n3) continue;
                    n3 = n9;
                    continue;
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyInhibitExtError");
                    throw new CertPathReviewerException(errorBundle, this.certPath, n5);
                }
            }
            if (!PKIXCertPathReviewer.isSelfIssued(x509Certificate) && n2 > 0) {
                --n2;
            }
            try {
                object5 = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, POLICY_CONSTRAINTS);
                if (object5 != null) {
                    object3 = ((ASN1Sequence)object5).getObjects();
                    while (object3.hasMoreElements()) {
                        object4 = (ASN1TaggedObject)object3.nextElement();
                        switch (((ASN1TaggedObject)object4).getTagNo()) {
                            case 0: {
                                int n10 = ASN1Integer.getInstance((ASN1TaggedObject)object4, false).getValue().intValue();
                                if (n10 != 0) break;
                                n2 = 0;
                            }
                        }
                    }
                }
            }
            catch (AnnotatedException annotatedException) {
                object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.policyConstExtError");
                throw new CertPathReviewerException((ErrorBundle)object3, this.certPath, n5);
            }
            if (pKIXPolicyNode == null) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                    throw new CertPathReviewerException((ErrorBundle)object3, this.certPath, n5);
                }
                object5 = null;
            } else if (PKIXCertPathReviewer.isAnyPolicy(set)) {
                if (this.pkixParams.isExplicitPolicyRequired()) {
                    if (object.isEmpty()) {
                        object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.explicitPolicy");
                        throw new CertPathReviewerException((ErrorBundle)object3, this.certPath, n5);
                    }
                    object3 = new HashSet();
                    for (int i8 = 0; i8 < listArray.length; ++i8) {
                        ArrayList arrayList = listArray[i8];
                        for (int i9 = 0; i9 < arrayList.size(); ++i9) {
                            PKIXPolicyNode pKIXPolicyNode4 = (PKIXPolicyNode)arrayList.get(i9);
                            if (!"2.5.29.32.0".equals(pKIXPolicyNode4.getValidPolicy())) continue;
                            Iterator iterator = pKIXPolicyNode4.getChildren();
                            while (iterator.hasNext()) {
                                object3.add(iterator.next());
                            }
                        }
                    }
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        PKIXPolicyNode pKIXPolicyNode5 = (PKIXPolicyNode)iterator.next();
                        String string = pKIXPolicyNode5.getValidPolicy();
                        object.contains(string);
                    }
                    if (pKIXPolicyNode != null) {
                        for (int i10 = this.n - 1; i10 >= 0; --i10) {
                            List list = listArray[i10];
                            for (int i11 = 0; i11 < list.size(); ++i11) {
                                PKIXPolicyNode pKIXPolicyNode9 = (PKIXPolicyNode)list.get(i11);
                                if (pKIXPolicyNode9.hasChildren()) continue;
                                pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode9);
                            }
                        }
                    }
                }
                object5 = pKIXPolicyNode;
            } else {
                object3 = new HashSet();
                for (int i12 = 0; i12 < listArray.length; ++i12) {
                    ArrayList arrayList = listArray[i12];
                    for (int i13 = 0; i13 < arrayList.size(); ++i13) {
                        PKIXPolicyNode pKIXPolicyNode7 = (PKIXPolicyNode)arrayList.get(i13);
                        if (!"2.5.29.32.0".equals(pKIXPolicyNode7.getValidPolicy())) continue;
                        Iterator iterator = pKIXPolicyNode7.getChildren();
                        while (iterator.hasNext()) {
                            certPathValidatorException = (PKIXPolicyNode)iterator.next();
                            if ("2.5.29.32.0".equals(((PKIXPolicyNode)certPathValidatorException).getValidPolicy())) continue;
                            object3.add(certPathValidatorException);
                        }
                    }
                }
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode8 = (PKIXPolicyNode)iterator.next();
                    String string = pKIXPolicyNode8.getValidPolicy();
                    if (set.contains(string)) continue;
                    pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode8);
                }
                if (pKIXPolicyNode != null) {
                    for (int i14 = this.n - 1; i14 >= 0; --i14) {
                        ArrayList arrayList = listArray[i14];
                        for (int i15 = 0; i15 < arrayList.size(); ++i15) {
                            PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)arrayList.get(i15);
                            if (pKIXPolicyNode3.hasChildren()) continue;
                            pKIXPolicyNode = PKIXCertPathReviewer.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode3);
                        }
                    }
                }
                object5 = pKIXPolicyNode;
            }
            if (n2 <= 0 && object5 == null) {
                object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.invalidPolicy");
                throw new CertPathReviewerException((ErrorBundle)object3);
            }
            return;
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
            return;
        }
    }

    private void checkCriticalExtensions() {
        List<PKIXCertPathChecker> list = this.pkixParams.getCertPathCheckers();
        Iterator<PKIXCertPathChecker> iterator = list.iterator();
        try {
            try {
                while (iterator.hasNext()) {
                    iterator.next().init(false);
                }
            }
            catch (CertPathValidatorException certPathValidatorException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certPathCheckerError", new Object[]{certPathValidatorException.getMessage(), certPathValidatorException, certPathValidatorException.getClass().getName()});
                throw new CertPathReviewerException(errorBundle, (Throwable)certPathValidatorException);
            }
            for (int i2 = this.certs.size() - 1; i2 >= 0; --i2) {
                Object object;
                X509Certificate x509Certificate = (X509Certificate)this.certs.get(i2);
                Set<String> set = x509Certificate.getCriticalExtensionOIDs();
                if (set == null || set.isEmpty()) continue;
                set.remove(KEY_USAGE);
                set.remove(CERTIFICATE_POLICIES);
                set.remove(POLICY_MAPPINGS);
                set.remove(INHIBIT_ANY_POLICY);
                set.remove(ISSUING_DISTRIBUTION_POINT);
                set.remove(DELTA_CRL_INDICATOR);
                set.remove(POLICY_CONSTRAINTS);
                set.remove(BASIC_CONSTRAINTS);
                set.remove(SUBJECT_ALTERNATIVE_NAME);
                set.remove(NAME_CONSTRAINTS);
                if (set.contains(QC_STATEMENT) && this.processQcStatements(x509Certificate, i2)) {
                    set.remove(QC_STATEMENT);
                }
                Iterator<PKIXCertPathChecker> iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    try {
                        iterator2.next().check(x509Certificate, set);
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.criticalExtensionError", new Object[]{certPathValidatorException.getMessage(), certPathValidatorException, certPathValidatorException.getClass().getName()});
                        throw new CertPathReviewerException((ErrorBundle)object, certPathValidatorException.getCause(), this.certPath, i2);
                    }
                }
                if (set.isEmpty()) continue;
                object = set.iterator();
                while (object.hasNext()) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.unknownCriticalExt", new Object[]{new ASN1ObjectIdentifier(object.next())});
                    this.addError(errorBundle, i2);
                }
            }
            return;
        }
        catch (CertPathReviewerException certPathReviewerException) {
            this.addError(certPathReviewerException.getErrorMessage(), certPathReviewerException.getIndex());
            return;
        }
    }

    private boolean processQcStatements(X509Certificate x509Certificate, int n2) {
        try {
            boolean bl2 = false;
            ASN1Sequence aSN1Sequence = (ASN1Sequence)PKIXCertPathReviewer.getExtensionValue(x509Certificate, QC_STATEMENT);
            for (int i2 = 0; i2 < aSN1Sequence.size(); ++i2) {
                Object object;
                QCStatement qCStatement = QCStatement.getInstance(aSN1Sequence.getObjectAt(i2));
                if (QCStatement.id_etsi_qcs_QcCompliance.equals(qCStatement.getStatementId())) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcEuCompliance");
                    this.addNotification((ErrorBundle)object, n2);
                    continue;
                }
                if (QCStatement.id_qcs_pkixQCSyntax_v1.equals(qCStatement.getStatementId())) continue;
                if (QCStatement.id_etsi_qcs_QcSSCD.equals(qCStatement.getStatementId())) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcSSCD");
                    this.addNotification((ErrorBundle)object, n2);
                    continue;
                }
                if (QCStatement.id_etsi_qcs_LimiteValue.equals(qCStatement.getStatementId())) {
                    object = MonetaryValue.getInstance(qCStatement.getStatementInfo());
                    ((MonetaryValue)object).getCurrency();
                    double d2 = ((MonetaryValue)object).getAmount().doubleValue() * Math.pow(10.0, ((MonetaryValue)object).getExponent().doubleValue());
                    ErrorBundle errorBundle = ((MonetaryValue)object).getCurrency().isAlphabetic() ? new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueAlpha", new Object[]{((MonetaryValue)object).getCurrency().getAlphabetic(), new TrustedInput(new Double(d2)), object}) : new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcLimitValueNum", new Object[]{Integers.valueOf(((MonetaryValue)object).getCurrency().getNumeric()), new TrustedInput(new Double(d2)), object});
                    this.addNotification(errorBundle, n2);
                    continue;
                }
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcUnknownStatement", new Object[]{qCStatement.getStatementId(), new UntrustedInput(qCStatement)});
                this.addNotification((ErrorBundle)object, n2);
                bl2 = true;
            }
            return !bl2;
        }
        catch (AnnotatedException annotatedException) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.QcStatementExtError");
            this.addError(errorBundle, n2);
            return false;
        }
    }

    private String IPtoString(byte[] byArray) {
        String string;
        try {
            string = InetAddress.getByAddress(byArray).getHostAddress();
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 != byArray.length; ++i2) {
                stringBuffer.append(Integer.toHexString(byArray[i2] & 0xFF));
                stringBuffer.append(' ');
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    protected void checkRevocation(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, Vector vector, Vector vector2, int n2) throws CertPathReviewerException {
        this.checkCRLs(pKIXParameters, x509Certificate, date, x509Certificate2, publicKey, vector, n2);
    }

    protected void checkCRLs(PKIXParameters pKIXParameters, X509Certificate x509Certificate, Date date, X509Certificate x509Certificate2, PublicKey publicKey, Vector vector, int n2) throws CertPathReviewerException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Iterator iterator;
        X509CRLStoreSelector x509CRLStoreSelector = new X509CRLStoreSelector();
        try {
            x509CRLStoreSelector.addIssuerName(PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
        }
        catch (IOException iOException) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlIssuerException");
            throw new CertPathReviewerException(errorBundle, (Throwable)iOException);
        }
        x509CRLStoreSelector.setCertificateChecking(x509Certificate);
        try {
            Set set = CRL_UTIL.findCRLs(x509CRLStoreSelector, pKIXParameters);
            iterator = set.iterator();
            if (set.isEmpty()) {
                set = CRL_UTIL.findCRLs(new X509CRLStoreSelector(), pKIXParameters);
                object4 = set.iterator();
                object3 = new ArrayList<X500Principal>();
                while (object4.hasNext()) {
                    object3.add(((X509CRL)object4.next()).getIssuerX500Principal());
                }
                int n3 = object3.size();
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCrlInCertstore", new Object[]{new UntrustedInput(x509CRLStoreSelector.getIssuerNames()), new UntrustedInput(object3), Integers.valueOf(n3)});
                this.addNotification((ErrorBundle)object2, n2);
            }
        }
        catch (AnnotatedException annotatedException) {
            object4 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlExtractionError", new Object[]{annotatedException.getCause().getMessage(), annotatedException.getCause(), annotatedException.getCause().getClass().getName()});
            this.addError((ErrorBundle)object4, n2);
            iterator = new ArrayList().iterator();
        }
        boolean bl2 = false;
        object4 = null;
        while (iterator.hasNext()) {
            object4 = (X509CRL)iterator.next();
            if (((X509CRL)object4).getNextUpdate() == null || pKIXParameters.getDate().before(((X509CRL)object4).getNextUpdate())) {
                bl2 = true;
                object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.localValidCRL", new Object[]{new TrustedInput(((X509CRL)object4).getThisUpdate()), new TrustedInput(((X509CRL)object4).getNextUpdate())});
                this.addNotification((ErrorBundle)object3, n2);
                break;
            }
            object3 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.localInvalidCRL", new Object[]{new TrustedInput(((X509CRL)object4).getThisUpdate()), new TrustedInput(((X509CRL)object4).getNextUpdate())});
            this.addNotification((ErrorBundle)object3, n2);
        }
        if (!bl2) {
            Iterator iterator2 = vector.iterator();
            while (iterator2.hasNext()) {
                try {
                    object2 = (String)iterator2.next();
                    object3 = this.getCRL((String)object2);
                    if (object3 == null) continue;
                    if (!x509Certificate.getIssuerX500Principal().equals(((X509CRL)object3).getIssuerX500Principal())) {
                        object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineCRLWrongCA", new Object[]{new UntrustedInput(((X509CRL)object3).getIssuerX500Principal().getName()), new UntrustedInput(x509Certificate.getIssuerX500Principal().getName()), new UntrustedUrlInput(object2)});
                        this.addNotification((ErrorBundle)object, n2);
                        continue;
                    }
                    if (((X509CRL)object3).getNextUpdate() == null || this.pkixParams.getDate().before(((X509CRL)object3).getNextUpdate())) {
                        bl2 = true;
                        object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineValidCRL", new Object[]{new TrustedInput(((X509CRL)object3).getThisUpdate()), new TrustedInput(((X509CRL)object3).getNextUpdate()), new UntrustedUrlInput(object2)});
                        this.addNotification((ErrorBundle)object, n2);
                        object4 = object3;
                        break;
                    }
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.onlineInvalidCRL", new Object[]{new TrustedInput(((X509CRL)object3).getThisUpdate()), new TrustedInput(((X509CRL)object3).getNextUpdate()), new UntrustedUrlInput(object2)});
                    this.addNotification((ErrorBundle)object, n2);
                }
                catch (CertPathReviewerException certPathReviewerException) {
                    this.addNotification(certPathReviewerException.getErrorMessage(), n2);
                }
            }
        }
        if (object4 != null) {
            Object object5;
            Object object6;
            Object object7;
            boolean[] blArray;
            if (!(x509Certificate2 == null || (blArray = x509Certificate2.getKeyUsage()) == null || blArray.length >= 7 && blArray[6])) {
                object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noCrlSigningPermited");
                throw new CertPathReviewerException((ErrorBundle)object2);
            }
            if (publicKey != null) {
                try {
                    ((X509CRL)object4).verify(publicKey, "BC");
                }
                catch (Exception exception) {
                    object2 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlVerifyFailed");
                    throw new CertPathReviewerException((ErrorBundle)object2, (Throwable)exception);
                }
            } else {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlNoIssuerPublicKey");
                throw new CertPathReviewerException(errorBundle);
            }
            object3 = ((X509CRL)object4).getRevokedCertificate(x509Certificate.getSerialNumber());
            if (object3 != null) {
                object7 = null;
                if (((X509CRLEntry)object3).hasExtensions()) {
                    try {
                        object2 = ASN1Enumerated.getInstance(PKIXCertPathReviewer.getExtensionValue((X509Extension)object3, Extension.reasonCode.getId()));
                    }
                    catch (AnnotatedException annotatedException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlReasonExtError");
                        throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                    }
                    if (object2 != null) {
                        object7 = crlReasons[((ASN1Enumerated)object2).getValue().intValue()];
                    }
                }
                if (object7 == null) {
                    object7 = crlReasons[7];
                }
                object2 = new LocaleString(RESOURCE_NAME, (String)object7);
                if (!date.before(((X509CRLEntry)object3).getRevocationDate())) {
                    object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.certRevoked", new Object[]{new TrustedInput(((X509CRLEntry)object3).getRevocationDate()), object2});
                    throw new CertPathReviewerException((ErrorBundle)object);
                }
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.revokedAfterValidation", new Object[]{new TrustedInput(((X509CRLEntry)object3).getRevocationDate()), object2});
                this.addNotification((ErrorBundle)object, n2);
            } else {
                object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.notRevoked");
                this.addNotification((ErrorBundle)object7, n2);
            }
            if (((X509CRL)object4).getNextUpdate() != null && ((X509CRL)object4).getNextUpdate().before(this.pkixParams.getDate())) {
                object7 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlUpdateAvailable", new Object[]{new TrustedInput(((X509CRL)object4).getNextUpdate())});
                this.addNotification((ErrorBundle)object7, n2);
            }
            try {
                object7 = PKIXCertPathReviewer.getExtensionValue((X509Extension)object4, ISSUING_DISTRIBUTION_POINT);
            }
            catch (AnnotatedException annotatedException) {
                object = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.distrPtExtError");
                throw new CertPathReviewerException((ErrorBundle)object);
            }
            try {
                object2 = PKIXCertPathReviewer.getExtensionValue((X509Extension)object4, DELTA_CRL_INDICATOR);
            }
            catch (AnnotatedException annotatedException) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.deltaCrlExtError");
                throw new CertPathReviewerException(errorBundle);
            }
            if (object2 != null) {
                object = new X509CRLStoreSelector();
                try {
                    ((X509CRLSelector)object).addIssuerName(PKIXCertPathReviewer.getIssuerPrincipal((X509CRL)object4).getEncoded());
                }
                catch (IOException iOException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlIssuerException");
                    throw new CertPathReviewerException(errorBundle, (Throwable)iOException);
                }
                ((X509CRLSelector)object).setMinCRLNumber(((ASN1Integer)object2).getPositiveValue());
                try {
                    ((X509CRLSelector)object).setMaxCRLNumber(((ASN1Integer)PKIXCertPathReviewer.getExtensionValue((X509Extension)object4, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlNbrExtError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                }
                boolean bl3 = false;
                try {
                    object6 = CRL_UTIL.findCRLs((X509CRLStoreSelector)object, pKIXParameters).iterator();
                }
                catch (AnnotatedException annotatedException) {
                    ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlExtractionError");
                    throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                }
                while (object6.hasNext()) {
                    ASN1Primitive aSN1Primitive;
                    object5 = (X509CRL)object6.next();
                    try {
                        aSN1Primitive = PKIXCertPathReviewer.getExtensionValue((X509Extension)object5, ISSUING_DISTRIBUTION_POINT);
                    }
                    catch (AnnotatedException annotatedException) {
                        ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.distrPtExtError");
                        throw new CertPathReviewerException(errorBundle, (Throwable)annotatedException);
                    }
                    if (object7 == null) {
                        if (aSN1Primitive != null) continue;
                        bl3 = true;
                        break;
                    }
                    if (!((ASN1Primitive)object7).equals(aSN1Primitive)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noBaseCRL");
                    throw new CertPathReviewerException((ErrorBundle)object5);
                }
            }
            if (object7 != null) {
                BasicConstraints basicConstraints;
                object = IssuingDistributionPoint.getInstance(object7);
                try {
                    basicConstraints = BasicConstraints.getInstance(PKIXCertPathReviewer.getExtensionValue(x509Certificate, BASIC_CONSTRAINTS));
                }
                catch (AnnotatedException annotatedException) {
                    object5 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlBCExtError");
                    throw new CertPathReviewerException((ErrorBundle)object5, (Throwable)annotatedException);
                }
                if (((IssuingDistributionPoint)object).onlyContainsUserCerts() && basicConstraints != null && basicConstraints.isCA()) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyUserCert");
                    throw new CertPathReviewerException((ErrorBundle)object6);
                }
                if (((IssuingDistributionPoint)object).onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyCaCert");
                    throw new CertPathReviewerException((ErrorBundle)object6);
                }
                if (((IssuingDistributionPoint)object).onlyContainsAttributeCerts()) {
                    object6 = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.crlOnlyAttrCert");
                    throw new CertPathReviewerException((ErrorBundle)object6);
                }
            }
        }
        if (!bl2) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.noValidCrlFound");
            throw new CertPathReviewerException(errorBundle);
        }
    }

    protected Vector getCRLDistUrls(CRLDistPoint cRLDistPoint) {
        Vector<String> vector = new Vector<String>();
        if (cRLDistPoint != null) {
            DistributionPoint[] distributionPointArray = cRLDistPoint.getDistributionPoints();
            for (int i2 = 0; i2 < distributionPointArray.length; ++i2) {
                DistributionPointName distributionPointName = distributionPointArray[i2].getDistributionPoint();
                if (distributionPointName.getType() != 0) continue;
                GeneralName[] generalNameArray = GeneralNames.getInstance(distributionPointName.getName()).getNames();
                for (int i3 = 0; i3 < generalNameArray.length; ++i3) {
                    if (generalNameArray[i3].getTagNo() != 6) continue;
                    String string = ((DERIA5String)generalNameArray[i3].getName()).getString();
                    vector.add(string);
                }
            }
        }
        return vector;
    }

    protected Vector getOCSPUrls(AuthorityInformationAccess authorityInformationAccess) {
        Vector<String> vector = new Vector<String>();
        if (authorityInformationAccess != null) {
            AccessDescription[] accessDescriptionArray = authorityInformationAccess.getAccessDescriptions();
            for (int i2 = 0; i2 < accessDescriptionArray.length; ++i2) {
                GeneralName generalName;
                if (!accessDescriptionArray[i2].getAccessMethod().equals(AccessDescription.id_ad_ocsp) || (generalName = accessDescriptionArray[i2].getAccessLocation()).getTagNo() != 6) continue;
                String string = ((DERIA5String)generalName.getName()).getString();
                vector.add(string);
            }
        }
        return vector;
    }

    private X509CRL getCRL(String string) throws CertPathReviewerException {
        X509CRL x509CRL;
        block3: {
            x509CRL = null;
            try {
                URL uRL = new URL(string);
                if (!uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("https")) break block3;
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setUseCaches(false);
                httpURLConnection.setDoInput(true);
                httpURLConnection.connect();
                if (httpURLConnection.getResponseCode() == 200) {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "BC");
                    x509CRL = (X509CRL)certificateFactory.generateCRL(httpURLConnection.getInputStream());
                    break block3;
                }
                throw new Exception(httpURLConnection.getResponseMessage());
            }
            catch (Exception exception) {
                ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.loadCrlDistPointError", new Object[]{new UntrustedInput(string), exception.getMessage(), exception, exception.getClass().getName()});
                throw new CertPathReviewerException(errorBundle);
            }
        }
        return x509CRL;
    }

    protected Collection getTrustAnchors(X509Certificate x509Certificate, Set set) throws CertPathReviewerException {
        Object object;
        Object object2;
        Object object3;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = set.iterator();
        X509CertSelector x509CertSelector = new X509CertSelector();
        try {
            x509CertSelector.setSubject(PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate).getEncoded());
            object3 = x509Certificate.getExtensionValue(Extension.authorityKeyIdentifier.getId());
            if (object3 != null) {
                object2 = (ASN1OctetString)ASN1Primitive.fromByteArray((byte[])object3);
                object = AuthorityKeyIdentifier.getInstance(ASN1Primitive.fromByteArray(((ASN1OctetString)object2).getOctets()));
                x509CertSelector.setSerialNumber(((AuthorityKeyIdentifier)object).getAuthorityCertSerialNumber());
                byte[] byArray = ((AuthorityKeyIdentifier)object).getKeyIdentifier();
                if (byArray != null) {
                    x509CertSelector.setSubjectKeyIdentifier(new DEROctetString(byArray).getEncoded());
                }
            }
        }
        catch (IOException iOException) {
            ErrorBundle errorBundle = new ErrorBundle(RESOURCE_NAME, "CertPathReviewer.trustAnchorIssuerError");
            throw new CertPathReviewerException(errorBundle);
        }
        while (iterator.hasNext()) {
            TrustAnchor trustAnchor = (TrustAnchor)iterator.next();
            object3 = trustAnchor;
            if (trustAnchor.getTrustedCert() != null) {
                if (!x509CertSelector.match(((TrustAnchor)object3).getTrustedCert())) continue;
                arrayList.add(object3);
                continue;
            }
            if (((TrustAnchor)object3).getCAName() == null || ((TrustAnchor)object3).getCAPublicKey() == null || !((X500Principal)(object2 = PKIXCertPathReviewer.getEncodedIssuerPrincipal(x509Certificate))).equals(object = new X500Principal(((TrustAnchor)object3).getCAName()))) continue;
            arrayList.add(object3);
        }
        return arrayList;
    }
}

