/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.impl.checker;

import com.timevale.esign.sdk.tech.bean.OrganizeBean;
import com.timevale.esign.sdk.tech.bean.PersonBean;
import com.timevale.esign.sdk.tech.impl.constants.LegalAreaType;
import com.timevale.esign.sdk.tech.impl.convertor.Convertor;
import esign.utils.constant.type.PersonArea;
import esign.utils.exception.SuperException;
import esign.utils.i;

public abstract class Checker {
    public static void checkOrganize(OrganizeBean organ) throws SuperException {
        if (i.a((String)organ.getName())) {
            throw Convertor.convertException(1010);
        }
        if (null == organ.getRegType()) {
            throw Convertor.convertException(10007);
        }
        Checker.checkOrganRegMerge(organ);
        Checker.checkRegPerson(organ);
        if (null == PersonArea.getPersonArea((int)organ.getLegalArea())) {
            throw Convertor.convertException(1059);
        }
    }

    public static void checkPerson(PersonBean person) throws SuperException {
        if (person == null) {
            throw Convertor.convertException(1026);
        }
        if (i.a((String)person.getName())) {
            throw Convertor.convertException(1009);
        }
        if (i.a((String)person.getIdNo())) {
            throw Convertor.convertException(1011);
        }
        if (null == LegalAreaType.of(person.getPersonArea())) {
            throw Convertor.convertException(1059);
        }
    }

    private static void checkOrganRegMerge(OrganizeBean organ) throws SuperException {
        if (i.a((String)organ.getOrganCode())) {
            throw Convertor.convertException(1012);
        }
    }

    private static void checkRegPerson(OrganizeBean organ) throws SuperException {
        switch (organ.getUserType()) {
            case 0: {
                return;
            }
            case 1: {
                if (i.a((String)organ.getAgentName())) {
                    throw Convertor.convertException(1066);
                }
                if (!i.a((String)organ.getAgentIdNo())) break;
                throw Convertor.convertException(1067);
            }
            case 2: {
                if (i.a((String)organ.getLegalName())) {
                    throw Convertor.convertException(1063);
                }
                if (!i.a((String)organ.getLegalIdNo())) break;
                throw Convertor.convertException(1064);
            }
            default: {
                throw Convertor.convertException(1048);
            }
        }
    }
}

