/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.impl.constants;

public enum HashAlgorithm {
    SHA1("SHA1", "SHA-1"),
    SHA256("SHA256", "SHA-256"),
    SM3("SM3", "SM3");

    private String algorithm;
    private String digest;

    private HashAlgorithm(String algorithm, String digest) {
        this.algorithm = algorithm;
        this.digest = digest;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getDigest() {
        return this.digest;
    }

    public static HashAlgorithm getHashAlgorithmByDigest(String digest) {
        for (HashAlgorithm hash : HashAlgorithm.values()) {
            if (!hash.getDigest().equals(digest)) continue;
            return hash;
        }
        return null;
    }

    public static HashAlgorithm getHashAlgorithm(String algorithm) {
        for (HashAlgorithm hash : HashAlgorithm.values()) {
            if (!hash.getAlgorithm().equals(algorithm)) continue;
            return hash;
        }
        return null;
    }
}

