/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.impl.convertor;

import com.timevale.bean.b;
import com.timevale.esign.sdk.tech.bean.AccountBean;
import com.timevale.esign.sdk.tech.bean.CertBean;
import com.timevale.esign.sdk.tech.bean.OrganizeBean;
import com.timevale.esign.sdk.tech.bean.PersonBean;
import com.timevale.esign.sdk.tech.bean.SignBean;
import com.timevale.esign.sdk.tech.bean.SignatureBean;
import com.timevale.esign.sdk.tech.bean.UpdateAccountBean;
import com.timevale.esign.sdk.tech.bean.UpdateOrganizeBean;
import com.timevale.esign.sdk.tech.bean.UpdatePersonBean;
import com.timevale.esign.sdk.tech.bean.result.VerifyPdfResult;
import com.timevale.esign.sdk.tech.impl.model.AccountModel;
import com.timevale.esign.sdk.tech.impl.model.AccountUpdateModel;
import com.timevale.tgpdfsign.sign.h;
import com.timevale.tgpdfsign.sign.j;
import esign.util.constant.c;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.exception.collector.meta.ErrorMeta;
import esign.utils.security.provider.SecurityProvider;
import esign.utils.security.verify.a;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Convertor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Convertor.class);

    public static CertBean convert(a verify) throws IOException {
        List signers = verify.a();
        if (signers == null || signers.isEmpty()) {
            LOGGER.error("verify result has no signer.");
            return null;
        }
        a.a signer = (a.a)signers.get(0);
        esign.utils.security.a cert = new esign.utils.security.a(signer.a(), SecurityProvider.Default);
        CertBean r2 = new CertBean();
        r2.setCn(cert.f().a());
        r2.setSn(cert.a());
        r2.setIssuerCN(cert.e().a());
        r2.setStartDate(cert.c().toString());
        r2.setEndDate(cert.d().toString());
        r2.setCertBase64(esign.utils.a.a((byte[])signer.a().toASN1Structure().getEncoded()));
        return r2;
    }

    public static AccountModel.Account convert(PersonBean person) {
        AccountModel.Account acc = Convertor.convertAccount(person);
        AccountModel.Person psn = new AccountModel.Person();
        if (StringUtils.isNotBlank((String)person.getCountry()) && StringUtils.isNotBlank((String)person.getProvince()) && StringUtils.isNotBlank((String)person.getCity())) {
            psn.setAddress(person.getCountry() + "#" + person.getProvince() + "#" + person.getCity() + "#" + person.getAddress());
        } else {
            psn.setAddress(person.getAddress());
        }
        psn.setIdNo(person.getIdNo());
        psn.setName(person.getName());
        psn.setOrgan(person.getOrgan());
        if (StringUtils.isNotBlank((String)person.getDepartment())) {
            psn.setTitle(person.getDepartment() + "#" + person.getTitle());
        } else {
            psn.setTitle(person.getTitle());
        }
        psn.setPersonArea(person.getPersonArea());
        acc.setPerson(psn);
        return acc;
    }

    public static AccountUpdateModel.UpdateAccount convert(UpdatePersonBean person) {
        AccountUpdateModel.UpdateAccount acc = Convertor.convertUpdateAccount(person);
        AccountUpdateModel.UpdatePerson psn = new AccountUpdateModel.UpdatePerson();
        psn.setAddress(person.getAddress());
        psn.setOrgan(person.getOrgan());
        psn.setTitle(person.getTitle());
        psn.setName(person.getName());
        acc.setPerson(psn);
        return acc;
    }

    public static AccountModel.Account convert(OrganizeBean organ) {
        AccountModel.Account acc = Convertor.convertAccount(organ);
        AccountModel.Organize org = new AccountModel.Organize();
        org.setName(organ.getName());
        org.setAddress(organ.getAddress());
        org.setAgentIdNo(organ.getAgentIdNo());
        org.setAgentName(organ.getAgentName());
        if (organ.getAgentArea() != null) {
            org.setAgentArea(organ.getAgentArea());
        }
        org.setLegalArea(organ.getLegalArea());
        org.setLegalIdNo(organ.getLegalIdNo());
        org.setLegalName(organ.getLegalName());
        org.setOrganCode(organ.getOrganCode());
        org.setOrganType(organ.getOrganType());
        org.setScope(organ.getScope());
        org.setUserType(organ.getUserType());
        org.setLicenseType(organ.getRegType().val());
        acc.setOrgan(org);
        return acc;
    }

    public static AccountUpdateModel.UpdateAccount convert(UpdateOrganizeBean organ) {
        AccountUpdateModel.UpdateAccount acc = Convertor.convertUpdateAccount(organ);
        AccountUpdateModel.UpdateOrganize org = new AccountUpdateModel.UpdateOrganize();
        org.setName(organ.getName());
        org.setAddress(organ.getAddress());
        org.setAgentIdNo(organ.getAgentIdNo());
        org.setAgentName(organ.getAgentName());
        if (null != organ.getAgentArea()) {
            org.setAgentArea(organ.getAgentArea());
        }
        if (null != organ.getLegalArea()) {
            org.setLegalArea(organ.getLegalArea().type());
        }
        org.setLegalIdNo(organ.getLegalIdNo());
        org.setLegalName(organ.getLegalName());
        if (null != organ.getOrganType()) {
            org.setOrganType(organ.getOrganType().type());
        }
        org.setScope(organ.getScope());
        if (null != organ.getUserType()) {
            org.setUserType(organ.getUserType().type());
        }
        acc.setOrganize(org);
        return acc;
    }

    public static VerifyPdfResult convert(List<h> input) {
        if (input == null || input.isEmpty()) {
            return (VerifyPdfResult)esign.utils.bean.c.a((ErrorMeta)ErrorsDiscriptor.al_, VerifyPdfResult.class);
        }
        ArrayList<SignBean> out = new ArrayList<SignBean>();
        for (h s2 : input) {
            SignBean sr = Convertor.convert(s2);
            out.add(sr);
        }
        VerifyPdfResult r2 = new VerifyPdfResult();
        r2.setSignatures(out);
        return r2;
    }

    private static SignBean convert(h input) {
        SignBean output = new SignBean();
        output.setSealData(input.j());
        output.setSealName(input.i());
        output.setCert(Convertor.convert(input.h()));
        output.setSignature(Convertor.convert(input.g()));
        return output;
    }

    private static CertBean convert(com.timevale.tgpdfsign.sign.a input) {
        CertBean output = new CertBean();
        output.setCn(input.a());
        output.setSn(input.b());
        output.setIssuerCN(input.c());
        output.setStartDate(input.d());
        output.setEndDate(input.e());
        return output;
    }

    private static SignatureBean convert(j input) {
        SignatureBean output = new SignatureBean();
        output.setSignatureName(input.d());
        output.setValidate(1 == input.e());
        output.setTimeFrom(input.b());
        output.setSignDate(input.f());
        return output;
    }

    private static AccountUpdateModel.UpdateAccount convertUpdateAccount(UpdateAccountBean input) {
        AccountUpdateModel.UpdateAccount acc = new AccountUpdateModel.UpdateAccount();
        acc.setEmail(input.getEmail());
        acc.setMobile(input.getMobile());
        return acc;
    }

    private static AccountModel.Account convertAccount(AccountBean input) {
        AccountModel.Account acc = new AccountModel.Account();
        acc.setEmail(input.getEmail());
        acc.setMobile(input.getMobile());
        return acc;
    }

    public static SuperException convertException(int code) {
        return Convertor.convertException(code, c.a((int)code));
    }

    public static SuperException convertException(int code, String msg) {
        return new SuperException().setCode(code).setMessageTemplate(msg);
    }

    public static VerifyPdfResult convert(com.timevale.bean.result.b verifyPdfResult) {
        List signBeansOri = verifyPdfResult.a();
        if (CollectionUtils.isEmpty((Collection)signBeansOri)) {
            return null;
        }
        ArrayList<SignBean> signBeans = new ArrayList<SignBean>();
        for (b signBeanOri : signBeansOri) {
            SignBean signBean = new SignBean();
            signBean.setSealName(signBeanOri.a());
            signBean.setSealData(signBeanOri.b());
            CertBean certBean = new CertBean();
            certBean.setCn(signBeanOri.c().a());
            certBean.setSn(signBeanOri.c().b());
            certBean.setIssuerCN(signBeanOri.c().e());
            certBean.setStartDate(signBeanOri.c().c());
            certBean.setEndDate(signBeanOri.c().d());
            certBean.setCertBase64(signBeanOri.c().h());
            signBean.setCert(certBean);
            SignatureBean signatureBean = new SignatureBean();
            signatureBean.setSignatureName(signBeanOri.d().a());
            signatureBean.setSignDate(signBeanOri.d().d());
            signatureBean.setTimeFrom(signBeanOri.d().c());
            signatureBean.setValidate(signBeanOri.d().b());
            signBean.setSignature(signatureBean);
            signBeans.add(signBean);
        }
        VerifyPdfResult result = new VerifyPdfResult();
        result.setSignatures(signBeans);
        return result;
    }
}

