/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.service.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.timevale.esign.sdk.tech.bean.AbstractSignPdfBean;
import com.timevale.esign.sdk.tech.bean.CertAlgorithm;
import com.timevale.esign.sdk.tech.bean.DigitalSignBean;
import com.timevale.esign.sdk.tech.bean.EvidenceGuideInfoBean;
import com.timevale.esign.sdk.tech.bean.MultiSignParamBean;
import com.timevale.esign.sdk.tech.bean.PdfDigestSignBean;
import com.timevale.esign.sdk.tech.bean.PdfDigestSignVerifyBean;
import com.timevale.esign.sdk.tech.bean.PosBean;
import com.timevale.esign.sdk.tech.bean.SignPDFDocBean;
import com.timevale.esign.sdk.tech.bean.SignPDFFileBean;
import com.timevale.esign.sdk.tech.bean.SignParamBean;
import com.timevale.esign.sdk.tech.bean.SignatureFormat;
import com.timevale.esign.sdk.tech.bean.SigningAccount;
import com.timevale.esign.sdk.tech.bean.SigningInfo;
import com.timevale.esign.sdk.tech.bean.StandardCertBean;
import com.timevale.esign.sdk.tech.bean.TechCertInfo;
import com.timevale.esign.sdk.tech.bean.TextDigestSignBean;
import com.timevale.esign.sdk.tech.bean.VerifyTextSignBean;
import com.timevale.esign.sdk.tech.bean.VerifyTextSignResult;
import com.timevale.esign.sdk.tech.bean.WillnessInfo;
import com.timevale.esign.sdk.tech.bean.result.CodeMultiSignResult;
import com.timevale.esign.sdk.tech.bean.result.CreateSignDetailResult;
import com.timevale.esign.sdk.tech.bean.result.DigitalSignWithP1Result;
import com.timevale.esign.sdk.tech.bean.result.DigitalSignWithP7Result;
import com.timevale.esign.sdk.tech.bean.result.FileDigestSignResult;
import com.timevale.esign.sdk.tech.bean.result.PdfDigestSignResult;
import com.timevale.esign.sdk.tech.bean.result.PdfDigestSignVerifyResult;
import com.timevale.esign.sdk.tech.bean.result.Result;
import com.timevale.esign.sdk.tech.bean.result.SignTextWithSpecFormatResult;
import com.timevale.esign.sdk.tech.bean.result.TextDigestSignResult;
import com.timevale.esign.sdk.tech.bean.result.VerifyDigestSignResult;
import com.timevale.esign.sdk.tech.bean.result.VerifyDigitalSignP1Bean;
import com.timevale.esign.sdk.tech.bean.result.VerifyDigitalSignP7Bean;
import com.timevale.esign.sdk.tech.bean.result.VerifyMobileCodeResult;
import com.timevale.esign.sdk.tech.bean.result.WillnessServiceIdTransformResult;
import com.timevale.esign.sdk.tech.impl.bean.output.BaseResult;
import com.timevale.esign.sdk.tech.impl.bean.output.EventFileAuthResultBean;
import com.timevale.esign.sdk.tech.impl.bean.output.SealBean;
import com.timevale.esign.sdk.tech.impl.bean.output.SignResultBean;
import com.timevale.esign.sdk.tech.impl.constants.HashoriginType;
import com.timevale.esign.sdk.tech.impl.constants.SignType;
import com.timevale.esign.sdk.tech.impl.model.DigitalSignModel;
import com.timevale.esign.sdk.tech.impl.model.EvidenceGuideModel;
import com.timevale.esign.sdk.tech.impl.model.SignTextWithSpecFormatModel;
import com.timevale.esign.sdk.tech.impl.model.TimestampHashSignModel;
import com.timevale.esign.sdk.tech.impl.model.VerifyTextSignWithSpecFormatModel;
import com.timevale.esign.sdk.tech.impl.model.WillnessServiceIdTransformModel;
import com.timevale.esign.sdk.tech.service.UserSignService;
import com.timevale.esign.sdk.tech.service.impl.i;
import com.timevale.esign.sdk.tech.v3.client.context.InterfaceKey;
import com.timevale.esign.sdk.tech.v3.sign.SignKind;
import com.timevale.esign.sdk.tech.v3.sign.signway.f;
import com.timevale.esign.sdk.tech.v3.util.SignatureVerifyEnum;
import com.timevale.esign.sdk.tech.v3.util.ai;
import com.timevale.esign.sdk.tech.v3.util.c;
import com.timevale.esign.sdk.tech.v3.util.m;
import com.timevale.esign.sdk.tech.v3.util.q;
import com.timevale.guava.common.collect.Lists;
import com.timevale.guava.common.util.concurrent.FutureCallback;
import com.timevale.guava.common.util.concurrent.Futures;
import com.timevale.guava.common.util.concurrent.ListenableFuture;
import com.timevale.guava.common.util.concurrent.ListeningExecutorService;
import com.timevale.guava.common.util.concurrent.MoreExecutors;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.tgtext.bouncycastle.util.CollectionStore;
import esign.utils.JsonHelper;
import esign.utils.asserts.AssertSupport;
import esign.utils.coding.Coder;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.exception.collector.meta.ErrorMeta;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

public class n
extends com.timevale.esign.sdk.tech.v3.service.impl.b
implements UserSignService {
    private static final Logger a = LoggerFactory.getLogger(n.class);
    private static final String b = "{";
    private static final ListeningExecutorService c = MoreExecutors.listeningDecorator(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() << 3));

    public n() {
    }

    public n(com.timevale.esign.sdk.tech.v3.client.a client) {
        super(client);
    }

    @Override
    public FileDigestSignResult localSignPDF(String accountId, String sealData, AbstractSignPdfBean file, PosBean signPos, SignType signType) {
        return this.multiPositionSign(accountId, sealData, file, Collections.singletonList(signPos), signType);
    }

    @Override
    public FileDigestSignResult simpleLocalSignPDF(String accountId, String sealData, AbstractSignPdfBean file, PosBean signPos, SignType signType) {
        com.timevale.esign.sdk.tech.v3.sign.signway.a signWay;
        SignPDFDocBean bean;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.b(file, accountId);
            bean = this.a(file);
            signWay = f.a(this.b()).a(true).a();
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (FileDigestSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, FileDigestSignResult.class);
        }
        return this.a(bean, Collections.singletonList(signPos), signType, sealData, signWay, accountId);
    }

    @Override
    public FileDigestSignResult localSafeSignPDF(String accountId, String sealData, AbstractSignPdfBean file, PosBean signPos, SignType signType, String code) {
        com.timevale.esign.sdk.tech.v3.sign.signway.a signWay;
        SignPDFDocBean bean;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.a(file, accountId, code);
            bean = this.a(file);
            signWay = f.a(this.b()).b(code).a();
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (FileDigestSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, FileDigestSignResult.class);
        }
        return this.a(bean, Collections.singletonList(signPos), signType, sealData, signWay, accountId);
    }

    @Override
    public FileDigestSignResult localSafeSignPDF3rd(String accountId, String sealData, AbstractSignPdfBean file, PosBean signPos, SignType signType, String mobile, String code) {
        return this.multiPositionSafeSign3rd(accountId, sealData, file, Collections.singletonList(signPos), signType, mobile, code);
    }

    @Override
    public FileDigestSignResult localAuthSignPDF(String accountId, String sealData, AbstractSignPdfBean file, PosBean signPos, SignType signType, String authId) {
        com.timevale.esign.sdk.tech.v3.sign.signway.a signWay;
        SignPDFDocBean bean;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.b(file, accountId);
            bean = this.a(file);
            signWay = f.a(this.b()).d(authId).a();
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (FileDigestSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, FileDigestSignResult.class);
        }
        return this.a(bean, Collections.singletonList(signPos), signType, sealData, signWay, accountId);
    }

    private FileDigestSignResult a(SignPDFDocBean file, List<PosBean> signPos, SignType signType, String sealData, com.timevale.esign.sdk.tech.v3.sign.signway.a signWay, String accountId) {
        for (PosBean pos : signPos) {
            if (SignType.Key.equals((Object)signType)) {
                pos.setPosType(1);
                continue;
            }
            pos.setPosType(0);
        }
        try {
            return this.a(file, signPos, signType, sealData, signWay, accountId, SignKind.SEAL);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (FileDigestSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, FileDigestSignResult.class);
        }
    }

    @Override
    public CodeMultiSignResult localSafeMultiSignPDF(String accountId, List<SignParamBean> signParams, String sealData, String code) {
        VerifyMobileCodeResult verifyResult;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.a(accountId, signParams, code);
            verifyResult = this.a(accountId, null, code);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (CodeMultiSignResult)esign.utils.bean.c.a((SuperException)superException, CodeMultiSignResult.class);
        }
        return this.a(accountId, signParams, sealData, verifyResult.getCodeSendId(), this.a(SignKind.SEAL));
    }

    @Override
    public CodeMultiSignResult localSafeMultiSignPDF3rd(String accountId, List<SignParamBean> signParams, String sealData, String mobile, String code) {
        VerifyMobileCodeResult verifyResult;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.a(accountId, signParams, code, mobile);
            verifyResult = this.a(accountId, mobile, code);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (CodeMultiSignResult)esign.utils.bean.c.a((SuperException)superException, CodeMultiSignResult.class);
        }
        return this.a(accountId, signParams, sealData, verifyResult.getCodeSendId(), this.a(SignKind.SEAL));
    }

    @Override
    public CodeMultiSignResult localSafeMultiPureSignPDF(String accountId, List<SignParamBean> signParams, String sealData) {
        try {
            com.timevale.esign.sdk.tech.v3.common.b.a(accountId, signParams);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (CodeMultiSignResult)esign.utils.bean.c.a((SuperException)superException, CodeMultiSignResult.class);
        }
        return this.a(accountId, signParams, sealData, null, this.a(SignKind.STANDARD));
    }

    @Override
    public CodeMultiSignResult localSafeMultiPureSignPDF(String accountId, List<SignParamBean> signParams, String sealData, String code) {
        VerifyMobileCodeResult verifyResult;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.a(accountId, signParams, code);
            verifyResult = this.a(accountId, null, code);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (CodeMultiSignResult)esign.utils.bean.c.a((SuperException)superException, CodeMultiSignResult.class);
        }
        return this.a(accountId, signParams, sealData, verifyResult.getCodeSendId(), this.a(SignKind.STANDARD));
    }

    @Override
    public CodeMultiSignResult localSafeMultiPureSignPDF3rd(String accountId, List<SignParamBean> signParams, String sealData, String mobile, String code) {
        VerifyMobileCodeResult verifyResult;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.a(accountId, signParams, code, mobile);
            verifyResult = this.a(accountId, mobile, code);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (CodeMultiSignResult)esign.utils.bean.c.a((SuperException)superException, CodeMultiSignResult.class);
        }
        return this.a(accountId, signParams, sealData, verifyResult.getCodeSendId(), this.a(SignKind.STANDARD));
    }

    @Override
    public CodeMultiSignResult localMultiPosSignPDF3rd(String accountId, List<MultiSignParamBean> signParams, String sealData, String mobile, String code) {
        VerifyMobileCodeResult verifyResult;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.b(accountId, signParams, code, mobile);
            verifyResult = this.a(accountId, mobile, code);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (CodeMultiSignResult)esign.utils.bean.c.a((SuperException)superException, CodeMultiSignResult.class);
        }
        return this.a(accountId, signParams, sealData, verifyResult.getCodeSendId(), this.b(SignKind.SEAL));
    }

    @Override
    public CodeMultiSignResult localMultiPosSignPDF(String accountId, List<MultiSignParamBean> signParams, String sealData, String code) {
        VerifyMobileCodeResult verifyResult;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.b(accountId, signParams, code);
            verifyResult = this.a(accountId, null, code);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (CodeMultiSignResult)esign.utils.bean.c.a((SuperException)superException, CodeMultiSignResult.class);
        }
        return this.a(accountId, signParams, sealData, verifyResult.getCodeSendId(), this.b(SignKind.SEAL));
    }

    private VerifyMobileCodeResult a(String accountId, String mobile, String code) throws SuperException {
        i mobileService = new i(this.b());
        VerifyMobileCodeResult verifyResult = esign.utils.i.a((String)mobile) ? mobileService.verifyCode(accountId, code) : mobileService.verifyMobileCode(mobile, code);
        if (verifyResult.getErrCode() != 0) {
            throw ErrorsDiscriptor.direct((int)verifyResult.getErrCode(), (String)verifyResult.getMsg());
        }
        return verifyResult;
    }

    private CodeMultiSignResult a(String accountId, List<SignParamBean> signParams, String sealData, String authId, b signTask) {
        ArrayList<FileDigestSignResult> successList = Lists.newArrayList();
        ArrayList<FileDigestSignResult> failList = Lists.newArrayList();
        List<ListenableFuture<FileDigestSignResult>> futures = this.a(accountId, sealData, authId, signParams, signTask);
        this.a(futures, successList, failList);
        CodeMultiSignResult result = new CodeMultiSignResult();
        result.setFailList(failList);
        result.setSuccessList(successList);
        return result;
    }

    private CodeMultiSignResult a(String accountId, List<MultiSignParamBean> signParams, String sealData, String authId, a signTask) {
        ArrayList<FileDigestSignResult> successList = Lists.newArrayList();
        ArrayList<FileDigestSignResult> failList = Lists.newArrayList();
        List<ListenableFuture<FileDigestSignResult>> futures = this.a(accountId, sealData, authId, signParams, signTask);
        this.a(futures, successList, failList);
        CodeMultiSignResult result = new CodeMultiSignResult();
        result.setFailList(failList);
        result.setSuccessList(successList);
        return result;
    }

    private List<ListenableFuture<FileDigestSignResult>> a(String accountId, String sealData, String authId, List<SignParamBean> signParams, b signTask) {
        ArrayList<ListenableFuture<FileDigestSignResult>> futures = Lists.newArrayList();
        int size = signParams.size();
        for (int i2 = 0; i2 < size; ++i2) {
            futures.add(c.submit(signTask.a(accountId, signParams.get(i2), sealData, authId)));
        }
        return futures;
    }

    private b a(final SignKind signKind) {
        return new b(){

            @Override
            public Callable<FileDigestSignResult> a(final String accountId, final SignParamBean signParam, final String sealData, final String authId) {
                return new Callable<FileDigestSignResult>(){

                    public FileDigestSignResult a() throws Exception {
                        FileDigestSignResult digestSignResult = n.this.a(accountId, signParam, sealData, authId, signKind);
                        if (signParam.getFileBean() != null) {
                            SignPDFFileBean signPDFFileBean = signParam.getFileBean();
                            if (!esign.utils.i.a((String)signPDFFileBean.getSrcPdfFile())) {
                                digestSignResult.setFilePath(signPDFFileBean.getSrcPdfFile());
                            }
                            if (!esign.utils.i.a((String)signPDFFileBean.getDstPdfFile())) {
                                digestSignResult.setDstFilePath(signPDFFileBean.getDstPdfFile());
                            }
                            if (!esign.utils.i.a((String)signPDFFileBean.getMarkBit())) {
                                digestSignResult.setMarkBit(signPDFFileBean.getMarkBit());
                            }
                        }
                        return digestSignResult;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                };
            }
        };
    }

    private FileDigestSignResult a(String accountId, SignParamBean signParam, String sealData, String authId, SignKind signKind) {
        SignPDFFileBean file = signParam.getFileBean();
        try {
            com.timevale.esign.sdk.tech.v3.common.b.a(file);
            SignPDFDocBean bean = this.a(file);
            com.timevale.esign.sdk.tech.v3.sign.signway.a signWay = f.a(this.b()).d(authId).a();
            return this.a(bean, Arrays.asList(signParam.getSignPos()), signParam.getSignType(), sealData, signWay, accountId, signKind);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (FileDigestSignResult)esign.utils.bean.c.a((SuperException)superException, FileDigestSignResult.class);
        }
    }

    private List<ListenableFuture<FileDigestSignResult>> a(String accountId, String sealData, String authId, List<MultiSignParamBean> signParams, a signTask) {
        ArrayList<ListenableFuture<FileDigestSignResult>> futures = Lists.newArrayList();
        int size = signParams.size();
        for (int i2 = 0; i2 < size; ++i2) {
            futures.add(c.submit(signTask.a(accountId, signParams.get(i2), sealData, authId)));
        }
        return futures;
    }

    private a b(final SignKind signKind) {
        return new a(){

            @Override
            public Callable<FileDigestSignResult> a(final String accountId, final MultiSignParamBean multiSignParamBean, final String sealData, final String authId) {
                return new Callable<FileDigestSignResult>(){

                    public FileDigestSignResult a() throws Exception {
                        FileDigestSignResult digestSignResult = n.this.a(accountId, multiSignParamBean, sealData, authId, signKind);
                        SignPDFFileBean signPDFFileBean = multiSignParamBean.getFileBean();
                        if (signPDFFileBean != null) {
                            if (!esign.utils.i.a((String)signPDFFileBean.getSrcPdfFile())) {
                                digestSignResult.setFilePath(signPDFFileBean.getSrcPdfFile());
                            }
                            if (!esign.utils.i.a((String)signPDFFileBean.getDstPdfFile())) {
                                digestSignResult.setDstFilePath(signPDFFileBean.getDstPdfFile());
                            }
                            if (!esign.utils.i.a((String)signPDFFileBean.getMarkBit())) {
                                digestSignResult.setMarkBit(signPDFFileBean.getMarkBit());
                            }
                        }
                        return digestSignResult;
                    }

                    @Override
                    public /* synthetic */ Object call() throws Exception {
                        return this.a();
                    }
                };
            }
        };
    }

    private FileDigestSignResult a(String accountId, MultiSignParamBean multiSignParamBean, String sealData, String authId, SignKind signKind) {
        try {
            com.timevale.esign.sdk.tech.v3.common.b.a(multiSignParamBean.getFileBean());
            SignPDFDocBean bean = this.a(multiSignParamBean.getFileBean());
            com.timevale.esign.sdk.tech.v3.sign.signway.a signWay = f.a(this.b()).d(authId).a();
            return this.a(bean, multiSignParamBean.getSignPos(), multiSignParamBean.getSignType(), sealData, signWay, accountId, signKind);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (FileDigestSignResult)esign.utils.bean.c.a((SuperException)superException, FileDigestSignResult.class);
        }
    }

    private void a(List<ListenableFuture<FileDigestSignResult>> futures, List<FileDigestSignResult> successList, List<FileDigestSignResult> failList) {
        for (int i2 = 0; i2 < futures.size(); ++i2) {
            try {
                FileDigestSignResult result = (FileDigestSignResult)futures.get(i2).get();
                if (0 == result.getErrCode()) {
                    successList.add(result);
                    continue;
                }
                failList.add(result);
                continue;
            }
            catch (InterruptedException e2) {
                a.error("\u6279\u91cf\u7b7e\u7f72\u4efbInterruptedException\u5f02\u5e38: {}", (Object)e2.getMessage());
                failList.add((FileDigestSignResult)esign.utils.bean.c.a((ErrorMeta)ErrorsDiscriptor.ag, FileDigestSignResult.class));
                continue;
            }
            catch (ExecutionException e3) {
                a.error("\u6279\u91cf\u7b7e\u7f72\u4efb\u52a1ExecutionException\u5f02\u5e38: {}", (Object)e3.getMessage());
                failList.add((FileDigestSignResult)esign.utils.bean.c.a((ErrorMeta)ErrorsDiscriptor.ag, FileDigestSignResult.class));
            }
        }
    }

    private void b(List<ListenableFuture<FileDigestSignResult>> futures, final List<FileDigestSignResult> successList, final List<FileDigestSignResult> failList) {
        int size = futures.size();
        for (int i2 = 0; i2 < size; ++i2) {
            Futures.addCallback(futures.get(i2), new FutureCallback<FileDigestSignResult>(){

                public void a(FileDigestSignResult result) {
                    if (0 == result.getErrCode()) {
                        successList.add(result);
                        return;
                    }
                    failList.add(result);
                }

                @Override
                public void onFailure(Throwable throwable) {
                    a.error("\u6279\u91cf\u7b7e\u7f72\u4efb\u52a1\u5f02\u5e38", throwable);
                    failList.add(esign.utils.bean.c.a((ErrorMeta)ErrorsDiscriptor.ag, FileDigestSignResult.class));
                }

                @Override
                public /* synthetic */ void onSuccess(Object object) {
                    this.a((FileDigestSignResult)object);
                }
            });
        }
    }

    @Override
    public Result saveEvidenceGuideInfo(String signServiceId, EvidenceGuideInfoBean evidenceInfo) {
        try {
            if (esign.utils.i.a((String)signServiceId)) {
                throw ErrorsDiscriptor.t_.e();
            }
            com.timevale.esign.sdk.tech.v3.common.b.a(evidenceInfo);
            EvidenceGuideModel model = (EvidenceGuideModel)((Object)this.b().g().a(InterfaceKey.EVIDENCE_GUIDE));
            model.setDataType(0);
            model.setSignServiceId(signServiceId);
            EvidenceGuideModel.WitnessGuide guide = new EvidenceGuideModel.WitnessGuide();
            guide.setAutonymDate(evidenceInfo.getAuthDate());
            guide.setLoginDate(evidenceInfo.getLoginDate());
            guide.setLoginIP(evidenceInfo.getLoginIP());
            guide.setSignIPList(evidenceInfo.getSignIPList());
            if (!esign.utils.i.a((String)evidenceInfo.getLicensePhoto())) {
                EventFileAuthResultBean getUrlBean = com.timevale.esign.sdk.tech.v3.common.a.a(this.b(), evidenceInfo.getLicensePhoto(), "eventCertUserContent" + new Random().nextInt());
                String projectId = this.b().g().a().getProjectId();
                com.timevale.esign.sdk.tech.v3.client.b.a(projectId, getUrlBean.getUrl(), evidenceInfo.getLicensePhoto());
                guide.setCbm(getUrlBean.getFileKey());
                model.setFileKey(getUrlBean.getFileKey());
            }
            model.setWitnessGuide(guide);
            JsonObject json = com.timevale.esign.sdk.tech.v3.client.b.a(this.b(), model);
            Result result = (Result)JsonHelper.a((JsonObject)json, Result.class);
            if (0 != result.getErrCode()) {
                a.error("save evidence guide info failed.errCode:{},errMsg:{}.", (Object)result.getErrCode(), (Object)result.getErrCode());
                return (Result)esign.utils.bean.c.a((esign.utils.bean.a)result, Result.class);
            }
            return result;
        }
        catch (SuperException e2) {
            a.error("save evidence guide info fail.", (Throwable)e2);
            return (Result)esign.utils.bean.c.a((SuperException)e2, Result.class);
        }
        catch (Exception e3) {
            a.error("save evidence guide info fail.", (Throwable)e3);
            return (Result)esign.utils.bean.c.b((Exception)e3, Result.class);
        }
    }

    @Override
    public FileDigestSignResult multiPositionSign(String accountId, String sealData, AbstractSignPdfBean file, List<PosBean> signPos, SignType signType) {
        com.timevale.esign.sdk.tech.v3.sign.signway.a signWay;
        SignPDFDocBean bean;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.b(file, accountId);
            if (sealData.startsWith(b)) {
                SealBean seal = m.a(sealData, SealBean.class);
                sealData = this.a(seal.getData());
            }
            bean = this.a(file);
            signWay = f.a(this.b()).a();
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (FileDigestSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, FileDigestSignResult.class);
        }
        return this.a(bean, signPos, signType, sealData, signWay, accountId);
    }

    @Override
    public FileDigestSignResult multiPositionSafeSign3rd(String accountId, String sealData, AbstractSignPdfBean file, List<PosBean> signPos, SignType signType, String mobile, String code) {
        com.timevale.esign.sdk.tech.v3.sign.signway.a signWay;
        SignPDFDocBean bean;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.b(file, accountId, code, mobile);
            bean = this.a(file);
            signWay = f.a(this.b()).b(code).c(mobile).a();
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (FileDigestSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, FileDigestSignResult.class);
        }
        return this.a(bean, signPos, signType, sealData, signWay, accountId);
    }

    @Override
    public CodeMultiSignResult batchSignWithWillness(final WillnessInfo willInfo, final SigningAccount signAccount, List<SigningInfo> signInfos) {
        String willAuthId;
        try {
            willAuthId = this.c(willInfo.getBizId());
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (CodeMultiSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, CodeMultiSignResult.class);
        }
        ArrayList<FileDigestSignResult> successList = Lists.newArrayList();
        ArrayList<FileDigestSignResult> failList = Lists.newArrayList();
        ArrayList<ListenableFuture<FileDigestSignResult>> futures = Lists.newArrayList();
        int size = signInfos.size();
        for (int i2 = 0; i2 < size; ++i2) {
            final SigningInfo signInfo = signInfos.get(i2);
            futures.add(c.submit(new Callable<FileDigestSignResult>(){

                public FileDigestSignResult a() throws Exception {
                    return n.this.a(willInfo.getWillnessAccountId(), willAuthId, signAccount, signInfo);
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            }));
        }
        this.a(futures, successList, failList);
        CodeMultiSignResult result = new CodeMultiSignResult();
        result.setFailList(failList);
        result.setSuccessList(successList);
        if (!failList.isEmpty()) {
            result.setErrCode(ErrorsDiscriptor.d.code());
            result.setMsg(ErrorsDiscriptor.d.message());
        }
        return result;
    }

    @Override
    public TextDigestSignResult localSignText(TextDigestSignBean param) {
        try {
            param.validate();
            SignTextWithSpecFormatModel model = (SignTextWithSpecFormatModel)((Object)this.b().g().a(InterfaceKey.SIGN_TEXT_WITH_SPEC_FORMAT));
            model.setAccountId(param.getAccountId());
            model.setText(param.getText());
            model.setSignatureFormat(param.getFormat().getType());
            JsonObject json = com.timevale.esign.sdk.tech.v3.client.b.a(this.b(), model);
            SignTextWithSpecFormatResult result = (SignTextWithSpecFormatResult)JsonHelper.a((JsonObject)json, SignTextWithSpecFormatResult.class);
            if (result.getErrCode() != 0) {
                throw ErrorsDiscriptor.direct((int)result.getErrCode(), (String)result.getMsg());
            }
            com.timevale.esign.sdk.tech.v3.sign.c.a(this.b(), param.getAccountId(), "text", "text", null, null, result.getSignServiceId(), null, null, null);
            return this.a(result);
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (TextDigestSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, TextDigestSignResult.class);
        }
    }

    @Override
    public PdfDigestSignResult pdfDigestSign(PdfDigestSignBean param) {
        try {
            param.validate();
            TimestampHashSignModel model = (TimestampHashSignModel)((Object)this.b().g().a(InterfaceKey.TIMESTAMP_HASH_SIGN));
            model.setHash(esign.utils.a.a((byte[])param.getDigest()));
            model.setAccountId(param.getAccountId());
            model.setType(HashoriginType.PDF);
            CreateSignDetailResult signDetail = com.timevale.esign.sdk.tech.v3.sign.c.a(this.b());
            JsonObject json = com.timevale.esign.sdk.tech.v3.client.b.a(this.b(), model);
            SignResultBean result = (SignResultBean)((Object)JsonHelper.a((JsonObject)json, SignResultBean.class));
            if (result.getErrCode() != 0) {
                throw ErrorsDiscriptor.direct((int)result.getErrCode(), (String)result.getMsg());
            }
            com.timevale.esign.sdk.tech.v3.sign.c.a(this.b(), param.getAccountId(), "pdf", "pdf", param.getFileName(), null, signDetail.getSignServiceId(), null == result.getIntendSignLogRef() ? null : result.getIntendSignLogRef().getDataId(), null, null);
            PdfDigestSignResult signResult = new PdfDigestSignResult();
            signResult.setSignature(result.getSignResult());
            signResult.setSignServiceId(signDetail.getSignServiceId());
            return signResult;
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (PdfDigestSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, PdfDigestSignResult.class);
        }
    }

    @Override
    public PdfDigestSignVerifyResult pdfDigestSignVerify(PdfDigestSignVerifyBean param) {
        PdfDigestSignVerifyResult result = new PdfDigestSignVerifyResult();
        try {
            PKCS7 pkcs7 = new PKCS7(esign.utils.a.a((String)param.getSignature()));
            SignerInfo[] signerInfos = pkcs7.getSignerInfos();
            byte[] cert = signerInfos[0].getCertificate(pkcs7).getEncoded();
            ByteArrayInputStream fi = new ByteArrayInputStream(cert);
            ASN1InputStream ais = new ASN1InputStream((InputStream)fi);
            ASN1Sequence aseq = (ASN1Sequence)ais.readObject();
            com.timevale.tgtext.bouncycastle.asn1.x509.Certificate x509 = com.timevale.tgtext.bouncycastle.asn1.x509.Certificate.getInstance((Object)aseq);
            if (x509 == null) {
                throw new SuperException(new Object[]{"\u7b7e\u540d\u6570\u636e\u683c\u5f0f\u5f02\u5e38"});
            }
            Certificate certificate = null;
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            fi = new ByteArrayInputStream(cert);
            while (((InputStream)fi).available() > 0) {
                certificate = cf.generateCertificate(fi);
            }
            if (certificate == null) {
                throw new SuperException(new Object[]{"\u7b7e\u540d\u6570\u636e\u683c\u5f0f\u5f02\u5e38"});
            }
            Signature oSig = Signature.getInstance("SHA256WithRSA", "BC");
            oSig.initVerify(certificate.getPublicKey());
            oSig.update(signerInfos[0].getAuthenticatedAttributes().getDerEncoding());
            boolean pass = oSig.verify(signerInfos[0].getEncryptedDigest());
            result.setPass(pass);
            result.setCertBase64(esign.utils.a.a((byte[])cert));
        }
        catch (Throwable e2) {
            result.setPass(false);
            result.setMsg(e2.getMessage());
        }
        return result;
    }

    private void a(Integer format, String signature, String text) throws SuperException {
        AssertSupport.assertNotnull((Object)format, (Exception)((Object)esign.utils.exception.impl.a.au.e(new Object[]{"format"})));
        AssertSupport.assertNotnull((String)signature, (Exception)((Object)esign.utils.exception.impl.a.au.e(new Object[]{"signature"})));
        AssertSupport.assertNotnull((String)text, (Exception)((Object)esign.utils.exception.impl.a.au.e(new Object[]{"text"})));
        AssertSupport.assertTrue((SignatureFormat.PKCS1.getType().equals(format) || SignatureFormat.PKCS7.getType().equals(format) ? 1 : 0) != 0, (Exception)((Object)esign.utils.exception.impl.a.bb.e(new Object[]{"format"})));
    }

    private void a(Integer algorithm, String timestampSignature) throws SuperException {
        AssertSupport.assertTrue((!StringUtils.isEmpty((String)timestampSignature) ? 1 : 0) != 0, (Exception)((Object)esign.utils.exception.impl.a.au.e(new Object[]{"timestampSignature"})));
        AssertSupport.assertTrue((algorithm != null ? 1 : 0) != 0, (Exception)((Object)esign.utils.exception.impl.a.au.e(new Object[]{"algorithm"})));
        AssertSupport.assertTrue((CertAlgorithm.RSA.getType() == algorithm.intValue() || CertAlgorithm.SM2.getType() == algorithm.intValue() ? 1 : 0) != 0, (Exception)((Object)esign.utils.exception.impl.a.bb.e(new Object[]{"algorithm"})));
    }

    @Override
    public VerifyTextSignResult textVerify(VerifyTextSignBean param) {
        try {
            Integer format = param.getFormat();
            String signature = param.getSignature();
            String text = param.getText();
            this.a(format, signature, text);
            if (SignatureFormat.PKCS1.getType().equals(format)) {
                Integer algorithm = param.getAlgorithm();
                String timestampSignature = param.getTimestampSignature();
                this.a(algorithm, timestampSignature);
            }
            String hashAlgo = "SHA256";
            if (CertAlgorithm.SM2.getType() == param.getAlgorithm().intValue()) {
                hashAlgo = "SM3";
            }
            byte[] bytes = n.a(text, hashAlgo);
            VerifyTextSignWithSpecFormatModel model = (VerifyTextSignWithSpecFormatModel)((Object)this.b().g().a(InterfaceKey.VERIFY_SIGN_TEXT_WITH_SPEC_FORMAT));
            model.setText(esign.utils.a.a((byte[])bytes));
            model.setSignature(param.getSignature());
            model.setTimestampSignature(param.getTimestampSignature());
            model.setCert(param.getCert());
            model.setAlgorithm(param.getAlgorithm());
            model.setFormat(param.getFormat());
            JsonObject json = com.timevale.esign.sdk.tech.v3.client.b.a(this.b(), model);
            VerifyTextSignResult result = (VerifyTextSignResult)JsonHelper.a((JsonObject)json, VerifyTextSignResult.class);
            if (result.getErrCode() != 0) {
                throw ErrorsDiscriptor.direct((int)result.getErrCode(), (String)result.getMsg());
            }
            result.setPassed(json.get("data").getAsBoolean());
            return result;
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (VerifyTextSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, VerifyTextSignResult.class);
        }
        catch (Exception exception) {
            return (VerifyTextSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)esign.utils.exception.impl.a.Z.message(), (boolean)true, VerifyTextSignResult.class);
        }
    }

    @Override
    public DigitalSignWithP1Result localDigitalSignWithP1(DigitalSignBean param) {
        try {
            param.validate();
            DigitalSignModel model = (DigitalSignModel)((Object)this.b().g().a(InterfaceKey.DIGITAL_SIGN));
            model.setAccountId(param.getAccountId());
            model.setText(param.getPlainText());
            model.setSignatureFormat(SignatureFormat.PKCS1.getType());
            JsonObject json = com.timevale.esign.sdk.tech.v3.client.b.a(this.b(), model);
            BaseResult<DigitalSignWithP1Result> result = q.a(json, new TypeToken<BaseResult<DigitalSignWithP1Result>>(){});
            this.a(result.getData(), json);
            AssertSupport.assertTrue((result.getErrCode() == 0 ? 1 : 0) != 0, (Exception)((Object)ErrorsDiscriptor.direct((int)result.getErrCode(), (String)result.getMsg())));
            com.timevale.esign.sdk.tech.v3.sign.c.a(this.b(), param.getAccountId(), "text", "text", null, null, result.getData().getSignServiceId(), null, null, null);
            return result.getData();
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (DigitalSignWithP1Result)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, DigitalSignWithP1Result.class);
        }
        catch (Exception exception) {
            return (DigitalSignWithP1Result)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Y.code(), (String)esign.utils.exception.impl.a.Y.message(), (boolean)true, DigitalSignWithP1Result.class);
        }
    }

    private void a(DigitalSignWithP7Result result, JsonObject json) {
        JsonElement certJsonElement;
        JsonElement jsonElement = json.get("data");
        if (jsonElement != null && (certJsonElement = ((JsonObject)jsonElement).get("cert")) != null && JsonNull.INSTANCE != certJsonElement) {
            result.setCertBean(this.b(certJsonElement.getAsString()));
        }
    }

    private StandardCertBean b(String cert) {
        TechCertInfo techCertInfo = com.timevale.esign.sdk.tech.v3.util.c.a(Coder.BASE64.decode(cert));
        StandardCertBean certBean = new StandardCertBean();
        certBean.setCert(cert);
        certBean.setCn(techCertInfo.getSubject_cn());
        certBean.setEndDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(techCertInfo.getEndTime()));
        certBean.setStartDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(techCertInfo.getStartTime()));
        certBean.setIssuerCN(techCertInfo.getIssue_cn());
        certBean.setOu(techCertInfo.getIssue_ou());
        certBean.setSn(techCertInfo.getSerialNumber());
        return certBean;
    }

    @Override
    public DigitalSignWithP7Result localDigitalSignWithP7(DigitalSignBean param) {
        try {
            param.validate();
            DigitalSignModel model = (DigitalSignModel)((Object)this.b().g().a(InterfaceKey.DIGITAL_SIGN));
            model.setAccountId(param.getAccountId());
            model.setText(param.getPlainText());
            model.setSignatureFormat(SignatureFormat.PKCS7.getType());
            JsonObject json = com.timevale.esign.sdk.tech.v3.client.b.a(this.b(), model);
            BaseResult<DigitalSignWithP7Result> result = q.a(json, new TypeToken<BaseResult<DigitalSignWithP7Result>>(){});
            AssertSupport.assertTrue((result.getErrCode() == 0 ? 1 : 0) != 0, (Exception)((Object)ErrorsDiscriptor.direct((int)result.getErrCode(), (String)result.getMsg())));
            DigitalSignWithP7Result data = result.getData();
            com.timevale.esign.sdk.tech.v3.sign.c.a(this.b(), param.getAccountId(), "text", "text", null, null, data.getSignServiceId(), null, null, null);
            String signature = data.getSignature();
            CMSSignedData cmsSignedData = new CMSSignedData(esign.utils.a.a((String)signature));
            X509CertificateHolder holder = (X509CertificateHolder)((CollectionStore)cmsSignedData.getCertificates()).iterator().next();
            data.setCertBean(this.b(esign.utils.a.a((byte[])holder.getEncoded())));
            return data;
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (DigitalSignWithP7Result)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, DigitalSignWithP7Result.class);
        }
        catch (Exception exception) {
            return (DigitalSignWithP7Result)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Y.code(), (String)esign.utils.exception.impl.a.Y.message(), (boolean)true, DigitalSignWithP7Result.class);
        }
    }

    @Override
    public VerifyDigestSignResult digitalVerifyWithP1(VerifyDigitalSignP1Bean param) {
        try {
            boolean isGM;
            param.validate();
            AssertSupport.assertTrue((boolean)StringUtils.isNotEmpty((String)param.getPlainText()), (Exception)((Object)ErrorsDiscriptor.au.e(new Object[]{"plainText"})));
            AssertSupport.assertTrue((boolean)StringUtils.isNotEmpty((String)param.getCert()), (Exception)((Object)ErrorsDiscriptor.au.e(new Object[]{"cert"})));
            if (esign.utils.a.a((String)param.getSignature()) == null) {
                return (VerifyDigestSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)"\u9a8c\u8bc1\u5931\u8d25\uff0csignature\u683c\u5f0f\u9519\u8bef\u3002", (boolean)true, VerifyDigestSignResult.class);
            }
            if (esign.utils.a.a((String)param.getCert()) == null) {
                return (VerifyDigestSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)"\u9a8c\u8bc1\u5931\u8d25\uff0ccert\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (boolean)true, VerifyDigestSignResult.class);
            }
            if (esign.utils.a.a((String)param.getTimestampSignature()) == null) {
                return (VerifyDigestSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)"\u9a8c\u8bc1\u5931\u8d25\uff0ctimestampSignature\u683c\u5f0f\u9519\u8bef\u3002", (boolean)true, VerifyDigestSignResult.class);
            }
            ByteArrayInputStream bIn = null;
            ASN1InputStream aIn = null;
            try {
                bIn = new ByteArrayInputStream(esign.utils.a.a((String)param.getCert()));
                aIn = new ASN1InputStream((InputStream)bIn);
                ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
                com.timevale.tgtext.bouncycastle.asn1.x509.Certificate certificate = com.timevale.tgtext.bouncycastle.asn1.x509.Certificate.getInstance((Object)seq);
                isGM = "1.2.156.10197.1.501".equals(certificate.getSignatureAlgorithm().getAlgorithm().getId());
            }
            catch (Throwable throwable) {
                com.timevale.esign.sdk.tech.v3.util.n.a(aIn);
                com.timevale.esign.sdk.tech.v3.util.n.a(bIn);
                throw throwable;
            }
            com.timevale.esign.sdk.tech.v3.util.n.a((Closeable)aIn);
            com.timevale.esign.sdk.tech.v3.util.n.a(bIn);
            if (!isGM && !param.getAlgorithm().equalsIgnoreCase("SHA256WithRSA")) {
                return (VerifyDigestSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)("\u9a8c\u8bc1\u5931\u8d25\uff0c\u7b7e\u540d\u8bc1\u4e66\u4e0e" + param.getAlgorithm() + "\u7b97\u6cd5\u4e0d\u5339\u914d"), (boolean)true, VerifyDigestSignResult.class);
            }
            if (isGM && !param.getAlgorithm().equalsIgnoreCase("SM3WithSM2")) {
                return (VerifyDigestSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)("\u9a8c\u8bc1\u5931\u8d25\uff0c\u7b7e\u540d\u8bc1\u4e66\u4e0e" + param.getAlgorithm() + "\u7b97\u6cd5\u4e0d\u5339\u914d"), (boolean)true, VerifyDigestSignResult.class);
            }
            SignatureVerifyEnum.getVerifyEnumByAlgAndPkcs(param.getAlgorithm(), false).verify(param);
            VerifyDigestSignResult verifyDigestSignResult = new VerifyDigestSignResult();
            verifyDigestSignResult.setCertBean(this.b(param.getCert()));
            return verifyDigestSignResult;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            if (exception instanceof SuperException) {
                return (VerifyDigestSignResult)esign.utils.bean.c.a((int)((SuperException)((Object)e2)).getCode(), (String)((SuperException)((Object)e2)).getMessage(), (boolean)true, VerifyDigestSignResult.class);
            }
            if (e2 instanceof ai.a) {
                return (VerifyDigestSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)e2.getMessage(), (boolean)true, VerifyDigestSignResult.class);
            }
            return (VerifyDigestSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)esign.utils.exception.impl.a.Z.message(), (boolean)true, VerifyDigestSignResult.class);
        }
    }

    @Override
    public VerifyDigestSignResult digitalVerifyWithP7(VerifyDigitalSignP7Bean param) {
        try {
            param.validate();
            if (esign.utils.a.a((String)param.getSignature()) == null) {
                return (VerifyDigestSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)"\u9a8c\u8bc1\u5931\u8d25\uff0csignature\u683c\u5f0f\u9519\u8bef\u3002", (boolean)true, VerifyDigestSignResult.class);
            }
            SignatureVerifyEnum.getVerifyEnumByAlgAndPkcs(SignatureVerifyEnum.SHA256WITHRSA_P7.getAlg(), true).verify(param);
            VerifyDigestSignResult verifyDigestSignResult = new VerifyDigestSignResult();
            CMSSignedData cmsSignedData = new CMSSignedData(esign.utils.a.a((String)param.getSignature()));
            X509CertificateHolder holder = (X509CertificateHolder)((CollectionStore)cmsSignedData.getCertificates()).iterator().next();
            verifyDigestSignResult.setCertBean(this.b(esign.utils.a.a((byte[])holder.getEncoded())));
            return verifyDigestSignResult;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            if (exception instanceof SuperException) {
                return (VerifyDigestSignResult)esign.utils.bean.c.a((int)((SuperException)((Object)e2)).getCode(), (String)((SuperException)((Object)e2)).getMessage(), (boolean)true, VerifyDigestSignResult.class);
            }
            if (e2 instanceof ai.a) {
                return (VerifyDigestSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)e2.getMessage(), (boolean)true, VerifyDigestSignResult.class);
            }
            return (VerifyDigestSignResult)esign.utils.bean.c.a((int)esign.utils.exception.impl.a.Z.code(), (String)esign.utils.exception.impl.a.Z.message(), (boolean)true, VerifyDigestSignResult.class);
        }
    }

    private static byte[] a(String text, String hashAlgo) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digestInstance = MessageDigest.getInstance(hashAlgo);
        byte[] bytes = text.getBytes("utf-8");
        digestInstance.update(bytes, 0, bytes.length);
        return digestInstance.digest();
    }

    private TextDigestSignResult a(SignTextWithSpecFormatResult result) throws SuperException {
        TextDigestSignResult res = new TextDigestSignResult();
        res.setCert(result.getCert());
        res.setAlgorithm(result.getAlgorithm());
        res.setSignature(result.getSignature());
        res.setSignServiceId(result.getSignServiceId());
        res.setFormat(result.getFormat());
        res.setTimestampSignature(result.getTimestampSignature());
        return res;
    }

    private String c(String bizId) throws SuperException {
        WillnessServiceIdTransformModel model = (WillnessServiceIdTransformModel)((Object)this.b().g().a(InterfaceKey.WILLNESS_SERVICE_ID_TRANSFORM));
        model.setBizId(bizId);
        JsonObject json = com.timevale.esign.sdk.tech.v3.client.b.a(this.b(), model);
        WillnessServiceIdTransformResult result = (WillnessServiceIdTransformResult)JsonHelper.a((JsonObject)json, WillnessServiceIdTransformResult.class);
        if (result.getErrCode() != 0) {
            throw ErrorsDiscriptor.direct((int)result.getErrCode(), (String)result.getMsg());
        }
        return result.getWillAuthId();
    }

    private FileDigestSignResult a(String willnessAccountId, String willAuthId, SigningAccount signAccount, SigningInfo signInfo) {
        com.timevale.esign.sdk.tech.v3.sign.signway.a signWay;
        SignPDFDocBean bean;
        try {
            com.timevale.esign.sdk.tech.v3.common.b.a(willnessAccountId, signAccount);
            com.timevale.esign.sdk.tech.v3.common.b.a(signInfo.getFile());
            bean = this.a(signInfo.getFile());
            signWay = f.a(this.b()).f(willAuthId).g(willnessAccountId).h(signAccount.getAppointCertId()).a(signAccount.getAppointCertType()).a();
        }
        catch (SuperException superException) {
            SuperException e2 = superException;
            return (FileDigestSignResult)esign.utils.bean.c.a((int)superException.getCode(), (String)e2.getMessage(), (boolean)true, FileDigestSignResult.class);
        }
        FileDigestSignResult fileDigestSignResult = this.a(bean, signInfo.getSignPos(), signInfo.getSignType(), signInfo.getSealData(), signWay, signAccount.getSignAccountId());
        if (signInfo.getFile() != null) {
            fileDigestSignResult.setMarkBit(signInfo.getFile().getMarkBit());
        }
        return fileDigestSignResult;
    }

    private static interface a {
        public Callable<FileDigestSignResult> a(String var1, MultiSignParamBean var2, String var3, String var4);
    }

    private static interface b {
        public Callable<FileDigestSignResult> a(String var1, SignParamBean var2, String var3, String var4);
    }
}

