/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.v3.client;

import com.timevale.esign.sdk.tech.bean.result.Result;
import com.timevale.esign.sdk.tech.v3.client.ServiceClient;
import com.timevale.esign.sdk.tech.v3.client.a;
import com.timevale.esign.sdk.tech.v3.client.c;
import com.timevale.esign.sdk.tech.v3.client.d;
import com.timevale.tech.sdk.bean.HttpConnectionConfig;
import com.timevale.tech.sdk.bean.ProjectConfig;
import com.timevale.tech.sdk.bean.SignatureConfig;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.exception.collector.meta.ErrorMeta;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceClientManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceClientManager.class);
    public static final int CLIENT_VERSION_1 = 1;
    public static final int CLIENT_VERSION_2 = 2;
    public static final int CLIENT_MAX_NUM = 100;
    private static ConcurrentHashMap<String, ServiceClient> clients = new ConcurrentHashMap(128);
    private static volatile String defaultProjectId;
    private static Semaphore size;
    private static AtomicBoolean defaultInit;

    public static Result registClient(ProjectConfig projectConfig, HttpConnectionConfig httpConfig, SignatureConfig signatureConfig) {
        return ServiceClientManager.registVersionClient(projectConfig, httpConfig, signatureConfig, 2);
    }

    public static ServiceClient get(String projectId) {
        if (StringUtils.isEmpty((String)projectId)) {
            return null;
        }
        return clients.get(projectId);
    }

    public static ServiceClient getDefault() {
        return ServiceClientManager.get(defaultProjectId);
    }

    public static void shutdown(String projectId) {
        ServiceClient client = clients.remove(projectId);
        client.shutdown();
        size.release();
    }

    static Result registDefaultClient(ProjectConfig projectConfig, HttpConnectionConfig httpConfig, SignatureConfig signatureConfig, int version) {
        Result res;
        if (!defaultInit.compareAndSet(false, true)) {
            return (Result)esign.utils.bean.c.a((ErrorMeta)ErrorsDiscriptor.V, Result.class);
        }
        if (StringUtils.isEmpty((String)defaultProjectId)) {
            res = ServiceClientManager.registVersionClient(projectConfig, httpConfig, signatureConfig, version);
        } else {
            try {
                ServiceClient client = ServiceClientManager.createVersionClient(projectConfig, httpConfig, signatureConfig, version);
                clients.put(projectConfig.getProjectId(), client);
                clients.remove(defaultProjectId);
                res = new Result();
            }
            catch (SuperException e2) {
                LOGGER.error("initializing default sdk client failed. code:{}, msg:{}", (Object)e2.getCode(), (Object)e2.getMessage());
                res = (Result)esign.utils.bean.c.a((SuperException)e2, Result.class);
            }
            catch (Exception ex) {
                LOGGER.error("initializing default sdk client error.", (Throwable)ex);
                res = (Result)esign.utils.bean.c.b((Exception)ex, Result.class);
            }
        }
        if (res.getErrCode() == 0) {
            defaultProjectId = projectConfig.getProjectId();
        }
        defaultInit.set(false);
        return res;
    }

    private static Result registVersionClient(ProjectConfig projectConfig, HttpConnectionConfig httpConfig, SignatureConfig signatureConfig, int version) {
        if (!size.tryAcquire()) {
            return (Result)esign.utils.bean.c.a((ErrorMeta)ErrorsDiscriptor.U, Result.class);
        }
        try {
            ServiceClient client = ServiceClientManager.createVersionClient(projectConfig, httpConfig, signatureConfig, version);
            clients.put(projectConfig.getProjectId(), client);
        }
        catch (SuperException e2) {
            size.release();
            LOGGER.error("initializing sdk client failed. code:{}, msg:{}", (Object)e2.getCode(), (Object)e2.getMessage());
            return (Result)esign.utils.bean.c.a((SuperException)e2, Result.class);
        }
        catch (Exception ex) {
            size.release();
            LOGGER.error("initializing sdk client error.", (Throwable)ex);
            return (Result)esign.utils.bean.c.b((Exception)ex, Result.class);
        }
        return new Result();
    }

    private static ServiceClient createVersionClient(ProjectConfig projectConfig, HttpConnectionConfig httpConfig, SignatureConfig signatureConfig, int version) throws SuperException {
        a client;
        switch (version) {
            case 1: {
                client = new c(projectConfig, httpConfig, signatureConfig);
                break;
            }
            default: {
                client = new d(projectConfig, httpConfig, signatureConfig);
            }
        }
        return client;
    }

    static {
        size = new Semaphore(100);
        defaultInit = new AtomicBoolean(false);
    }
}

