/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.v3.service.impl;

import com.timevale.esign.sdk.tech.bean.PdfHashBean;
import com.timevale.esign.sdk.tech.bean.PdfHashDocument;
import com.timevale.esign.sdk.tech.bean.PdfHashSignFieldBean;
import com.timevale.esign.sdk.tech.bean.PdfSignatureMergeBean;
import com.timevale.esign.sdk.tech.bean.SignatureAddTimestampBean;
import com.timevale.esign.sdk.tech.bean.SignatureDetailBean;
import com.timevale.esign.sdk.tech.bean.VerifyPdfSignatureBean;
import com.timevale.esign.sdk.tech.bean.result.CreateSignDetailResult;
import com.timevale.esign.sdk.tech.bean.result.PdfHashResult;
import com.timevale.esign.sdk.tech.bean.result.PdfPKCS7BuildResult;
import com.timevale.esign.sdk.tech.bean.result.PdfSignatureMergeResult;
import com.timevale.esign.sdk.tech.bean.result.SignatureAddTimestampResult;
import com.timevale.esign.sdk.tech.bean.result.VerifyPdfSignatureResult;
import com.timevale.esign.sdk.tech.bean.seal.PdfPKCS7BuildBean;
import com.timevale.esign.sdk.tech.impl.constants.HashAlgorithm;
import com.timevale.esign.sdk.tech.v3.service.PdfHashSignService;
import com.timevale.esign.sdk.tech.v3.service.impl.a;
import com.timevale.esign.sdk.tech.v3.sign.c;
import com.timevale.esign.sdk.tech.v3.util.SignAlgorithm;
import com.timevale.esign.sdk.tech.v3.util.af;
import com.timevale.j;
import com.timevale.tech.sdk.utils.b;
import com.timevale.tgpdfsign.sign.i;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class e
extends a
implements PdfHashSignService {
    private static final Logger a = LoggerFactory.getLogger(e.class);

    public e(com.timevale.esign.sdk.tech.v3.client.a client) {
        super(client);
    }

    @Override
    public PdfHashResult pdfHash(PdfHashBean pdfHashBean) {
        com.timevale.tgpdfsign.sign.e pdfSign = new com.timevale.tgpdfsign.sign.e();
        try {
            pdfHashBean.valid();
            PdfHashDocument document = pdfHashBean.getDocument();
            if (StringUtils.isNotBlank((String)document.getFilePassword())) {
                pdfSign.c(document.getFilePassword().getBytes());
            }
            if (null != document.getSrcFileBytes()) {
                pdfSign.a(document.getSrcFileBytes());
            } else {
                pdfSign.a(document.getScrFilePath());
            }
            pdfSign.a(this.a(pdfHashBean.getSignFields()));
            pdfSign.b(document.getTempFileStream(), null);
            byte[] fileContentBytes = pdfSign.o();
            j digest = new j();
            digest.a(fileContentBytes);
            byte[] signOrigin = digest.b();
            String originBase64 = b.a(signOrigin).replace("\n", "");
            String pdfSignHash = af.a(signOrigin, HashAlgorithm.SM3);
            PdfHashResult result = new PdfHashResult();
            result.setOriginHash(originBase64);
            result.setSignFieldName(pdfSign.d());
            result.setSignHash(pdfSignHash);
            CreateSignDetailResult signDetail = c.a(this.b());
            result.setSignServiceId(signDetail.getSignServiceId());
            PdfHashResult pdfHashResult = result;
            return pdfHashResult;
        }
        catch (SuperException e2) {
            a.warn("pdf hash failed.", (Throwable)e2);
            PdfHashResult pdfHashResult = (PdfHashResult)esign.utils.bean.c.a((SuperException)e2, PdfHashResult.class);
            return pdfHashResult;
        }
        catch (Exception e3) {
            a.error("pdf hash failed.", (Throwable)e3);
            PdfHashResult pdfHashResult = (PdfHashResult)esign.utils.bean.c.a((int)ErrorsDiscriptor.ah.code(), (String)e3.getMessage(), (boolean)true, PdfHashResult.class);
            return pdfHashResult;
        }
        finally {
            pdfSign.e();
        }
    }

    @Override
    public PdfPKCS7BuildResult buildPKCS7Signature(PdfPKCS7BuildBean buildBean) {
        try {
            buildBean.valid();
            PdfPKCS7BuildResult result = new PdfPKCS7BuildResult();
            result.setSignature(af.a(b.a(buildBean.getOriginHash()), buildBean.getPkcs1Signature(), buildBean.getCertificate(), SignAlgorithm.SM3WITHSM2));
            return result;
        }
        catch (SuperException e2) {
            a.warn("build pkcs7 failed.", (Throwable)e2);
            return (PdfPKCS7BuildResult)esign.utils.bean.c.a((SuperException)e2, PdfPKCS7BuildResult.class);
        }
        catch (Exception e3) {
            a.error("build pkcs7 failed.", (Throwable)e3);
            return (PdfPKCS7BuildResult)esign.utils.bean.c.a((int)ErrorsDiscriptor.ah.code(), (String)e3.getMessage(), (boolean)true, PdfPKCS7BuildResult.class);
        }
    }

    @Override
    public SignatureAddTimestampResult addTimestamp(SignatureAddTimestampBean timestampBean) {
        try {
            timestampBean.valid();
            SignatureAddTimestampResult result = new SignatureAddTimestampResult();
            result.setSignature(af.a(timestampBean.getSignature(), timestampBean.getTimestampUrl()));
            return result;
        }
        catch (SuperException e2) {
            a.warn("add timestamp failed.", (Throwable)e2);
            return (SignatureAddTimestampResult)esign.utils.bean.c.a((SuperException)e2, SignatureAddTimestampResult.class);
        }
        catch (Exception e3) {
            a.error("add timestamp failed.", (Throwable)e3);
            return (SignatureAddTimestampResult)esign.utils.bean.c.a((int)ErrorsDiscriptor.ah.code(), (String)e3.getMessage(), (boolean)true, SignatureAddTimestampResult.class);
        }
    }

    @Override
    public PdfSignatureMergeResult pdfSignatureMerge(PdfSignatureMergeBean mergeBean) {
        com.timevale.tgpdfsign.sign.e mergeSigner = new com.timevale.tgpdfsign.sign.e();
        try {
            mergeBean.valid();
            mergeSigner.a(mergeBean.getSignature(), mergeBean.getTempFilePath(), mergeBean.getTempFileStream(), mergeBean.getFilePassword(), mergeBean.getSignedFileStream(), null, mergeBean.getSignFieldName(), null);
            c.a(this.b(), null, "pdfHashSign", mergeBean.getSignature(), "hash sign", null, mergeBean.getSignServiceId(), null, null, null);
            PdfSignatureMergeResult pdfSignatureMergeResult = new PdfSignatureMergeResult();
            return pdfSignatureMergeResult;
        }
        catch (SuperException e2) {
            a.warn("pdf signature merge failed.", (Throwable)e2);
            PdfSignatureMergeResult pdfSignatureMergeResult = (PdfSignatureMergeResult)esign.utils.bean.c.a((SuperException)e2, PdfSignatureMergeResult.class);
            return pdfSignatureMergeResult;
        }
        catch (Exception e3) {
            a.error("pdf signature merge.", (Throwable)e3);
            PdfSignatureMergeResult pdfSignatureMergeResult = (PdfSignatureMergeResult)esign.utils.bean.c.a((int)ErrorsDiscriptor.ah.code(), (String)e3.getMessage(), (boolean)true, PdfSignatureMergeResult.class);
            return pdfSignatureMergeResult;
        }
        finally {
            mergeSigner.e();
        }
    }

    @Override
    public VerifyPdfSignatureResult verifyPdfSignature(VerifyPdfSignatureBean verifyBean) {
        try {
            verifyBean.valid();
            List<SignatureDetailBean> signatureDetailList = af.a(verifyBean.getFilePath(), verifyBean.getFileBytes(), verifyBean.getFilePassword());
            if (CollectionUtils.isEmpty(signatureDetailList)) {
                return (VerifyPdfSignatureResult)esign.utils.bean.c.a((int)200003, (String)"\u6587\u4ef6\u6ca1\u6709\u76d6\u7ae0", (boolean)false, VerifyPdfSignatureResult.class);
            }
            VerifyPdfSignatureResult result = new VerifyPdfSignatureResult();
            result.setSignatureDetailList(signatureDetailList);
            return result;
        }
        catch (SuperException e2) {
            a.warn("verify pdf signature failed.", (Throwable)e2);
            return (VerifyPdfSignatureResult)esign.utils.bean.c.a((SuperException)e2, VerifyPdfSignatureResult.class);
        }
        catch (Exception e3) {
            a.error("verify pdf signature failed.", (Throwable)e3);
            return (VerifyPdfSignatureResult)esign.utils.bean.c.a((int)ErrorsDiscriptor.ah.code(), (String)e3.getMessage(), (boolean)true, VerifyPdfSignatureResult.class);
        }
    }

    private List<i> a(List<PdfHashSignFieldBean> signFields) {
        ArrayList<i> signatures = new ArrayList<i>();
        for (PdfHashSignFieldBean signFieldBean : signFields) {
            i signature = new i();
            signature.b(signFieldBean.getPosX());
            signature.c(signFieldBean.getPosY());
            signature.e(1);
            signature.c(1);
            signature.d(1);
            signature.i(String.valueOf(signFieldBean.getPage()));
            signature.g(1);
            signature.d(false);
            com.timevale.tgpdfsign.seal.a picture = signature.t().a().b();
            picture.c((float)signFieldBean.getHeight().intValue());
            picture.b((float)signFieldBean.getWidth().intValue());
            picture.a(signFieldBean.getImageBase64());
            signatures.add(signature);
        }
        return signatures;
    }
}

