/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.v3.util;

import com.timevale.esign.sdk.tech.bean.result.VerifyDigitalSignBean;
import com.timevale.esign.sdk.tech.bean.result.VerifyDigitalSignP1Bean;
import com.timevale.esign.sdk.tech.bean.result.VerifyDigitalSignP7Bean;
import com.timevale.esign.sdk.tech.impl.constants.VerificationAlgorithm;
import com.timevale.esign.sdk.tech.v3.util.ad;
import com.timevale.esign.sdk.tech.v3.util.ai;
import com.timevale.esign.sdk.tech.v3.util.o;
import com.timevale.esign.sdk.tech.v3.util.u;
import esign.utils.a;
import java.nio.charset.Charset;
import org.apache.commons.lang.StringUtils;

public enum SignatureVerifyEnum implements o
{
    SHA256WITHRSA_P1(VerificationAlgorithm.SHA256WITHRSA.getSignAlg(), false){

        @Override
        public boolean verify(VerifyDigitalSignBean verifyDigitalSignBean) throws Exception {
            if (verifyDigitalSignBean instanceof VerifyDigitalSignP1Bean) {
                VerifyDigitalSignP1Bean bean = (VerifyDigitalSignP1Bean)verifyDigitalSignBean;
                u ras = new u(new byte[0], a.a((String)bean.getCert()));
                return ai.a(bean.getPlainText().getBytes("utf-8"), a.a((String)bean.getSignature()), a.a((String)bean.getTimestampSignature()), ras);
            }
            return false;
        }
    }
    ,
    SM3WITHSM2_P1(VerificationAlgorithm.SM3WITHSM2.getSignAlg(), false){

        @Override
        public boolean verify(VerifyDigitalSignBean verifyDigitalSignBean) throws Exception {
            if (verifyDigitalSignBean instanceof VerifyDigitalSignP1Bean) {
                VerifyDigitalSignP1Bean bean = (VerifyDigitalSignP1Bean)verifyDigitalSignBean;
                ad ras = new ad(new byte[0], a.a((String)bean.getCert()));
                return ai.a(bean.getPlainText().getBytes("utf-8"), a.a((String)bean.getSignature()), a.a((String)bean.getTimestampSignature()), ras);
            }
            return false;
        }
    }
    ,
    SHA256WITHRSA_P7(VerificationAlgorithm.SHA256WITHRSA.getSignAlg(), true){

        @Override
        public boolean verify(VerifyDigitalSignBean verifyDigitalSignBean) throws Exception {
            VerifyDigitalSignP7Bean bean = (VerifyDigitalSignP7Bean)verifyDigitalSignBean;
            return ai.a(StringUtils.isEmpty((String)bean.getPlainText()) ? new byte[]{} : bean.getPlainText().getBytes(Charset.forName("utf-8")), a.a((String)bean.getSignature()));
        }
    }
    ,
    SM3WITHSM2_P7(VerificationAlgorithm.SM3WITHSM2.getSignAlg(), true){

        @Override
        public boolean verify(VerifyDigitalSignBean verifyDigitalSignBean) throws Exception {
            VerifyDigitalSignP7Bean bean = (VerifyDigitalSignP7Bean)verifyDigitalSignBean;
            return ai.a(StringUtils.isEmpty((String)bean.getPlainText()) ? new byte[]{} : bean.getPlainText().getBytes(Charset.forName("utf-8")), a.a((String)bean.getSignature()));
        }
    };

    private String alg;
    private boolean p7;

    private SignatureVerifyEnum(String alg, boolean p7) {
        this.alg = alg;
        this.p7 = p7;
    }

    public static SignatureVerifyEnum getVerifyEnumByAlgAndPkcs(String alg, boolean p7) {
        for (SignatureVerifyEnum verifyEnum : SignatureVerifyEnum.values()) {
            if (!verifyEnum.getAlg().equalsIgnoreCase(alg) || verifyEnum.isP7() != p7) continue;
            return verifyEnum;
        }
        return null;
    }

    public String getAlg() {
        return this.alg;
    }

    public boolean isP7() {
        return this.p7;
    }
}

