/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.v3.util;

import com.timevale.esign.sdk.tech.bean.TechCertInfo;
import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERIA5String;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.CRLDistPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPoint;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPointName;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralName;
import com.timevale.tgtext.bouncycastle.asn1.x509.GeneralNames;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509CertificateStructure;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extension;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509Extensions;
import esign.utils.a;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;

public class c {
    public static TechCertInfo a(byte[] certBytes) {
        try {
            TechCertInfo ci = new TechCertInfo();
            String keytool = "BC";
            if ("BC".equals("FishermanJCE")) {
                ByteArrayInputStream fi = new ByteArrayInputStream(certBytes);
                X509Certificate x509 = null;
                CertificateFactory cf2 = CertificateFactory.getInstance("X.509", "FishermanJCE");
                while (((InputStream)fi).available() > 0) {
                    x509 = (X509Certificate)cf2.generateCertificate(fi);
                }
                if (x509 != null) {
                    ci.setSerialNumber(x509.getSerialNumber().toString(16));
                    ci.setVersion("" + x509.getVersion());
                    ci.setIssue(x509.getIssuerDN().toString());
                    ci.setSubject(x509.getSubjectDN().toString());
                    ci.setStartTime(x509.getNotBefore());
                    ci.setEndTime(x509.getNotAfter());
                    ci.setIssue_cn(c.a(x509.getIssuerDN().toString(), "CN="));
                    ci.setIssue_email(c.a(x509.getIssuerDN().toString(), "EMAIL="));
                    ci.setIssue_givenname(c.a(x509.getIssuerDN().toString(), "GIVENNAME="));
                    ci.setIssue_ou(c.a(x509.getIssuerDN().toString(), "OU="));
                    ci.setIssue_c(c.a(x509.getIssuerDN().toString(), "C="));
                    ci.setIssue_o(c.a(x509.getIssuerDN().toString(), "O="));
                    ci.setIssue_l(c.a(x509.getIssuerDN().toString(), "L="));
                    ci.setIssue_s(c.a(x509.getIssuerDN().toString(), "ST="));
                    ci.setSubject_cn(c.a(x509.getSubjectDN().toString(), "CN="));
                    ci.setSubject_phone(c.a(x509.getSubjectDN().toString(), "TelephoneNumber="));
                    ci.setSubject_email(c.a(x509.getSubjectDN().toString(), "EMAIL="));
                    ci.setSubject_givenname(c.a(x509.getSubjectDN().toString(), "GIVENNAME="));
                    ci.setSubject_ou(c.a(x509.getSubjectDN().toString(), "OU="));
                    ci.setSubject_c(c.a(x509.getSubjectDN().toString(), "C="));
                    ci.setSubject_o(c.a(x509.getSubjectDN().toString(), "O="));
                    ci.setSubject_l(c.a(x509.getSubjectDN().toString(), "L="));
                    ci.setSubject_s(c.a(x509.getSubjectDN().toString(), "ST="));
                    ci.setSignalg(x509.getSigAlgName());
                    ci.setCatype(x509.getBasicConstraints());
                    ci.setPubkey(a.a((byte[])x509.getPublicKey().getEncoded()));
                    boolean[] ku = x509.getKeyUsage();
                    String keyusages = "";
                    if (ku != null && ku.length == 9) {
                        if (ku[0]) {
                            keyusages = keyusages + "digitalSignature,";
                        }
                        if (ku[1]) {
                            keyusages = keyusages + "nonRepudiation,";
                        }
                        if (ku[2]) {
                            keyusages = keyusages + "keyEncipherment,";
                        }
                        if (ku[3]) {
                            keyusages = keyusages + "dataEncipherment,";
                        }
                        if (ku[4]) {
                            keyusages = keyusages + "keyAgreement,";
                        }
                        if (ku[5]) {
                            keyusages = keyusages + "keyCertSign,";
                        }
                        if (ku[6]) {
                            keyusages = keyusages + "cRLSign,";
                        }
                        if (ku[7]) {
                            keyusages = keyusages + "encipherOnly,";
                        }
                        if (ku[8]) {
                            keyusages = keyusages + "decipherOnly,";
                        }
                    }
                    ci.setKeyusage(keyusages);
                    List<String> extkeyusages = x509.getExtendedKeyUsage();
                    String extkeyusage = "";
                    if (extkeyusages != null && extkeyusages.size() >= 0) {
                        for (int i2 = 0; i2 < extkeyusages.size(); ++i2) {
                            extkeyusage = extkeyusage + extkeyusages.get(i2).toString() + ",";
                        }
                    }
                    ci.setExt_extkeyusage(extkeyusage);
                    ci.setExt_cert_uniqueid(x509.getSubjectUniqueID() != null ? x509.getSubjectUniqueID().toString() : "");
                    ci.setExt_crldistributionpo(x509.getExtensionValue("2.5.29.31") != null ? new String(x509.getExtensionValue("2.5.29.31"), "UTF-8") : "");
                    x509.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                    ci.setExt_authoritykeyidentifier("");
                    ci.setExt_basicconstraints("" + x509.getBasicConstraints());
                    x509.getExtensionValue(Extension.certificatePolicies.getId());
                    ci.setExt_certificatepolicies("");
                    x509.getExtensionValue(Extension.policyMappings.getId());
                    ci.setExt_policymappings("");
                    x509.getExtensionValue(Extension.policyConstraints.getId());
                    ci.setExt_policyonstraints("");
                }
            } else {
                ByteArrayInputStream bIn = new ByteArrayInputStream(certBytes);
                ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
                ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
                X509CertificateStructure cert = new X509CertificateStructure(seq);
                ci.setSerialNumber(cert.getSerialNumber().getValue().toString(16));
                ci.setVersion("" + cert.getVersion());
                ci.setIssue(cert.getIssuer().toString());
                ci.setSubject(cert.getSubject().toString());
                ci.setStartTime(cert.getStartDate().getDate());
                ci.setEndTime(cert.getEndDate().getDate());
                ci.setIssue_cn(c.a(cert.getIssuer().toString(), "CN="));
                ci.setIssue_email(c.a(cert.getIssuer().toString(), "EMAIL="));
                ci.setIssue_givenname(c.a(cert.getIssuer().toString(), "GIVENNAME="));
                ci.setIssue_ou(c.a(cert.getIssuer().toString(), "OU="));
                ci.setIssue_c(c.a(cert.getIssuer().toString(), "C="));
                ci.setIssue_o(c.a(cert.getIssuer().toString(), "O="));
                ci.setIssue_l(c.a(cert.getIssuer().toString(), "L="));
                ci.setIssue_s(c.a(cert.getIssuer().toString(), "ST="));
                ci.setSubject_cn(c.a(cert.getSubject().toString(), "CN="));
                ci.setSubject_email(c.a(cert.getSubject().toString(), "EMAIL="));
                ci.setSubject_phone(c.a(cert.getSubject().toString(), "TelephoneNumber="));
                ci.setSubject_givenname(c.a(cert.getSubject().toString(), "GIVENNAME="));
                ci.setSubject_ou(c.a(cert.getSubject().toString(), "OU="));
                ci.setSubject_c(c.a(cert.getSubject().toString(), "C="));
                ci.setSubject_o(c.a(cert.getSubject().toString(), "O="));
                ci.setSubject_l(c.a(cert.getSubject().toString(), "L="));
                ci.setSubject_s(c.a(cert.getSubject().toString(), "ST="));
                cert.getSubjectPublicKeyInfo();
                byte[] byPuk = cert.getSubjectPublicKeyInfo().getPublicKeyData().getEncoded();
                String strPuk = a.a((byte[])byPuk);
                ci.setPubkey(strPuk);
                X509Extensions ext = cert.getTBSCertificate().getExtensions();
                ci.setExt_crldistributionpo(c.a(ext));
            }
            return ci;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return null;
        }
    }

    public static String a(String dn, String key) {
        String result = "";
        String[] infos = dn.split(",");
        if (infos.length > 0) {
            for (int i2 = 0; i2 < infos.length; ++i2) {
                infos[i2] = infos[i2].trim();
                if (!infos[i2].toUpperCase().contains(key.toUpperCase())) continue;
                result = infos[i2].substring(infos[i2].indexOf(key.toUpperCase()) + key.length(), infos[i2].length());
            }
        }
        return result;
    }

    private static String a(X509Extensions ext) throws IOException {
        String crlUrls = "";
        byte[] crldpExt = c.a(X509Extensions.CRLDistributionPoints.getId(), ext);
        if (crldpExt == null) {
            return crlUrls;
        }
        ASN1InputStream oAsnInStream = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExt));
        byte[] crldpExtOctets = oAsnInStream.readObject().getEncoded();
        ASN1InputStream oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExtOctets));
        CRLDistPoint distPoint = CRLDistPoint.getInstance((Object)oAsnInStream2.readObject());
        for (DistributionPoint dp : distPoint.getDistributionPoints()) {
            DistributionPointName dpn = dp.getDistributionPoint();
            if (dpn == null || dpn.getType() != 0) continue;
            GeneralName[] genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames();
            for (int j2 = 0; j2 < genNames.length; ++j2) {
                if (genNames[j2].getTagNo() != 6) continue;
                String url = DERIA5String.getInstance((Object)genNames[j2].getName()).getString();
                crlUrls = crlUrls + url;
            }
        }
        return crlUrls;
    }

    private static byte[] a(String oid, X509Extensions exts) {
        X509Extension ext;
        if (exts != null && (ext = exts.getExtension((ASN1ObjectIdentifier)new DERObjectIdentifier(oid))) != null) {
            return ext.getValue().getOctets();
        }
        return null;
    }
}

