/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.esign.sdk.tech.v3.util;

import com.timevale.esign.sdk.tech.v3.util.n;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.DEROutputStream;
import com.timevale.tgtext.bouncycastle.asn1.cms.ContentInfo;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.jcajce.JcaCertStore;
import com.timevale.tgtext.bouncycastle.cms.CMSProcessable;
import com.timevale.tgtext.bouncycastle.cms.CMSProcessableByteArray;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedData;
import com.timevale.tgtext.bouncycastle.cms.CMSSignedDataGenerator;
import com.timevale.tgtext.bouncycastle.cms.CMSTypedData;
import com.timevale.tgtext.bouncycastle.cms.SignerInformation;
import com.timevale.tgtext.bouncycastle.cms.SignerInformationStore;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import com.timevale.tgtext.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import com.timevale.tgtext.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import com.timevale.tgtext.bouncycastle.util.Selector;
import com.timevale.tgtext.bouncycastle.util.Store;
import esign.utils.security.provider.Provider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class v {
    private static final Logger a = LoggerFactory.getLogger(n.class);

    public static String a(String privateKeyStr, String originDataStr, String signalg) {
        try {
            byte[] privateKey = Base64.decodeBase64((String)privateKeyStr);
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PrivateKey priKey = keyFactory.generatePrivate(pkcs8KeySpec);
            Signature signet = Signature.getInstance(signalg);
            signet.initSign(priKey);
            signet.update(originDataStr.getBytes("utf-8"));
            return Base64.encodeBase64String((byte[])signet.sign());
        }
        catch (Exception e2) {
            a.error("PKCS1\u7b7e\u540d\u5f02\u5e38: ", (Throwable)e2);
            return null;
        }
    }

    public static boolean a(String publicKeyStr, String originDataStr, String signDataStr, String signalg) {
        try {
            Signature signatureChecker = Signature.getInstance(signalg);
            ByteArrayInputStream fi = new ByteArrayInputStream(Base64.decodeBase64((String)publicKeyStr));
            Certificate cert = null;
            CertificateFactory cf2 = CertificateFactory.getInstance("X.509");
            while (((InputStream)fi).available() > 0) {
                cert = cf2.generateCertificate(fi);
            }
            if (cert != null) {
                signatureChecker.initVerify(cert.getPublicKey());
                signatureChecker.update(originDataStr.getBytes("utf-8"));
                return signatureChecker.verify(Base64.decodeBase64((String)signDataStr));
            }
        }
        catch (Throwable e2) {
            a.error("PKCS1\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38: ", e2);
        }
        return false;
    }

    public static boolean a(String signedDataStr, String originDataStr) {
        byte[] signedData = Base64.decodeBase64((String)signedDataStr);
        byte[] originData = null;
        if (originDataStr != null) {
            originData = originDataStr.getBytes(Charset.forName("utf-8"));
        }
        try {
            CMSSignedData sd;
            if (originData != null) {
                CMSProcessableByteArray msg = new CMSProcessableByteArray(originData);
                sd = new CMSSignedData((CMSProcessable)msg, signedData);
            } else {
                sd = new CMSSignedData(signedData);
            }
            Store store = sd.getCertificates();
            SignerInformationStore signers = sd.getSignerInfos();
            Collection c2 = signers.getSigners();
            Iterator it = c2.iterator();
            if (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                Collection certCollection = store.getMatches((Selector)signer.getSID());
                Iterator certIt = certCollection.iterator();
                X509CertificateHolder cert = (X509CertificateHolder)certIt.next();
                return signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(cert));
            }
        }
        catch (Exception e2) {
            a.error("PKCS7\u7b7e\u540d\u6821\u9a8c\u5f02\u5e38: ", (Throwable)e2);
        }
        return false;
    }

    public static String b(String publicKeyStr, String originDataStr, String signedDataType, String privateKeyStr) throws Exception {
        String string;
        byte[] data = originDataStr.getBytes(Charset.forName("utf-8"));
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64((String)privateKeyStr));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
        byte[] certByteValue = Base64.decodeBase64((byte[])publicKeyStr.getBytes(Charset.forName("utf-8")));
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream inputStream = new ByteArrayInputStream(certByteValue);
        X509Certificate cerx509 = (X509Certificate)certFactory.generateCertificate(inputStream);
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(cerx509);
        JcaCertStore certs = new JcaCertStore(certList);
        ContentSigner contentSigner = new JcaContentSignerBuilder(cerx509.getSigAlgName()).setProvider("BC").build(privateKey);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).setDirectSignature(true).build(contentSigner, cerx509));
        gen.addCertificates((Store)certs);
        CMSProcessableByteArray msg = new CMSProcessableByteArray(data);
        boolean isAttached = false;
        if ("Attached".equals(signedDataType)) {
            isAttached = true;
        }
        if ("Detached".equals(signedDataType)) {
            isAttached = false;
        }
        CMSSignedData sigData = gen.generate((CMSTypedData)msg, isAttached);
        ContentInfo a2 = sigData.toASN1Structure();
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            String signedDataBase64;
            DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
            dOut.writeObject((ASN1Encodable)a2);
            string = signedDataBase64 = new String(Base64.encodeBase64((byte[])bOut.toByteArray()), Charset.forName("utf-8"));
        }
        catch (Throwable throwable) {
            try {
                bOut.close();
                throw throwable;
            }
            catch (Exception e2) {
                a.error("PKCS7\u7b7e\u540d\u5f02\u5e38: ", (Throwable)e2);
                return null;
            }
        }
        bOut.close();
        return string;
    }

    static {
        Provider.BC.install();
    }
}

