/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.base;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Platform;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.base.Predicate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.c;

@Beta
@GwtCompatible
public abstract class CharMatcher
implements Predicate<Character> {
    private static final String BREAKING_WHITESPACE_CHARS = "\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000";
    private static final String NON_BREAKING_WHITESPACE_CHARS = "\u00a0\u180e\u202f";
    public static final CharMatcher WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000\u00a0\u180e\u202f").or(CharMatcher.inRange('\u2000', '\u200a')).precomputed();
    public static final CharMatcher BREAKING_WHITESPACE = CharMatcher.anyOf("\t\n\u000b\f\r \u0085\u1680\u2028\u2029\u205f\u3000").or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200a')).precomputed();
    public static final CharMatcher ASCII = CharMatcher.inRange('\u0000', '\u007f');
    public static final CharMatcher DIGIT;
    public static final CharMatcher JAVA_WHITESPACE;
    public static final CharMatcher JAVA_DIGIT;
    public static final CharMatcher JAVA_LETTER;
    public static final CharMatcher JAVA_LETTER_OR_DIGIT;
    public static final CharMatcher JAVA_UPPER_CASE;
    public static final CharMatcher JAVA_LOWER_CASE;
    public static final CharMatcher JAVA_ISO_CONTROL;
    public static final CharMatcher INVISIBLE;
    public static final CharMatcher SINGLE_WIDTH;
    public static final CharMatcher ANY;
    public static final CharMatcher NONE;

    public static CharMatcher is(final char match) {
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return c2 == match;
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                return ((Object)sequence).toString().replace(match, replacement);
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                if (other.matches(match)) {
                    return this;
                }
                return NONE;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                if (other.matches(match)) {
                    return other;
                }
                return super.or(other);
            }

            @Override
            public CharMatcher negate() {
                return 8.isNot(match);
            }

            @Override
            void setBits(LookupTable table) {
                table.set(match);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher isNot(final char match) {
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return c2 != match;
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                if (other.matches(match)) {
                    return super.and(other);
                }
                return other;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                if (other.matches(match)) {
                    return ANY;
                }
                return this;
            }

            @Override
            public CharMatcher negate() {
                return 9.is(match);
            }
        };
    }

    public static CharMatcher anyOf(CharSequence sequence) {
        switch (sequence.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is(sequence.charAt(0));
            }
            case 2: {
                final char match1 = sequence.charAt(0);
                final char match2 = sequence.charAt(1);
                return new CharMatcher(){

                    @Override
                    public boolean matches(char c2) {
                        return c2 == match1 || c2 == match2;
                    }

                    @Override
                    void setBits(LookupTable table) {
                        table.set(match1);
                        table.set(match2);
                    }

                    @Override
                    public CharMatcher precomputed() {
                        return this;
                    }
                };
            }
        }
        final char[] chars = ((Object)sequence).toString().toCharArray();
        Arrays.sort(chars);
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Arrays.binarySearch(chars, c2) >= 0;
            }

            @Override
            void setBits(LookupTable table) {
                char[] arr$ = chars;
                int len$ = chars.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    char c2 = arr$[i$];
                    table.set(c2);
                }
            }
        };
    }

    public static CharMatcher noneOf(CharSequence sequence) {
        return CharMatcher.anyOf(sequence).negate();
    }

    public static CharMatcher inRange(final char startInclusive, final char endInclusive) {
        Preconditions.checkArgument(endInclusive >= startInclusive);
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return startInclusive <= c2 && c2 <= endInclusive;
            }

            @Override
            void setBits(LookupTable table) {
                char c2;
                char c3 = startInclusive;
                do {
                    table.set(c3);
                    c2 = c3;
                    c3 = (char)(c3 + '\u0001');
                } while (c2 != endInclusive);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    public static CharMatcher forPredicate(final Predicate<? super Character> predicate) {
        Preconditions.checkNotNull(predicate);
        if (predicate instanceof CharMatcher) {
            return (CharMatcher)predicate;
        }
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return predicate.apply(Character.valueOf(c2));
            }

            @Override
            public boolean apply(Character character) {
                return predicate.apply(Preconditions.checkNotNull(character));
            }
        };
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        final CharMatcher original = this;
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return !original.matches(c2);
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                return original.matchesNoneOf(sequence);
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                return original.matchesAllOf(sequence);
            }

            @Override
            public int countIn(CharSequence sequence) {
                return sequence.length() - original.countIn(sequence);
            }

            @Override
            public CharMatcher negate() {
                return original;
            }
        };
    }

    public CharMatcher and(CharMatcher other) {
        return new And(Arrays.asList(this, Preconditions.checkNotNull(other)));
    }

    public CharMatcher or(CharMatcher other) {
        return new Or(Arrays.asList(this, Preconditions.checkNotNull(other)));
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    CharMatcher precomputedInternal() {
        final LookupTable table = new LookupTable();
        this.setBits(table);
        return new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return table.get(c2);
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    void setBits(LookupTable table) {
        char c2;
        char c3 = '\u0000';
        do {
            if (this.matches(c3)) {
                table.set(c3);
            }
            c2 = c3;
            c3 = (char)(c3 + '\u0001');
        } while (c2 != 65535);
    }

    public boolean matchesAnyOf(CharSequence sequence) {
        return !this.matchesNoneOf(sequence);
    }

    public boolean matchesAllOf(CharSequence sequence) {
        for (int i2 = sequence.length() - 1; i2 >= 0; --i2) {
            if (this.matches(sequence.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence sequence) {
        return this.indexIn(sequence) == -1;
    }

    public int indexIn(CharSequence sequence) {
        int length = sequence.length();
        for (int i2 = 0; i2 < length; ++i2) {
            if (!this.matches(sequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int indexIn(CharSequence sequence, int start) {
        int length = sequence.length();
        Preconditions.checkPositionIndex(start, length);
        for (int i2 = start; i2 < length; ++i2) {
            if (!this.matches(sequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence sequence) {
        for (int i2 = sequence.length() - 1; i2 >= 0; --i2) {
            if (!this.matches(sequence.charAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public int countIn(CharSequence sequence) {
        int count = 0;
        for (int i2 = 0; i2 < sequence.length(); ++i2) {
            if (!this.matches(sequence.charAt(i2))) continue;
            ++count;
        }
        return count;
    }

    @c
    public String removeFrom(CharSequence sequence) {
        String string = ((Object)sequence).toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        int spread = 1;
        while (++pos != chars.length) {
            if (!this.matches(chars[pos])) {
                chars[pos - spread] = chars[pos];
                continue;
            }
            ++spread;
        }
        return new String(chars, 0, pos - spread);
    }

    @c
    public String retainFrom(CharSequence sequence) {
        return this.negate().removeFrom(sequence);
    }

    @c
    public String replaceFrom(CharSequence sequence, char replacement) {
        String string = ((Object)sequence).toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        char[] chars = cArray;
        cArray[pos] = replacement;
        for (int i2 = pos + 1; i2 < chars.length; ++i2) {
            if (!this.matches(chars[i2])) continue;
            chars[i2] = replacement;
        }
        return new String(chars);
    }

    @c
    public String replaceFrom(CharSequence sequence, CharSequence replacement) {
        int replacementLen = replacement.length();
        if (replacementLen == 0) {
            return this.removeFrom(sequence);
        }
        if (replacementLen == 1) {
            return this.replaceFrom(sequence, replacement.charAt(0));
        }
        String string = ((Object)sequence).toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        int len = string.length();
        StringBuilder buf = new StringBuilder(len * 3 / 2 + 16);
        int oldpos = 0;
        do {
            buf.append(string, oldpos, pos);
            buf.append(replacement);
        } while ((pos = this.indexIn(string, oldpos = pos + 1)) != -1);
        buf.append(string, oldpos, len);
        return buf.toString();
    }

    @c
    public String trimFrom(CharSequence sequence) {
        int last;
        int first;
        int len = sequence.length();
        for (first = 0; first < len && this.matches(sequence.charAt(first)); ++first) {
        }
        for (last = len - 1; last > first && this.matches(sequence.charAt(last)); --last) {
        }
        return ((Object)sequence.subSequence(first, last + 1)).toString();
    }

    @c
    public String trimLeadingFrom(CharSequence sequence) {
        int first;
        int len = sequence.length();
        for (first = 0; first < len && this.matches(sequence.charAt(first)); ++first) {
        }
        return ((Object)sequence.subSequence(first, len)).toString();
    }

    @c
    public String trimTrailingFrom(CharSequence sequence) {
        int last;
        int len = sequence.length();
        for (last = len - 1; last >= 0 && this.matches(sequence.charAt(last)); --last) {
        }
        return ((Object)sequence.subSequence(0, last + 1)).toString();
    }

    @c
    public String collapseFrom(CharSequence sequence, char replacement) {
        int first = this.indexIn(sequence);
        if (first == -1) {
            return ((Object)sequence).toString();
        }
        StringBuilder builder = new StringBuilder(sequence.length()).append(sequence.subSequence(0, first)).append(replacement);
        boolean in = true;
        for (int i2 = first + 1; i2 < sequence.length(); ++i2) {
            char c2 = sequence.charAt(i2);
            if (this.apply(Character.valueOf(c2))) {
                if (in) continue;
                builder.append(replacement);
                in = true;
                continue;
            }
            builder.append(c2);
            in = false;
        }
        return builder.toString();
    }

    @c
    public String trimAndCollapseFrom(CharSequence sequence, char replacement) {
        int first = this.negate().indexIn(sequence);
        if (first == -1) {
            return "";
        }
        StringBuilder builder = new StringBuilder(sequence.length());
        boolean inMatchingGroup = false;
        for (int i2 = first; i2 < sequence.length(); ++i2) {
            char c2 = sequence.charAt(i2);
            if (this.apply(Character.valueOf(c2))) {
                inMatchingGroup = true;
                continue;
            }
            if (inMatchingGroup) {
                builder.append(replacement);
                inMatchingGroup = false;
            }
            builder.append(c2);
        }
        return builder.toString();
    }

    @Override
    public boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    static {
        CharMatcher digit = CharMatcher.inRange('0', '9');
        String zeroes = "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
        for (char base : "\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10".toCharArray()) {
            digit = digit.or(CharMatcher.inRange(base, (char)(base + 9)));
        }
        DIGIT = digit.precomputed();
        JAVA_WHITESPACE = CharMatcher.inRange('\t', '\r').or(CharMatcher.inRange('\u001c', ' ')).or(CharMatcher.is('\u1680')).or(CharMatcher.is('\u180e')).or(CharMatcher.inRange('\u2000', '\u2006')).or(CharMatcher.inRange('\u2008', '\u200b')).or(CharMatcher.inRange('\u2028', '\u2029')).or(CharMatcher.is('\u205f')).or(CharMatcher.is('\u3000')).precomputed();
        JAVA_DIGIT = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Character.isDigit(c2);
            }
        };
        JAVA_LETTER = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Character.isLetter(c2);
            }
        };
        JAVA_LETTER_OR_DIGIT = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Character.isLetterOrDigit(c2);
            }
        };
        JAVA_UPPER_CASE = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Character.isUpperCase(c2);
            }
        };
        JAVA_LOWER_CASE = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return Character.isLowerCase(c2);
            }
        };
        JAVA_ISO_CONTROL = CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f'));
        INVISIBLE = CharMatcher.inRange('\u0000', ' ').or(CharMatcher.inRange('\u007f', '\u00a0')).or(CharMatcher.is('\u00ad')).or(CharMatcher.inRange('\u0600', '\u0603')).or(CharMatcher.anyOf("\u06dd\u070f\u1680\u17b4\u17b5\u180e")).or(CharMatcher.inRange('\u2000', '\u200f')).or(CharMatcher.inRange('\u2028', '\u202f')).or(CharMatcher.inRange('\u205f', '\u2064')).or(CharMatcher.inRange('\u206a', '\u206f')).or(CharMatcher.is('\u3000')).or(CharMatcher.inRange('\ud800', '\uf8ff')).or(CharMatcher.anyOf("\ufeff\ufff9\ufffa\ufffb")).precomputed();
        SINGLE_WIDTH = CharMatcher.inRange('\u0000', '\u04f9').or(CharMatcher.is('\u05be')).or(CharMatcher.inRange('\u05d0', '\u05ea')).or(CharMatcher.is('\u05f3')).or(CharMatcher.is('\u05f4')).or(CharMatcher.inRange('\u0600', '\u06ff')).or(CharMatcher.inRange('\u0750', '\u077f')).or(CharMatcher.inRange('\u0e00', '\u0e7f')).or(CharMatcher.inRange('\u1e00', '\u20af')).or(CharMatcher.inRange('\u2100', '\u213a')).or(CharMatcher.inRange('\ufb50', '\ufdff')).or(CharMatcher.inRange('\ufe70', '\ufeff')).or(CharMatcher.inRange('\uff61', '\uffdc')).precomputed();
        ANY = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return true;
            }

            @Override
            public int indexIn(CharSequence sequence) {
                if (sequence.length() == 0) {
                    return -1;
                }
                return 0;
            }

            @Override
            public int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                Preconditions.checkPositionIndex(start, length);
                if (start == length) {
                    return -1;
                }
                return start;
            }

            @Override
            public int lastIndexIn(CharSequence sequence) {
                return sequence.length() - 1;
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return true;
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                return sequence.length() == 0;
            }

            @Override
            public String removeFrom(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return "";
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                char[] array = new char[sequence.length()];
                Arrays.fill(array, replacement);
                return new String(array);
            }

            @Override
            public String replaceFrom(CharSequence sequence, CharSequence replacement) {
                StringBuilder retval = new StringBuilder(sequence.length() * replacement.length());
                for (int i2 = 0; i2 < sequence.length(); ++i2) {
                    retval.append(replacement);
                }
                return retval.toString();
            }

            @Override
            public String collapseFrom(CharSequence sequence, char replacement) {
                if (sequence.length() == 0) {
                    return "";
                }
                return String.valueOf(replacement);
            }

            @Override
            public String trimFrom(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return "";
            }

            @Override
            public int countIn(CharSequence sequence) {
                return sequence.length();
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            @Override
            public CharMatcher negate() {
                return NONE;
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
        NONE = new CharMatcher(){

            @Override
            public boolean matches(char c2) {
                return false;
            }

            @Override
            public int indexIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return -1;
            }

            @Override
            public int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                Preconditions.checkPositionIndex(start, length);
                return -1;
            }

            @Override
            public int lastIndexIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return -1;
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                return sequence.length() == 0;
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return true;
            }

            @Override
            public String removeFrom(CharSequence sequence) {
                return ((Object)sequence).toString();
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                return ((Object)sequence).toString();
            }

            @Override
            public String replaceFrom(CharSequence sequence, CharSequence replacement) {
                Preconditions.checkNotNull(replacement);
                return ((Object)sequence).toString();
            }

            @Override
            public String collapseFrom(CharSequence sequence, char replacement) {
                return ((Object)sequence).toString();
            }

            @Override
            public String trimFrom(CharSequence sequence) {
                return ((Object)sequence).toString();
            }

            @Override
            public int countIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return 0;
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            @Override
            public CharMatcher negate() {
                return ANY;
            }

            @Override
            void setBits(LookupTable table) {
            }

            @Override
            public CharMatcher precomputed() {
                return this;
            }
        };
    }

    private static final class LookupTable {
        int[] data = new int[2048];

        private LookupTable() {
        }

        void set(char index) {
            int n2 = index >> 5;
            this.data[n2] = this.data[n2] | '\u0001' << index;
        }

        boolean get(char index) {
            return (this.data[index >> 5] & '\u0001' << index) != 0;
        }
    }

    private static class Or
    extends CharMatcher {
        List<CharMatcher> components;

        Or(List<CharMatcher> components) {
            this.components = components;
        }

        @Override
        public boolean matches(char c2) {
            for (CharMatcher matcher : this.components) {
                if (!matcher.matches(c2)) continue;
                return true;
            }
            return false;
        }

        @Override
        public CharMatcher or(CharMatcher other) {
            ArrayList<CharMatcher> newComponents = new ArrayList<CharMatcher>(this.components);
            newComponents.add(Preconditions.checkNotNull(other));
            return new Or(newComponents);
        }

        @Override
        void setBits(LookupTable table) {
            for (CharMatcher matcher : this.components) {
                matcher.setBits(table);
            }
        }
    }

    private static class And
    extends CharMatcher {
        List<CharMatcher> components;

        And(List<CharMatcher> components) {
            this.components = components;
        }

        @Override
        public boolean matches(char c2) {
            for (CharMatcher matcher : this.components) {
                if (matcher.matches(c2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public CharMatcher and(CharMatcher other) {
            ArrayList<CharMatcher> newComponents = new ArrayList<CharMatcher>(this.components);
            newComponents.add(Preconditions.checkNotNull(other));
            return new And(newComponents);
        }
    }
}

