/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.base;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.base.Supplier;
import java.io.Serializable;
import javax.annotation.h;

@Beta
@GwtCompatible
public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> Optional<T> absent() {
        return Absent.INSTANCE;
    }

    public static <T> Optional<T> of(T reference) {
        return new Present<T>(Preconditions.checkNotNull(reference));
    }

    public static <T> Optional<T> fromNullable(@h T nullableReference) {
        if (nullableReference == null) {
            return Optional.absent();
        }
        return new Present<T>(nullableReference);
    }

    private Optional() {
    }

    public abstract boolean isPresent();

    public abstract T get();

    public abstract T or(T var1);

    public abstract Optional<T> or(Optional<? extends T> var1);

    @h
    public abstract T or(Supplier<? extends T> var1);

    @h
    public abstract T orNull();

    public abstract boolean equals(@h Object var1);

    public abstract int hashCode();

    public abstract String toString();

    private static final class Absent
    extends Optional<Object> {
        private static final Absent INSTANCE = new Absent();
        private static final long serialVersionUID = 0L;

        private Absent() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public Object get() {
            throw new IllegalStateException("value is absent");
        }

        @Override
        public Object or(Object defaultValue) {
            return Preconditions.checkNotNull(defaultValue, "use orNull() instead of or(null)");
        }

        @Override
        public Optional<Object> or(Optional<?> secondChoice) {
            return Preconditions.checkNotNull(secondChoice);
        }

        @Override
        @h
        public Object or(Supplier<?> supplier) {
            return supplier.get();
        }

        @Override
        @h
        public Object orNull() {
            return null;
        }

        @Override
        public boolean equals(@h Object object) {
            return object == this;
        }

        @Override
        public int hashCode() {
            return 1502476572;
        }

        @Override
        public String toString() {
            return "Optional.absent()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class Present<T>
    extends Optional<T> {
        private final T reference;
        private static final long serialVersionUID = 0L;

        Present(T reference) {
            this.reference = reference;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public T get() {
            return this.reference;
        }

        @Override
        public T or(T defaultValue) {
            Preconditions.checkNotNull(defaultValue, "use orNull() instead of or(null)");
            return this.reference;
        }

        @Override
        public Optional<T> or(Optional<? extends T> secondChoice) {
            Preconditions.checkNotNull(secondChoice);
            return this;
        }

        @Override
        public T or(Supplier<? extends T> supplier) {
            Preconditions.checkNotNull(supplier);
            return this.reference;
        }

        @Override
        public T orNull() {
            return this.reference;
        }

        @Override
        public boolean equals(@h Object object) {
            if (object instanceof Present) {
                Present other = (Present)object;
                return this.reference.equals(other.reference);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 1502476572 + this.reference.hashCode();
        }

        @Override
        public String toString() {
            return "Optional.of(" + this.reference + ")";
        }
    }
}

