/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.base;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import javax.annotation.h;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@h String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    @h
    public static String emptyToNull(@h String string) {
        if (Strings.isNullOrEmpty(string)) {
            return null;
        }
        return string;
    }

    public static boolean isNullOrEmpty(@h String string) {
        return string == null || string.length() == 0;
    }

    public static String padStart(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        for (int i2 = string.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        sb.append(string);
        return sb.toString();
    }

    public static String padEnd(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb = new StringBuilder(minLength);
        sb.append(string);
        for (int i2 = string.length(); i2 < minLength; ++i2) {
            sb.append(padChar);
        }
        return sb.toString();
    }

    public static String repeat(String string, int count) {
        Preconditions.checkNotNull(string);
        Preconditions.checkArgument(count >= 0, "invalid count: %s", count);
        StringBuilder builder = new StringBuilder(string.length() * count);
        for (int i2 = 0; i2 < count; ++i2) {
            builder.append(string);
        }
        return builder.toString();
    }
}

