/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.cache;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.cache.Cache;
import com.timevale.guava.common.cache.CacheStats;
import com.timevale.guava.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;

@Beta
public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    protected AbstractCache() {
    }

    @Override
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e2) {
            throw new UncheckedExecutionException(e2.getCause());
        }
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidate(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void invalidateAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CacheStats stats() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    @Beta
    public static class SimpleStatsCounter
    implements StatsCounter {
        private final AtomicLong hitCount = new AtomicLong();
        private final AtomicLong missCount = new AtomicLong();
        private final AtomicLong loadSuccessCount = new AtomicLong();
        private final AtomicLong loadExceptionCount = new AtomicLong();
        private final AtomicLong totalLoadTime = new AtomicLong();
        private final AtomicLong evictionCount = new AtomicLong();

        @Override
        public void recordHit() {
            this.hitCount.incrementAndGet();
        }

        @Override
        public void recordLoadSuccess(long loadTime) {
            this.missCount.incrementAndGet();
            this.loadSuccessCount.incrementAndGet();
            this.totalLoadTime.addAndGet(loadTime);
        }

        @Override
        public void recordLoadException(long loadTime) {
            this.missCount.incrementAndGet();
            this.loadExceptionCount.incrementAndGet();
            this.totalLoadTime.addAndGet(loadTime);
        }

        @Override
        public void recordConcurrentMiss() {
            this.missCount.incrementAndGet();
        }

        @Override
        public void recordEviction() {
            this.evictionCount.incrementAndGet();
        }

        @Override
        public CacheStats snapshot() {
            return new CacheStats(this.hitCount.get(), this.missCount.get(), this.loadSuccessCount.get(), this.loadExceptionCount.get(), this.totalLoadTime.get(), this.evictionCount.get());
        }

        public void incrementBy(StatsCounter other) {
            CacheStats otherStats = other.snapshot();
            this.hitCount.addAndGet(otherStats.hitCount());
            this.missCount.addAndGet(otherStats.missCount());
            this.loadSuccessCount.addAndGet(otherStats.loadSuccessCount());
            this.loadExceptionCount.addAndGet(otherStats.loadExceptionCount());
            this.totalLoadTime.addAndGet(otherStats.totalLoadTime());
            this.evictionCount.addAndGet(otherStats.evictionCount());
        }
    }

    @Beta
    public static interface StatsCounter {
        public void recordHit();

        public void recordLoadSuccess(long var1);

        public void recordLoadException(long var1);

        public void recordConcurrentMiss();

        public void recordEviction();

        public CacheStats snapshot();
    }
}

