/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.cache;

import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.base.Supplier;
import com.timevale.guava.common.cache.AbstractCache;
import com.timevale.guava.common.cache.CacheBuilder;
import com.timevale.guava.common.cache.CacheLoader;
import com.timevale.guava.common.cache.CacheStats;
import com.timevale.guava.common.cache.CustomConcurrentHashMap;
import java.io.Serializable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;

class ComputingCache<K, V>
extends AbstractCache<K, V>
implements Serializable {
    final CustomConcurrentHashMap<K, V> map;
    private static final long serialVersionUID = 1L;

    ComputingCache(CacheBuilder<? super K, ? super V> builder, Supplier<? extends AbstractCache.StatsCounter> statsCounterSupplier, CacheLoader<? super K, V> loader) {
        this.map = new CustomConcurrentHashMap<K, V>(builder, statsCounterSupplier, loader);
    }

    @Override
    public V get(K key) throws ExecutionException {
        return this.map.getOrCompute(key);
    }

    @Override
    public void invalidate(Object key) {
        Preconditions.checkNotNull(key);
        this.map.remove(key);
    }

    @Override
    public void invalidateAll() {
        this.map.clear();
    }

    @Override
    public long size() {
        return this.map.longSize();
    }

    @Override
    public ConcurrentMap<K, V> asMap() {
        return this.map;
    }

    @Override
    public CacheStats stats() {
        AbstractCache.SimpleStatsCounter aggregator = new AbstractCache.SimpleStatsCounter();
        CustomConcurrentHashMap.Segment<K, V>[] arr$ = this.map.segments;
        int len$ = this.map.segments.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CustomConcurrentHashMap.Segment segment = arr$[i$];
            aggregator.incrementBy(segment.statsCounter);
        }
        return aggregator.snapshot();
    }

    @Override
    public void cleanUp() {
        this.map.cleanUp();
    }

    Object writeReplace() {
        return this.map.cacheSerializationProxy();
    }
}

