/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.cache;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.base.Objects;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.cache.RemovalCause;
import java.util.Map;
import javax.annotation.h;

@Beta
public final class RemovalNotification<K, V>
implements Map.Entry<K, V> {
    @h
    private final K key;
    @h
    private final V value;
    private final RemovalCause cause;
    private static final long serialVersionUID = 0L;

    RemovalNotification(@h K key, @h V value, RemovalCause cause) {
        this.key = key;
        this.value = value;
        this.cause = Preconditions.checkNotNull(cause);
    }

    public RemovalCause getCause() {
        return this.cause;
    }

    public boolean wasEvicted() {
        return this.cause.wasEvicted();
    }

    @Override
    @h
    public K getKey() {
        return this.key;
    }

    @Override
    @h
    public V getValue() {
        return this.value;
    }

    @Override
    public final V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(@h Object object) {
        if (object instanceof Map.Entry) {
            Map.Entry that = (Map.Entry)object;
            return Objects.equal(this.getKey(), that.getKey()) && Objects.equal(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        K k2 = this.getKey();
        V v2 = this.getValue();
        return (k2 == null ? 0 : k2.hashCode()) ^ (v2 == null ? 0 : v2.hashCode());
    }

    public String toString() {
        return this.getKey() + "=" + this.getValue();
    }
}

