/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.BstNode;
import javax.annotation.h;

@GwtCompatible
final class BstModificationResult<N extends BstNode<?, N>> {
    @h
    private final N originalTarget;
    @h
    private final N changedTarget;
    private final ModificationType type;

    static <N extends BstNode<?, N>> BstModificationResult<N> identity(@h N target) {
        return new BstModificationResult<N>(target, target, ModificationType.IDENTITY);
    }

    static <N extends BstNode<?, N>> BstModificationResult<N> rebuildingChange(@h N originalTarget, @h N changedTarget) {
        return new BstModificationResult<N>(originalTarget, changedTarget, ModificationType.REBUILDING_CHANGE);
    }

    static <N extends BstNode<?, N>> BstModificationResult<N> rebalancingChange(@h N originalTarget, @h N changedTarget) {
        return new BstModificationResult<N>(originalTarget, changedTarget, ModificationType.REBALANCING_CHANGE);
    }

    private BstModificationResult(@h N originalTarget, @h N changedTarget, ModificationType type) {
        this.originalTarget = originalTarget;
        this.changedTarget = changedTarget;
        this.type = Preconditions.checkNotNull(type);
    }

    @h
    N getOriginalTarget() {
        return this.originalTarget;
    }

    @h
    N getChangedTarget() {
        return this.changedTarget;
    }

    ModificationType getType() {
        return this.type;
    }

    static enum ModificationType {
        IDENTITY,
        REBUILDING_CHANGE,
        REBALANCING_CHANGE;

    }
}

