/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.BstBalancePolicy;
import com.timevale.guava.common.collect.BstModificationResult;
import com.timevale.guava.common.collect.BstNode;
import com.timevale.guava.common.collect.BstNodeFactory;
import com.timevale.guava.common.collect.BstSide;
import javax.annotation.h;

@GwtCompatible
final class BstMutationResult<K, N extends BstNode<K, N>> {
    private final K targetKey;
    @h
    private N originalRoot;
    @h
    private N changedRoot;
    private final BstModificationResult<N> modificationResult;

    public static <K, N extends BstNode<K, N>> BstMutationResult<K, N> mutationResult(K targetKey, @h N originalRoot, @h N changedRoot, BstModificationResult<N> modificationResult) {
        return new BstMutationResult<K, N>(targetKey, originalRoot, changedRoot, modificationResult);
    }

    private BstMutationResult(K targetKey, @h N originalRoot, @h N changedRoot, BstModificationResult<N> modificationResult) {
        this.targetKey = Preconditions.checkNotNull(targetKey);
        this.originalRoot = originalRoot;
        this.changedRoot = changedRoot;
        this.modificationResult = Preconditions.checkNotNull(modificationResult);
    }

    public K getTargetKey() {
        return this.targetKey;
    }

    @h
    public N getOriginalRoot() {
        return this.originalRoot;
    }

    @h
    public N getChangedRoot() {
        return this.changedRoot;
    }

    @h
    public N getOriginalTarget() {
        return this.modificationResult.getOriginalTarget();
    }

    @h
    public N getChangedTarget() {
        return this.modificationResult.getChangedTarget();
    }

    BstModificationResult.ModificationType modificationType() {
        return this.modificationResult.getType();
    }

    public BstMutationResult<K, N> lift(N liftOriginalRoot, BstSide side, BstNodeFactory<N> nodeFactory, BstBalancePolicy<N> balancePolicy) {
        assert (liftOriginalRoot != null & side != null & nodeFactory != null & balancePolicy != null);
        switch (this.modificationType()) {
            case IDENTITY: {
                this.changedRoot = liftOriginalRoot;
                this.originalRoot = this.changedRoot;
                return this;
            }
            case REBUILDING_CHANGE: 
            case REBALANCING_CHANGE: {
                this.originalRoot = liftOriginalRoot;
                Object resultLeft = ((BstNode)liftOriginalRoot).childOrNull(BstSide.LEFT);
                Object resultRight = ((BstNode)liftOriginalRoot).childOrNull(BstSide.RIGHT);
                switch (side) {
                    case LEFT: {
                        resultLeft = this.changedRoot;
                        break;
                    }
                    case RIGHT: {
                        resultRight = this.changedRoot;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.changedRoot = this.modificationType() == BstModificationResult.ModificationType.REBUILDING_CHANGE ? nodeFactory.createNode(liftOriginalRoot, resultLeft, resultRight) : balancePolicy.balance(nodeFactory, liftOriginalRoot, resultLeft, resultRight);
                return this;
            }
        }
        throw new AssertionError();
    }
}

