/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.BstSide;
import java.util.Comparator;
import javax.annotation.h;

@GwtCompatible
class BstNode<K, N extends BstNode<K, N>> {
    private final K key;
    @h
    private final N left;
    @h
    private final N right;

    BstNode(K key, @h N left, @h N right) {
        this.key = Preconditions.checkNotNull(key);
        this.left = left;
        this.right = right;
    }

    public final K getKey() {
        return this.key;
    }

    @h
    public final N childOrNull(BstSide side) {
        switch (side) {
            case LEFT: {
                return this.left;
            }
            case RIGHT: {
                return this.right;
            }
        }
        throw new AssertionError();
    }

    public final boolean hasChild(BstSide side) {
        return this.childOrNull(side) != null;
    }

    public final N getChild(BstSide side) {
        N child = this.childOrNull(side);
        Preconditions.checkState(child != null);
        return child;
    }

    protected final boolean orderingInvariantHolds(Comparator<? super K> comparator) {
        Preconditions.checkNotNull(comparator);
        boolean result = true;
        if (this.hasChild(BstSide.LEFT)) {
            result = true & comparator.compare(((BstNode)this.getChild(BstSide.LEFT)).getKey(), this.key) < 0;
        }
        if (this.hasChild(BstSide.RIGHT)) {
            result &= comparator.compare(((BstNode)this.getChild(BstSide.RIGHT)).getKey(), this.key) > 0;
        }
        return result;
    }
}

