/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.base.Supplier;
import com.timevale.guava.common.collect.Maps;
import com.timevale.guava.common.collect.StandardTable;
import com.timevale.guava.common.collect.Table;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.h;

@GwtCompatible(serializable=true)
@Beta
public class HashBasedTable<R, C, V>
extends StandardTable<R, C, V> {
    private static final long serialVersionUID = 0L;

    public static <R, C, V> HashBasedTable<R, C, V> create() {
        return new HashBasedTable(new HashMap(), new Factory(0));
    }

    public static <R, C, V> HashBasedTable<R, C, V> create(int expectedRows, int expectedCellsPerRow) {
        Preconditions.checkArgument(expectedCellsPerRow >= 0);
        HashMap backingMap = Maps.newHashMapWithExpectedSize(expectedRows);
        return new HashBasedTable(backingMap, new Factory(expectedCellsPerRow));
    }

    public static <R, C, V> HashBasedTable<R, C, V> create(Table<? extends R, ? extends C, ? extends V> table) {
        HashBasedTable<R, C, V> result = HashBasedTable.create();
        result.putAll((Table)table);
        return result;
    }

    HashBasedTable(Map<R, Map<C, V>> backingMap, Factory<C, V> factory) {
        super(backingMap, factory);
    }

    @Override
    public boolean contains(@h Object rowKey, @h Object columnKey) {
        return super.contains(rowKey, columnKey);
    }

    @Override
    public boolean containsColumn(@h Object columnKey) {
        return super.containsColumn(columnKey);
    }

    @Override
    public boolean containsRow(@h Object rowKey) {
        return super.containsRow(rowKey);
    }

    @Override
    public boolean containsValue(@h Object value) {
        return super.containsValue(value);
    }

    @Override
    public V get(@h Object rowKey, @h Object columnKey) {
        return super.get(rowKey, columnKey);
    }

    @Override
    public boolean equals(@h Object obj) {
        return super.equals(obj);
    }

    @Override
    public V remove(@h Object rowKey, @h Object columnKey) {
        return super.remove(rowKey, columnKey);
    }

    private static class Factory<C, V>
    implements Supplier<Map<C, V>>,
    Serializable {
        final int expectedSize;
        private static final long serialVersionUID = 0L;

        Factory(int expectedSize) {
            this.expectedSize = expectedSize;
        }

        @Override
        public Map<C, V> get() {
            return Maps.newHashMapWithExpectedSize(this.expectedSize);
        }
    }
}

