/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.ImmutableAsList;
import com.timevale.guava.common.collect.ImmutableList;
import com.timevale.guava.common.collect.ImmutableSortedSet;
import com.timevale.guava.common.collect.RegularImmutableSortedSet;
import com.timevale.guava.common.collect.SortedIterable;
import com.timevale.guava.common.collect.UnmodifiableIterator;
import com.timevale.guava.common.collect.UnmodifiableListIterator;
import java.util.Comparator;
import javax.annotation.h;

final class ImmutableSortedAsList<E>
extends ImmutableList<E>
implements SortedIterable<E> {
    private final transient ImmutableSortedSet<E> backingSet;
    private final transient ImmutableList<E> backingList;

    ImmutableSortedAsList(ImmutableSortedSet<E> backingSet, ImmutableList<E> backingList) {
        this.backingSet = backingSet;
        this.backingList = backingList;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.backingSet.comparator();
    }

    @Override
    public boolean contains(@h Object target) {
        return this.backingSet.indexOf(target) >= 0;
    }

    @Override
    public int indexOf(@h Object target) {
        return this.backingSet.indexOf(target);
    }

    @Override
    public int lastIndexOf(@h Object target) {
        return this.backingSet.indexOf(target);
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
        if (fromIndex == toIndex) {
            return ImmutableList.of();
        }
        return new RegularImmutableSortedSet<E>(this.backingList.subList(fromIndex, toIndex), this.backingSet.comparator()).asList();
    }

    @Override
    Object writeReplace() {
        return new ImmutableAsList.SerializedForm(this.backingSet);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.backingList.iterator();
    }

    @Override
    public E get(int index) {
        return this.backingList.get(index);
    }

    @Override
    public UnmodifiableListIterator<E> listIterator() {
        return this.backingList.listIterator();
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.backingList.listIterator(index);
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public boolean equals(@h Object obj) {
        return this.backingList.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.backingList.hashCode();
    }

    @Override
    boolean isPartialView() {
        return this.backingList.isPartialView();
    }
}

