/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.annotations.VisibleForTesting;
import com.timevale.guava.common.base.Function;
import com.timevale.guava.common.base.Objects;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.AbstractIndexedListIterator;
import com.timevale.guava.common.collect.Collections2;
import com.timevale.guava.common.collect.ImmutableList;
import com.timevale.guava.common.collect.Iterators;
import com.timevale.guava.common.collect.UnmodifiableListIterator;
import com.timevale.guava.common.primitives.Ints;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import javax.annotation.h;

@GwtCompatible
public final class Lists {
    private Lists() {
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        Preconditions.checkNotNull(elements);
        int capacity = Lists.computeArrayListCapacity(elements.length);
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, elements);
        return list;
    }

    @VisibleForTesting
    static int computeArrayListCapacity(int arraySize) {
        Preconditions.checkArgument(arraySize >= 0);
        return Ints.saturatedCast(5L + (long)arraySize + (long)(arraySize / 10));
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        if (elements instanceof Collection) {
            return new ArrayList<E>(Collections2.cast(elements));
        }
        return Lists.newArrayList(elements.iterator());
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        Preconditions.checkNotNull(elements);
        ArrayList<E> list = Lists.newArrayList();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayListWithCapacity(int initialArraySize) {
        Preconditions.checkArgument(initialArraySize >= 0);
        return new ArrayList(initialArraySize);
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayListWithExpectedSize(int estimatedSize) {
        return new ArrayList(Lists.computeArrayListCapacity(estimatedSize));
    }

    @GwtCompatible(serializable=true)
    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    @GwtCompatible(serializable=true)
    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> elements) {
        LinkedList<E> list = Lists.newLinkedList();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <E> List<E> asList(@h E first, E[] rest) {
        return new OnePlusArrayList<E>(first, rest);
    }

    public static <E> List<E> asList(@h E first, @h E second, E[] rest) {
        return new TwoPlusArrayList<E>(first, second, rest);
    }

    public static <F, T> List<T> transform(List<F> fromList, Function<? super F, ? extends T> function) {
        if (fromList instanceof RandomAccess) {
            return new TransformingRandomAccessList<F, T>(fromList, function);
        }
        return new TransformingSequentialList<F, T>(fromList, function);
    }

    public static <T> List<List<T>> partition(List<T> list, int size) {
        Preconditions.checkNotNull(list);
        Preconditions.checkArgument(size > 0);
        if (list instanceof RandomAccess) {
            return new RandomAccessPartition<T>(list, size);
        }
        return new Partition<T>(list, size);
    }

    @Beta
    public static ImmutableList<Character> charactersOf(String string) {
        return new StringAsImmutableList(Preconditions.checkNotNull(string));
    }

    @Beta
    public static List<Character> charactersOf(CharSequence sequence) {
        return new CharSequenceAsList(Preconditions.checkNotNull(sequence));
    }

    public static <T> List<T> reverse(List<T> list) {
        if (list instanceof ReverseList) {
            return ((ReverseList)list).getForwardList();
        }
        if (list instanceof RandomAccess) {
            return new RandomAccessReverseList<T>(list);
        }
        return new ReverseList<T>(list);
    }

    static int hashCodeImpl(List<?> list) {
        int hashCode = 1;
        for (Object o2 : list) {
            hashCode = hashCode * 31 + (o2 == null ? 0 : o2.hashCode());
        }
        return hashCode;
    }

    static boolean equalsImpl(List<?> list, @h Object object) {
        if (object == Preconditions.checkNotNull(list)) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List o2 = (List)object;
        return list.size() == o2.size() && Iterators.elementsEqual(list.iterator(), o2.iterator());
    }

    static <E> boolean addAllImpl(List<E> list, int index, Iterable<? extends E> elements) {
        boolean changed = false;
        ListIterator<E> listIterator = list.listIterator(index);
        for (E e2 : elements) {
            listIterator.add(e2);
            changed = true;
        }
        return changed;
    }

    static int indexOfImpl(List<?> list, @h Object element) {
        ListIterator<?> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            if (!Objects.equal(element, listIterator.next())) continue;
            return listIterator.previousIndex();
        }
        return -1;
    }

    static int lastIndexOfImpl(List<?> list, @h Object element) {
        ListIterator<?> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            if (!Objects.equal(element, listIterator.previous())) continue;
            return listIterator.nextIndex();
        }
        return -1;
    }

    static <E> ListIterator<E> listIteratorImpl(List<E> list, int index) {
        return new AbstractListWrapper<E>(list).listIterator(index);
    }

    static <E> List<E> subListImpl(List<E> list, int fromIndex, int toIndex) {
        AbstractListWrapper wrapper = list instanceof RandomAccess ? new RandomAccessListWrapper<E>((List)list){
            private static final long serialVersionUID = 0L;

            @Override
            public ListIterator<E> listIterator(int index) {
                return this.backingList.listIterator(index);
            }
        } : new AbstractListWrapper<E>((List)list){
            private static final long serialVersionUID = 0L;

            @Override
            public ListIterator<E> listIterator(int index) {
                return this.backingList.listIterator(index);
            }
        };
        return wrapper.subList(fromIndex, toIndex);
    }

    private static class RandomAccessListWrapper<E>
    extends AbstractListWrapper<E>
    implements RandomAccess {
        RandomAccessListWrapper(List<E> backingList) {
            super(backingList);
        }
    }

    private static class AbstractListWrapper<E>
    extends AbstractList<E> {
        final List<E> backingList;

        AbstractListWrapper(List<E> backingList) {
            this.backingList = Preconditions.checkNotNull(backingList);
        }

        @Override
        public void add(int index, E element) {
            this.backingList.add(index, element);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c2) {
            return this.backingList.addAll(index, c2);
        }

        @Override
        public E get(int index) {
            return this.backingList.get(index);
        }

        @Override
        public E remove(int index) {
            return this.backingList.remove(index);
        }

        @Override
        public E set(int index, E element) {
            return this.backingList.set(index, element);
        }

        @Override
        public boolean contains(Object o2) {
            return this.backingList.contains(o2);
        }

        @Override
        public int size() {
            return this.backingList.size();
        }
    }

    private static class RandomAccessReverseList<T>
    extends ReverseList<T>
    implements RandomAccess {
        RandomAccessReverseList(List<T> forwardList) {
            super(forwardList);
        }
    }

    private static class ReverseList<T>
    extends AbstractList<T> {
        private final List<T> forwardList;

        ReverseList(List<T> forwardList) {
            this.forwardList = Preconditions.checkNotNull(forwardList);
        }

        List<T> getForwardList() {
            return this.forwardList;
        }

        private int reverseIndex(int index) {
            int size = this.size();
            Preconditions.checkElementIndex(index, size);
            return size - 1 - index;
        }

        private int reversePosition(int index) {
            int size = this.size();
            Preconditions.checkPositionIndex(index, size);
            return size - index;
        }

        @Override
        public void add(int index, @h T element) {
            this.forwardList.add(this.reversePosition(index), element);
        }

        @Override
        public void clear() {
            this.forwardList.clear();
        }

        @Override
        public T remove(int index) {
            return this.forwardList.remove(this.reverseIndex(index));
        }

        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            this.subList(fromIndex, toIndex).clear();
        }

        @Override
        public T set(int index, @h T element) {
            return this.forwardList.set(this.reverseIndex(index), element);
        }

        @Override
        public T get(int index) {
            return this.forwardList.get(this.reverseIndex(index));
        }

        @Override
        public boolean isEmpty() {
            return this.forwardList.isEmpty();
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        public boolean contains(@h Object o2) {
            return this.forwardList.contains(o2);
        }

        @Override
        public boolean containsAll(Collection<?> c2) {
            return this.forwardList.containsAll(c2);
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
            return Lists.reverse(this.forwardList.subList(this.reversePosition(toIndex), this.reversePosition(fromIndex)));
        }

        @Override
        public int indexOf(@h Object o2) {
            int index = this.forwardList.lastIndexOf(o2);
            if (index >= 0) {
                return this.reverseIndex(index);
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@h Object o2) {
            int index = this.forwardList.indexOf(o2);
            if (index >= 0) {
                return this.reverseIndex(index);
            }
            return -1;
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            int start = this.reversePosition(index);
            final ListIterator<T> forwardIterator = this.forwardList.listIterator(start);
            return new ListIterator<T>(){
                boolean canRemove;
                boolean canSet;

                @Override
                public void add(T e2) {
                    forwardIterator.add(e2);
                    forwardIterator.previous();
                    this.canRemove = false;
                    this.canSet = false;
                }

                @Override
                public boolean hasNext() {
                    return forwardIterator.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return forwardIterator.hasNext();
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemove = true;
                    this.canSet = true;
                    return forwardIterator.previous();
                }

                @Override
                public int nextIndex() {
                    return ReverseList.this.reversePosition(forwardIterator.nextIndex());
                }

                @Override
                public T previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemove = true;
                    this.canSet = true;
                    return forwardIterator.next();
                }

                @Override
                public int previousIndex() {
                    return this.nextIndex() - 1;
                }

                @Override
                public void remove() {
                    Preconditions.checkState(this.canRemove);
                    forwardIterator.remove();
                    this.canSet = false;
                    this.canRemove = false;
                }

                @Override
                public void set(T e2) {
                    Preconditions.checkState(this.canSet);
                    forwardIterator.set(e2);
                }
            };
        }
    }

    private static final class CharSequenceAsList
    extends AbstractList<Character> {
        private final CharSequence sequence;

        CharSequenceAsList(CharSequence sequence) {
            this.sequence = sequence;
        }

        @Override
        public Character get(int index) {
            return Character.valueOf(this.sequence.charAt(index));
        }

        @Override
        public boolean contains(@h Object o2) {
            return this.indexOf(o2) >= 0;
        }

        @Override
        public int indexOf(@h Object o2) {
            if (o2 instanceof Character) {
                char c2 = ((Character)o2).charValue();
                for (int i2 = 0; i2 < this.sequence.length(); ++i2) {
                    if (this.sequence.charAt(i2) != c2) continue;
                    return i2;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@h Object o2) {
            if (o2 instanceof Character) {
                char c2 = ((Character)o2).charValue();
                for (int i2 = this.sequence.length() - 1; i2 >= 0; --i2) {
                    if (this.sequence.charAt(i2) != c2) continue;
                    return i2;
                }
            }
            return -1;
        }

        @Override
        public int size() {
            return this.sequence.length();
        }

        @Override
        public List<Character> subList(int fromIndex, int toIndex) {
            return Lists.charactersOf(this.sequence.subSequence(fromIndex, toIndex));
        }

        @Override
        public int hashCode() {
            int hash = 1;
            for (int i2 = 0; i2 < this.sequence.length(); ++i2) {
                hash = hash * 31 + this.sequence.charAt(i2);
            }
            return hash;
        }

        @Override
        public boolean equals(@h Object o2) {
            if (!(o2 instanceof List)) {
                return false;
            }
            List list = (List)o2;
            int n2 = this.sequence.length();
            if (n2 != list.size()) {
                return false;
            }
            Iterator iterator = list.iterator();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object elem = iterator.next();
                if (elem instanceof Character && ((Character)elem).charValue() == this.sequence.charAt(i2)) continue;
                return false;
            }
            return true;
        }
    }

    private static final class StringAsImmutableList
    extends ImmutableList<Character> {
        private final String string;
        int hash = 0;

        StringAsImmutableList(String string) {
            this.string = string;
        }

        @Override
        public boolean contains(@h Object object) {
            return this.indexOf(object) >= 0;
        }

        @Override
        public int indexOf(@h Object object) {
            if (object instanceof Character) {
                return this.string.indexOf(((Character)object).charValue());
            }
            return -1;
        }

        @Override
        public int lastIndexOf(@h Object object) {
            if (object instanceof Character) {
                return this.string.lastIndexOf(((Character)object).charValue());
            }
            return -1;
        }

        @Override
        public UnmodifiableListIterator<Character> listIterator(int index) {
            return new AbstractIndexedListIterator<Character>(this.size(), index){

                @Override
                protected Character get(int index) {
                    return Character.valueOf(StringAsImmutableList.this.string.charAt(index));
                }
            };
        }

        @Override
        public ImmutableList<Character> subList(int fromIndex, int toIndex) {
            return Lists.charactersOf(this.string.substring(fromIndex, toIndex));
        }

        @Override
        boolean isPartialView() {
            return false;
        }

        @Override
        public Character get(int index) {
            return Character.valueOf(this.string.charAt(index));
        }

        @Override
        public int size() {
            return this.string.length();
        }

        @Override
        public boolean equals(@h Object obj) {
            if (!(obj instanceof List)) {
                return false;
            }
            List list = (List)obj;
            int n2 = this.string.length();
            if (n2 != list.size()) {
                return false;
            }
            Iterator iterator = list.iterator();
            for (int i2 = 0; i2 < n2; ++i2) {
                Object elem = iterator.next();
                if (elem instanceof Character && ((Character)elem).charValue() == this.string.charAt(i2)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int h2 = this.hash;
            if (h2 == 0) {
                h2 = 1;
                for (int i2 = 0; i2 < this.string.length(); ++i2) {
                    h2 = h2 * 31 + this.string.charAt(i2);
                }
                this.hash = h2;
            }
            return h2;
        }
    }

    private static class RandomAccessPartition<T>
    extends Partition<T>
    implements RandomAccess {
        RandomAccessPartition(List<T> list, int size) {
            super(list, size);
        }
    }

    private static class Partition<T>
    extends AbstractList<List<T>> {
        final List<T> list;
        final int size;

        Partition(List<T> list, int size) {
            this.list = list;
            this.size = size;
        }

        @Override
        public List<T> get(int index) {
            int listSize = this.size();
            Preconditions.checkElementIndex(index, listSize);
            int start = index * this.size;
            int end = Math.min(start + this.size, this.list.size());
            return this.list.subList(start, end);
        }

        @Override
        public int size() {
            int result = this.list.size() / this.size;
            if (result * this.size != this.list.size()) {
                ++result;
            }
            return result;
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    private static class TransformingRandomAccessList<F, T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        final List<F> fromList;
        final Function<? super F, ? extends T> function;
        private static final long serialVersionUID = 0L;

        TransformingRandomAccessList(List<F> fromList, Function<? super F, ? extends T> function) {
            this.fromList = Preconditions.checkNotNull(fromList);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public T get(int index) {
            return this.function.apply(this.fromList.get(index));
        }

        @Override
        public boolean isEmpty() {
            return this.fromList.isEmpty();
        }

        @Override
        public T remove(int index) {
            return this.function.apply(this.fromList.remove(index));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }
    }

    private static class TransformingSequentialList<F, T>
    extends AbstractSequentialList<T>
    implements Serializable {
        final List<F> fromList;
        final Function<? super F, ? extends T> function;
        private static final long serialVersionUID = 0L;

        TransformingSequentialList(List<F> fromList, Function<? super F, ? extends T> function) {
            this.fromList = Preconditions.checkNotNull(fromList);
            this.function = Preconditions.checkNotNull(function);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public int size() {
            return this.fromList.size();
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            final ListIterator<F> delegate = this.fromList.listIterator(index);
            return new ListIterator<T>(){

                @Override
                public void add(T e2) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return delegate.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return delegate.hasPrevious();
                }

                @Override
                public T next() {
                    return TransformingSequentialList.this.function.apply(delegate.next());
                }

                @Override
                public int nextIndex() {
                    return delegate.nextIndex();
                }

                @Override
                public T previous() {
                    return TransformingSequentialList.this.function.apply(delegate.previous());
                }

                @Override
                public int previousIndex() {
                    return delegate.previousIndex();
                }

                @Override
                public void remove() {
                    delegate.remove();
                }

                @Override
                public void set(T e2) {
                    throw new UnsupportedOperationException("not supported");
                }
            };
        }
    }

    private static class TwoPlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        final E first;
        final E second;
        final E[] rest;
        private static final long serialVersionUID = 0L;

        TwoPlusArrayList(@h E first, @h E second, E[] rest) {
            this.first = first;
            this.second = second;
            this.rest = Preconditions.checkNotNull(rest);
        }

        @Override
        public int size() {
            return this.rest.length + 2;
        }

        @Override
        public E get(int index) {
            switch (index) {
                case 0: {
                    return this.first;
                }
                case 1: {
                    return this.second;
                }
            }
            Preconditions.checkElementIndex(index, this.size());
            return this.rest[index - 2];
        }
    }

    private static class OnePlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        final E first;
        final E[] rest;
        private static final long serialVersionUID = 0L;

        OnePlusArrayList(@h E first, E[] rest) {
            this.first = first;
            this.rest = Preconditions.checkNotNull(rest);
        }

        @Override
        public int size() {
            return this.rest.length + 1;
        }

        @Override
        public E get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            if (index == 0) {
                return this.first;
            }
            return this.rest[index - 1];
        }
    }
}

