/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.annotations.GwtIncompatible;
import com.timevale.guava.common.collect.Platform;
import java.util.Collection;
import javax.annotation.h;

@GwtCompatible(emulated=true)
public final class ObjectArrays {
    private ObjectArrays() {
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] newArray(Class<T> type, int length) {
        return Platform.newArray(type, length);
    }

    public static <T> T[] newArray(T[] reference, int length) {
        return Platform.newArray(reference, length);
    }

    @GwtIncompatible(value="Array.newInstance(Class, int)")
    public static <T> T[] concat(T[] first, T[] second, Class<T> type) {
        Object[] result = ObjectArrays.newArray(type, first.length + second.length);
        Platform.unsafeArrayCopy(first, 0, result, 0, first.length);
        Platform.unsafeArrayCopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static <T> T[] concat(@h T element, T[] array) {
        Object[] objectArray = ObjectArrays.newArray(array, array.length + 1);
        Object[] result = objectArray;
        objectArray[0] = element;
        Platform.unsafeArrayCopy(array, 0, result, 1, array.length);
        return result;
    }

    public static <T> T[] concat(T[] array, @h T element) {
        T[] TArray = ObjectArrays.arraysCopyOf(array, array.length + 1);
        T[] result = TArray;
        TArray[array.length] = element;
        return result;
    }

    static <T> T[] arraysCopyOf(T[] original, int newLength) {
        Object[] copy = ObjectArrays.newArray(original, newLength);
        Platform.unsafeArrayCopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    static <T> T[] toArrayImpl(Collection<?> c2, T[] array) {
        int size = c2.size();
        if (array.length < size) {
            array = ObjectArrays.newArray(array, size);
        }
        ObjectArrays.fillArray(c2, array);
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    static Object[] toArrayImpl(Collection<?> c2) {
        return ObjectArrays.fillArray(c2, new Object[c2.size()]);
    }

    private static Object[] fillArray(Iterable<?> elements, Object[] array) {
        int i2 = 0;
        for (Object element : elements) {
            array[i2++] = element;
        }
        return array;
    }

    static void swap(Object[] array, int i2, int j2) {
        Object temp = array[i2];
        array[i2] = array[j2];
        array[j2] = temp;
    }
}

