/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.AbstractIndexedListIterator;
import com.timevale.guava.common.collect.Collections2;
import com.timevale.guava.common.collect.Hashing;
import com.timevale.guava.common.collect.ImmutableCollection;
import com.timevale.guava.common.collect.ImmutableEntry;
import com.timevale.guava.common.collect.ImmutableMap;
import com.timevale.guava.common.collect.ImmutableSet;
import com.timevale.guava.common.collect.UnmodifiableIterator;
import java.util.Map;
import javax.annotation.concurrent.b;
import javax.annotation.h;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient LinkedEntry<K, V>[] entries;
    private final transient LinkedEntry<K, V>[] table;
    private final transient int mask;
    private final transient int keySetHashCode;
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;
    private static final long serialVersionUID = 0L;

    RegularImmutableMap(Map.Entry<?, ?> ... immutableEntries) {
        int size = immutableEntries.length;
        this.entries = this.createEntryArray(size);
        int tableSize = RegularImmutableMap.chooseTableSize(size);
        this.table = this.createEntryArray(tableSize);
        this.mask = tableSize - 1;
        int keySetHashCodeMutable = 0;
        for (int entryIndex = 0; entryIndex < size; ++entryIndex) {
            LinkedEntry<K, V> existing;
            Map.Entry<?, ?> entry = immutableEntries[entryIndex];
            Object key = entry.getKey();
            int keyHashCode = key.hashCode();
            keySetHashCodeMutable += keyHashCode;
            int tableIndex = Hashing.smear(keyHashCode) & this.mask;
            LinkedEntry<?, ?> linkedEntry = RegularImmutableMap.newLinkedEntry(key, entry.getValue(), existing);
            this.table[tableIndex] = linkedEntry;
            this.entries[entryIndex] = linkedEntry;
            for (existing = this.table[tableIndex]; existing != null; existing = existing.next()) {
                Preconditions.checkArgument(!key.equals(existing.getKey()), "duplicate key: %s", key);
            }
        }
        this.keySetHashCode = keySetHashCodeMutable;
    }

    private static int chooseTableSize(int size) {
        int tableSize = Integer.highestOneBit(size) << 1;
        Preconditions.checkArgument(tableSize > 0, "table too large: %s", size);
        return tableSize;
    }

    private LinkedEntry<K, V>[] createEntryArray(int size) {
        return new LinkedEntry[size];
    }

    private static <K, V> LinkedEntry<K, V> newLinkedEntry(K key, V value, @h LinkedEntry<K, V> next) {
        if (next == null) {
            return new TerminalEntry<K, V>(key, value);
        }
        return new NonTerminalEntry<K, V>(key, value, next);
    }

    @Override
    public V get(@h Object key) {
        if (key == null) {
            return null;
        }
        int index = Hashing.smear(key.hashCode()) & this.mask;
        for (LinkedEntry<K, V> entry = this.table[index]; entry != null; entry = entry.next()) {
            Object candidateKey = entry.getKey();
            if (!key.equals(candidateKey)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.length;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsValue(@h Object value) {
        if (value == null) {
            return false;
        }
        LinkedEntry<K, V>[] arr$ = this.entries;
        int len$ = this.entries.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            LinkedEntry<K, V> entry = arr$[i$];
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> es = this.entrySet;
        if (es == null) {
            this.entrySet = new EntrySet(this);
            return this.entrySet;
        }
        return es;
    }

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> ks = this.keySet;
        if (ks == null) {
            this.keySet = new KeySet(this);
            return this.keySet;
        }
        return ks;
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> v2 = this.values;
        if (v2 == null) {
            this.values = new Values(this);
            return this.values;
        }
        return v2;
    }

    @Override
    public String toString() {
        StringBuilder result = Collections2.newStringBuilderForCollection(this.size()).append('{');
        Collections2.STANDARD_JOINER.appendTo(result, (Object[])this.entries);
        return result.append('}').toString();
    }

    private static class Values<V>
    extends ImmutableCollection<V> {
        final RegularImmutableMap<?, V> map;

        Values(RegularImmutableMap<?, V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return ((RegularImmutableMap)this.map).entries.length;
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            return new AbstractIndexedListIterator<V>(((RegularImmutableMap)this.map).entries.length){

                @Override
                protected V get(int index) {
                    return Values.this.map.entries[index].getValue();
                }
            };
        }

        @Override
        public boolean contains(Object target) {
            return this.map.containsValue(target);
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    private static class KeySet<K, V>
    extends ImmutableSet.TransformedImmutableSet<Map.Entry<K, V>, K> {
        final RegularImmutableMap<K, V> map;

        KeySet(RegularImmutableMap<K, V> map) {
            super(((RegularImmutableMap)map).entries, ((RegularImmutableMap)map).keySetHashCode);
            this.map = map;
        }

        @Override
        K transform(Map.Entry<K, V> element) {
            return element.getKey();
        }

        @Override
        public boolean contains(Object target) {
            return this.map.containsKey(target);
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    private static class EntrySet<K, V>
    extends ImmutableSet.ArrayImmutableSet<Map.Entry<K, V>> {
        final transient RegularImmutableMap<K, V> map;

        EntrySet(RegularImmutableMap<K, V> map) {
            super(((RegularImmutableMap)map).entries);
            this.map = map;
        }

        @Override
        public boolean contains(Object target) {
            if (target instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)target;
                V mappedValue = this.map.get(entry.getKey());
                return mappedValue != null && mappedValue.equals(entry.getValue());
            }
            return false;
        }
    }

    @b
    private static final class TerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        TerminalEntry(K key, V value) {
            super(key, value);
        }

        @Override
        @h
        public LinkedEntry<K, V> next() {
            return null;
        }
    }

    @b
    private static final class NonTerminalEntry<K, V>
    extends ImmutableEntry<K, V>
    implements LinkedEntry<K, V> {
        final LinkedEntry<K, V> next;

        NonTerminalEntry(K key, V value, LinkedEntry<K, V> next) {
            super(key, value);
            this.next = next;
        }

        @Override
        public LinkedEntry<K, V> next() {
            return this.next;
        }
    }

    private static interface LinkedEntry<K, V>
    extends Map.Entry<K, V> {
        @h
        public LinkedEntry<K, V> next();
    }
}

