/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.collect.ImmutableMap;
import com.timevale.guava.common.collect.ImmutableMultiset;
import com.timevale.guava.common.collect.ImmutableSet;
import com.timevale.guava.common.collect.Multiset;
import com.timevale.guava.common.collect.Multisets;
import com.timevale.guava.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.h;

@GwtCompatible(serializable=true)
class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final transient ImmutableMap<E, Integer> map;
    private final transient int size;

    RegularImmutableMultiset(ImmutableMap<E, Integer> map, int size) {
        this.map = map;
        this.size = size;
    }

    @Override
    boolean isPartialView() {
        return this.map.isPartialView();
    }

    @Override
    public int count(@h Object element) {
        Integer value = this.map.get(element);
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(@h Object element) {
        return this.map.containsKey(element);
    }

    @Override
    public ImmutableSet<E> elementSet() {
        return this.map.keySet();
    }

    @Override
    UnmodifiableIterator<Multiset.Entry<E>> entryIterator() {
        final Iterator mapIterator = ((ImmutableSet)this.map.entrySet()).iterator();
        return new UnmodifiableIterator<Multiset.Entry<E>>(){

            @Override
            public boolean hasNext() {
                return mapIterator.hasNext();
            }

            @Override
            public Multiset.Entry<E> next() {
                Map.Entry mapEntry = (Map.Entry)mapIterator.next();
                return Multisets.immutableEntry(mapEntry.getKey(), (Integer)mapEntry.getValue());
            }
        };
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    int distinctElements() {
        return this.map.size();
    }
}

