/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.collect.ImmutableCollection;
import com.timevale.guava.common.collect.ImmutableMap;
import com.timevale.guava.common.collect.ImmutableSet;
import com.timevale.guava.common.collect.Iterators;
import com.timevale.guava.common.collect.Maps;
import com.timevale.guava.common.collect.UnmodifiableIterator;
import java.util.Map;
import javax.annotation.h;

@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableMap<K, V>
extends ImmutableMap<K, V> {
    final transient K singleKey;
    final transient V singleValue;
    private transient Map.Entry<K, V> entry;
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;

    SingletonImmutableMap(K singleKey, V singleValue) {
        this.singleKey = singleKey;
        this.singleValue = singleValue;
    }

    SingletonImmutableMap(Map.Entry<K, V> entry) {
        this.entry = entry;
        this.singleKey = entry.getKey();
        this.singleValue = entry.getValue();
    }

    private Map.Entry<K, V> entry() {
        Map.Entry<K, V> e2 = this.entry;
        if (e2 == null) {
            this.entry = Maps.immutableEntry(this.singleKey, this.singleValue);
            return this.entry;
        }
        return e2;
    }

    @Override
    public V get(@h Object key) {
        if (this.singleKey.equals(key)) {
            return this.singleValue;
        }
        return null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(@h Object key) {
        return this.singleKey.equals(key);
    }

    @Override
    public boolean containsValue(@h Object value) {
        return this.singleValue.equals(value);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        ImmutableSet<Map.Entry<K, V>> es = this.entrySet;
        if (es == null) {
            this.entrySet = ImmutableSet.of(this.entry());
            return this.entrySet;
        }
        return es;
    }

    @Override
    public ImmutableSet<K> keySet() {
        ImmutableSet<K> ks = this.keySet;
        if (ks == null) {
            this.keySet = ImmutableSet.of(this.singleKey);
            return this.keySet;
        }
        return ks;
    }

    @Override
    public ImmutableCollection<V> values() {
        ImmutableCollection<V> v2 = this.values;
        if (v2 == null) {
            this.values = new Values<V>(this.singleValue);
            return this.values;
        }
        return v2;
    }

    @Override
    public boolean equals(@h Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Map) {
            Map that = (Map)object;
            if (that.size() != 1) {
                return false;
            }
            Map.Entry entry = that.entrySet().iterator().next();
            return this.singleKey.equals(entry.getKey()) && this.singleValue.equals(entry.getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.singleKey.hashCode() ^ this.singleValue.hashCode();
    }

    @Override
    public String toString() {
        return "{" + this.singleKey.toString() + '=' + this.singleValue.toString() + '}';
    }

    private static class Values<V>
    extends ImmutableCollection<V> {
        final V singleValue;

        Values(V singleValue) {
            this.singleValue = singleValue;
        }

        @Override
        public boolean contains(Object object) {
            return this.singleValue.equals(object);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public UnmodifiableIterator<V> iterator() {
            return Iterators.singletonIterator(this.singleValue);
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }
}

