/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.AbstractLinkedIterator;
import com.timevale.guava.common.collect.AbstractSortedMultiset;
import com.timevale.guava.common.collect.BoundType;
import com.timevale.guava.common.collect.BstAggregate;
import com.timevale.guava.common.collect.BstCountBasedBalancePolicies;
import com.timevale.guava.common.collect.BstInOrderPath;
import com.timevale.guava.common.collect.BstModificationResult;
import com.timevale.guava.common.collect.BstModifier;
import com.timevale.guava.common.collect.BstMutationResult;
import com.timevale.guava.common.collect.BstMutationRule;
import com.timevale.guava.common.collect.BstNode;
import com.timevale.guava.common.collect.BstNodeFactory;
import com.timevale.guava.common.collect.BstOperations;
import com.timevale.guava.common.collect.BstPathFactory;
import com.timevale.guava.common.collect.BstRangeOps;
import com.timevale.guava.common.collect.BstSide;
import com.timevale.guava.common.collect.GeneralRange;
import com.timevale.guava.common.collect.Iterables;
import com.timevale.guava.common.collect.Multiset;
import com.timevale.guava.common.collect.Multisets;
import com.timevale.guava.common.collect.Ordering;
import com.timevale.guava.common.collect.SortedMultiset;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.h;

final class SortedTreeMultiset<E>
extends AbstractSortedMultiset<E> {
    private final GeneralRange<E> range;
    private final AtomicReference<Node> rootReference;
    private final transient BstPathFactory<Node, BstInOrderPath<Node>> pathFactory = BstInOrderPath.inOrderFactory();
    private final transient BstAggregate<Node> distinctAggregate = new BstAggregate<Node>(){

        @Override
        public int entryValue(Node entry) {
            return 1;
        }

        @Override
        public int treeValue(@h Node tree) {
            return SortedTreeMultiset.this.distinctOrZero(tree);
        }
    };
    private final transient BstAggregate<Node> sizeAggregate = new BstAggregate<Node>(){

        @Override
        public int entryValue(Node entry) {
            return entry.elemOccurrences;
        }

        @Override
        public int treeValue(@h Node tree) {
            return SortedTreeMultiset.this.sizeOrZero(tree);
        }
    };
    private final transient BstNodeFactory<Node> nodeFactory = new BstNodeFactory<Node>(){

        @Override
        public Node createNode(Node source, @h Node left, @h Node right) {
            return new Node(source.getKey(), source.elemOccurrences, left, right);
        }
    };

    public static <E extends Comparable> SortedTreeMultiset<E> create() {
        return new SortedTreeMultiset(Ordering.natural());
    }

    public static <E> SortedTreeMultiset<E> create(Comparator<? super E> comparator) {
        return new SortedTreeMultiset<E>(comparator);
    }

    public static <E extends Comparable> SortedTreeMultiset<E> create(Iterable<? extends E> elements) {
        SortedTreeMultiset<E> multiset = SortedTreeMultiset.create();
        Iterables.addAll(multiset, elements);
        return multiset;
    }

    private SortedTreeMultiset(Comparator<? super E> comparator) {
        super(comparator);
        this.range = GeneralRange.all(comparator);
        this.rootReference = new AtomicReference();
    }

    private SortedTreeMultiset(GeneralRange<E> range, AtomicReference<Node> root) {
        super(range.comparator());
        this.range = range;
        this.rootReference = root;
    }

    E checkElement(Object o2) {
        Preconditions.checkNotNull(o2);
        return (E)o2;
    }

    @Override
    int distinctElements() {
        Node root = this.rootReference.get();
        return BstRangeOps.totalInRange(this.distinctAggregate, this.range, root);
    }

    @Override
    public int size() {
        Node root = this.rootReference.get();
        return BstRangeOps.totalInRange(this.sizeAggregate, this.range, root);
    }

    @Override
    public int count(@h Object element) {
        if (element == null) {
            return 0;
        }
        try {
            E e2 = this.checkElement(element);
            if (this.range.contains(e2)) {
                Node node = (Node)BstOperations.seek(this.comparator(), (BstNode)this.rootReference.get(), e2);
                if (node == null) {
                    return 0;
                }
                return node.elemOccurrences;
            }
            return 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    private int mutate(E e2, MultisetModifier modifier) {
        BstMutationRule mutationRule = BstMutationRule.createRule(modifier, BstCountBasedBalancePolicies.singleRebalancePolicy(this.distinctAggregate), this.nodeFactory);
        BstMutationResult mutationResult = BstOperations.mutate(this.comparator(), mutationRule, (BstNode)this.rootReference.get(), e2);
        if (!this.rootReference.compareAndSet((Node)mutationResult.getOriginalRoot(), (Node)mutationResult.getChangedRoot())) {
            throw new ConcurrentModificationException();
        }
        Node original = (Node)mutationResult.getOriginalTarget();
        if (original == null) {
            return 0;
        }
        return original.elemOccurrences;
    }

    @Override
    public int add(E element, int occurrences) {
        Preconditions.checkNotNull(element);
        if (occurrences == 0) {
            return this.count(element);
        }
        Preconditions.checkArgument(this.range.contains(element));
        return this.mutate(element, new AddModifier(occurrences));
    }

    @Override
    public int remove(@h Object element, int occurrences) {
        if (element == null) {
            return 0;
        }
        if (occurrences == 0) {
            return this.count(element);
        }
        try {
            E e2 = this.checkElement(element);
            if (this.range.contains(e2)) {
                return this.mutate(e2, new RemoveModifier(occurrences));
            }
            return 0;
        }
        catch (ClassCastException classCastException) {
            return 0;
        }
    }

    @Override
    public boolean setCount(E element, int oldCount, int newCount) {
        Preconditions.checkNotNull(element);
        Preconditions.checkArgument(this.range.contains(element));
        return this.mutate(element, new ConditionalSetCountModifier(oldCount, newCount)) == oldCount;
    }

    @Override
    public int setCount(E element, int count) {
        Preconditions.checkNotNull(element);
        Preconditions.checkArgument(this.range.contains(element));
        return this.mutate(element, new SetCountModifier(count));
    }

    @Override
    Iterator<Multiset.Entry<E>> entryIterator() {
        Node root = this.rootReference.get();
        BstInOrderPath startingPath = (BstInOrderPath)((Object)BstRangeOps.furthestPath(this.range, BstSide.LEFT, this.pathFactory, root));
        return this.iteratorInDirection(startingPath, BstSide.RIGHT);
    }

    @Override
    Iterator<Multiset.Entry<E>> descendingEntryIterator() {
        Node root = this.rootReference.get();
        BstInOrderPath startingPath = (BstInOrderPath)((Object)BstRangeOps.furthestPath(this.range, BstSide.RIGHT, this.pathFactory, root));
        return this.iteratorInDirection(startingPath, BstSide.LEFT);
    }

    private Iterator<Multiset.Entry<E>> iteratorInDirection(@h BstInOrderPath<Node> start, final BstSide direction) {
        final AbstractLinkedIterator<BstInOrderPath<Node>> pathIterator = new AbstractLinkedIterator<BstInOrderPath<Node>>(start){

            @Override
            protected BstInOrderPath<Node> computeNext(BstInOrderPath<Node> previous) {
                if (!previous.hasNext(direction)) {
                    return null;
                }
                BstInOrderPath<Node> next = previous.next(direction);
                if (SortedTreeMultiset.this.range.contains(((Node)next.getTip()).getKey())) {
                    return next;
                }
                return null;
            }
        };
        return new Iterator<Multiset.Entry<E>>(){
            E toRemove = null;

            @Override
            public boolean hasNext() {
                return pathIterator.hasNext();
            }

            @Override
            public Multiset.Entry<E> next() {
                BstInOrderPath path = (BstInOrderPath)pathIterator.next();
                this.toRemove = ((Node)path.getTip()).getKey();
                return Multisets.immutableEntry(this.toRemove, ((Node)path.getTip()).elemOccurrences);
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.toRemove != null);
                SortedTreeMultiset.this.setCount(this.toRemove, 0);
                this.toRemove = null;
            }
        };
    }

    @Override
    public void clear() {
        Node cleared;
        Node root = this.rootReference.get();
        if (!this.rootReference.compareAndSet(root, cleared = BstRangeOps.minusRange(this.range, BstCountBasedBalancePolicies.fullRebalancePolicy(this.distinctAggregate), this.nodeFactory, root))) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public SortedMultiset<E> headMultiset(E upperBound, BoundType boundType) {
        Preconditions.checkNotNull(upperBound);
        return new SortedTreeMultiset<E>(this.range.intersect(GeneralRange.upTo(this.comparator, upperBound, boundType)), this.rootReference);
    }

    @Override
    public SortedMultiset<E> tailMultiset(E lowerBound, BoundType boundType) {
        Preconditions.checkNotNull(lowerBound);
        return new SortedTreeMultiset<E>(this.range.intersect(GeneralRange.downTo(this.comparator, lowerBound, boundType)), this.rootReference);
    }

    private int sizeOrZero(@h Node node) {
        if (node == null) {
            return 0;
        }
        return node.size;
    }

    private int distinctOrZero(@h Node node) {
        if (node == null) {
            return 0;
        }
        return node.distinct;
    }

    private final class ConditionalSetCountModifier
    extends MultisetModifier {
        private final int expectedCount;
        private final int setCount;

        private ConditionalSetCountModifier(int expectedCount, int setCount) {
            Preconditions.checkArgument(setCount >= 0 & expectedCount >= 0);
            this.expectedCount = expectedCount;
            this.setCount = setCount;
        }

        @Override
        int newCount(int oldCount) {
            if (oldCount == this.expectedCount) {
                return this.setCount;
            }
            return oldCount;
        }
    }

    private final class SetCountModifier
    extends MultisetModifier {
        private final int countToSet;

        private SetCountModifier(int countToSet) {
            Preconditions.checkArgument(countToSet >= 0);
            this.countToSet = countToSet;
        }

        @Override
        int newCount(int oldCount) {
            return this.countToSet;
        }
    }

    private final class RemoveModifier
    extends MultisetModifier {
        private final int countToRemove;

        private RemoveModifier(int countToRemove) {
            Preconditions.checkArgument(countToRemove > 0);
            this.countToRemove = countToRemove;
        }

        @Override
        int newCount(int oldCount) {
            return Math.max(0, oldCount - this.countToRemove);
        }
    }

    private final class AddModifier
    extends MultisetModifier {
        private final int countToAdd;

        private AddModifier(int countToAdd) {
            Preconditions.checkArgument(countToAdd > 0);
            this.countToAdd = countToAdd;
        }

        @Override
        int newCount(int oldCount) {
            return oldCount + this.countToAdd;
        }
    }

    private abstract class MultisetModifier
    implements BstModifier<E, Node> {
        private MultisetModifier() {
        }

        abstract int newCount(int var1);

        @Override
        @h
        public BstModificationResult<Node> modify(E key, @h Node originalEntry) {
            int newCount;
            int oldCount = originalEntry == null ? 0 : originalEntry.elemOccurrences;
            if (oldCount == (newCount = this.newCount(oldCount))) {
                return BstModificationResult.identity(originalEntry);
            }
            if (newCount == 0) {
                return BstModificationResult.rebalancingChange(originalEntry, null);
            }
            if (oldCount == 0) {
                return BstModificationResult.rebalancingChange(null, new Node(key, newCount));
            }
            return BstModificationResult.rebuildingChange(originalEntry, new Node(key, newCount));
        }
    }

    private final class Node
    extends BstNode<E, Node> {
        private final int elemOccurrences;
        private final int size;
        private final int distinct;

        private Node(E key, int elemCount, @h Node left, @h Node right) {
            super(SortedTreeMultiset.this.checkElement(key), left, right);
            Preconditions.checkArgument(elemCount > 0);
            this.elemOccurrences = elemCount;
            this.size = elemCount + SortedTreeMultiset.this.sizeOrZero(left) + SortedTreeMultiset.this.sizeOrZero(right);
            this.distinct = 1 + SortedTreeMultiset.this.distinctOrZero(left) + SortedTreeMultiset.this.distinctOrZero(right);
        }

        private Node(E key, int elemCount) {
            this(key, elemCount, null, null);
        }
    }
}

