/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.collect;

import com.timevale.guava.common.annotations.GwtCompatible;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.collect.AbstractIndexedListIterator;
import com.timevale.guava.common.collect.ImmutableList;
import com.timevale.guava.common.collect.Iterators;
import com.timevale.guava.common.collect.ObjectArrays;
import com.timevale.guava.common.collect.UnmodifiableListIterator;
import java.util.List;
import javax.annotation.h;

@GwtCompatible
abstract class TransformedImmutableList<D, E>
extends ImmutableList<E> {
    private final transient ImmutableList<D> backingList;

    TransformedImmutableList(ImmutableList<D> backingList) {
        this.backingList = Preconditions.checkNotNull(backingList);
    }

    abstract E transform(D var1);

    @Override
    public int indexOf(@h Object object) {
        if (object == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (!this.get(i2).equals(object)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(@h Object object) {
        if (object == null) {
            return -1;
        }
        for (int i2 = this.size() - 1; i2 >= 0; --i2) {
            if (!this.get(i2).equals(object)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public E get(int index) {
        return this.transform(this.backingList.get(index));
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return new AbstractIndexedListIterator<E>(this.size(), index){

            @Override
            protected E get(int index) {
                return TransformedImmutableList.this.get(index);
            }
        };
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        return new TransformedView(this.backingList.subList(fromIndex, toIndex));
    }

    @Override
    public boolean equals(@h Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return this.size() == list.size() && Iterators.elementsEqual(this.iterator(), list.iterator());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object e2 : this) {
            hashCode = hashCode * 31 + (e2 == null ? 0 : e2.hashCode());
        }
        return hashCode;
    }

    @Override
    public Object[] toArray() {
        return ObjectArrays.toArrayImpl(this);
    }

    @Override
    public <T> T[] toArray(T[] array) {
        return ObjectArrays.toArrayImpl(this, array);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    private class TransformedView
    extends TransformedImmutableList<D, E> {
        TransformedView(ImmutableList<D> backingList) {
            super(backingList);
        }

        @Override
        E transform(D d2) {
            return TransformedImmutableList.this.transform(d2);
        }
    }
}

