/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.io;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.io.ByteArrayDataInput;
import com.timevale.guava.common.io.ByteArrayDataOutput;
import com.timevale.guava.common.io.ByteProcessor;
import com.timevale.guava.common.io.Closeables;
import com.timevale.guava.common.io.InputSupplier;
import com.timevale.guava.common.io.LimitInputStream;
import com.timevale.guava.common.io.MultiInputStream;
import com.timevale.guava.common.io.OutputSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.zip.Checksum;

@Beta
public final class ByteStreams {
    private static final int BUF_SIZE = 4096;

    private ByteStreams() {
    }

    public static InputSupplier<ByteArrayInputStream> newInputStreamSupplier(byte[] b2) {
        return ByteStreams.newInputStreamSupplier(b2, 0, b2.length);
    }

    public static InputSupplier<ByteArrayInputStream> newInputStreamSupplier(final byte[] b2, final int off, final int len) {
        return new InputSupplier<ByteArrayInputStream>(){

            @Override
            public ByteArrayInputStream getInput() {
                return new ByteArrayInputStream(b2, off, len);
            }
        };
    }

    public static void write(byte[] from, OutputSupplier<? extends OutputStream> to) throws IOException {
        Preconditions.checkNotNull(from);
        OutputStream out = to.getOutput();
        try {
            out.write(from);
        }
        catch (Throwable throwable) {
            Closeables.close(out, true);
            throw throwable;
        }
        Closeables.close(out, false);
    }

    /*
     * Loose catch block
     */
    public static long copy(InputSupplier<? extends InputStream> from, OutputSupplier<? extends OutputStream> to) throws IOException {
        boolean threw = true;
        InputStream in = from.getInput();
        OutputStream out = to.getOutput();
        long count = ByteStreams.copy(in, out);
        threw = false;
        Closeables.close(out, false);
        Closeables.close(in, false);
        return count;
        {
            catch (Throwable throwable) {
                try {
                    Closeables.close(out, threw);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Closeables.close(in, threw);
                    throw throwable2;
                }
            }
        }
    }

    public static long copy(InputSupplier<? extends InputStream> from, OutputStream to) throws IOException {
        long count;
        boolean threw = true;
        InputStream in = from.getInput();
        try {
            count = ByteStreams.copy(in, to);
            threw = false;
        }
        catch (Throwable throwable) {
            Closeables.close(in, threw);
            throw throwable;
        }
        Closeables.close(in, false);
        return count;
    }

    public static long copy(InputStream from, OutputSupplier<? extends OutputStream> to) throws IOException {
        long count;
        boolean threw = true;
        OutputStream out = to.getOutput();
        try {
            count = ByteStreams.copy(from, out);
            threw = false;
        }
        catch (Throwable throwable) {
            Closeables.close(out, threw);
            throw throwable;
        }
        Closeables.close(out, false);
        return count;
    }

    public static long copy(InputStream from, OutputStream to) throws IOException {
        int r2;
        byte[] buf = new byte[4096];
        long total = 0L;
        while ((r2 = from.read(buf)) != -1) {
            to.write(buf, 0, r2);
            total += (long)r2;
        }
        return total;
    }

    public static long copy(ReadableByteChannel from, WritableByteChannel to) throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4096);
        long total = 0L;
        while (from.read(buf) != -1) {
            buf.flip();
            while (buf.hasRemaining()) {
                total += (long)to.write(buf);
            }
            buf.clear();
        }
        return total;
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteStreams.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    public static byte[] toByteArray(InputSupplier<? extends InputStream> supplier) throws IOException {
        byte[] byArray;
        boolean threw = true;
        InputStream in = supplier.getInput();
        try {
            byte[] result = ByteStreams.toByteArray(in);
            threw = false;
            byArray = result;
        }
        catch (Throwable throwable) {
            Closeables.close(in, threw);
            throw throwable;
        }
        Closeables.close(in, false);
        return byArray;
    }

    public static ByteArrayDataInput newDataInput(byte[] bytes) {
        return new ByteArrayDataInputStream(bytes);
    }

    public static ByteArrayDataInput newDataInput(byte[] bytes, int start) {
        Preconditions.checkPositionIndex(start, bytes.length);
        return new ByteArrayDataInputStream(bytes, start);
    }

    public static ByteArrayDataOutput newDataOutput() {
        return new ByteArrayDataOutputStream();
    }

    public static ByteArrayDataOutput newDataOutput(int size) {
        Preconditions.checkArgument(size >= 0, "Invalid size: %s", size);
        return new ByteArrayDataOutputStream(size);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long length(InputSupplier<? extends InputStream> supplier) throws IOException {
        long count = 0L;
        boolean threw = true;
        InputStream in = supplier.getInput();
        while (true) {
            long amt;
            block3: {
                block4: {
                    long l2;
                    try {
                        amt = in.skip(Integer.MAX_VALUE);
                        if (amt != 0L) break block3;
                        if (in.read() != -1) break block4;
                        threw = false;
                        l2 = count;
                    }
                    catch (Throwable throwable) {
                        Closeables.close(in, threw);
                        throw throwable;
                    }
                    Closeables.close(in, false);
                    return l2;
                }
                ++count;
                continue;
            }
            count += amt;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean equal(InputSupplier<? extends InputStream> supplier1, InputSupplier<? extends InputStream> supplier2) throws IOException {
        byte[] buf1 = new byte[4096];
        byte[] buf2 = new byte[4096];
        boolean threw = true;
        InputStream in1 = supplier1.getInput();
        try {
            int read1;
            InputStream in2 = supplier2.getInput();
            while (true) {
                read1 = ByteStreams.read(in1, buf1, 0, 4096);
                int read2 = ByteStreams.read(in2, buf2, 0, 4096);
                if (read1 == read2 && Arrays.equals(buf1, buf2)) break block7;
                threw = false;
                break;
            }
            {
                catch (Throwable throwable) {
                    Closeables.close(in2, threw);
                    throw throwable;
                }
            }
            {
                block8: {
                    block7: {
                        Closeables.close(in2, false);
                        Closeables.close(in1, false);
                        return false;
                    }
                    if (read1 == 4096) break block8;
                    threw = false;
                    Closeables.close(in2, false);
                    Closeables.close(in1, false);
                    return true;
                }
                continue;
            }
        }
        catch (Throwable throwable) {
            Closeables.close(in1, threw);
            throw throwable;
        }
    }

    public static void readFully(InputStream in, byte[] b2) throws IOException {
        ByteStreams.readFully(in, b2, 0, b2.length);
    }

    public static void readFully(InputStream in, byte[] b2, int off, int len) throws IOException {
        if (ByteStreams.read(in, b2, off, len) != len) {
            throw new EOFException();
        }
    }

    public static void skipFully(InputStream in, long n2) throws IOException {
        while (n2 > 0L) {
            long amt = in.skip(n2);
            if (amt == 0L) {
                if (in.read() == -1) {
                    throw new EOFException();
                }
                --n2;
                continue;
            }
            n2 -= amt;
        }
    }

    public static <T> T readBytes(InputSupplier<? extends InputStream> supplier, ByteProcessor<T> processor) throws IOException {
        byte[] buf = new byte[4096];
        boolean threw = true;
        InputStream in = supplier.getInput();
        try {
            int amt;
            do {
                if ((amt = in.read(buf)) != -1) continue;
                threw = false;
                break;
            } while (processor.processBytes(buf, 0, amt));
            T t2 = processor.getResult();
            return t2;
        }
        finally {
            Closeables.close(in, threw);
        }
    }

    public static long getChecksum(InputSupplier<? extends InputStream> supplier, final Checksum checksum) throws IOException {
        return ByteStreams.readBytes(supplier, new ByteProcessor<Long>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                checksum.update(buf, off, len);
                return true;
            }

            @Override
            public Long getResult() {
                long result = checksum.getValue();
                checksum.reset();
                return result;
            }
        });
    }

    public static byte[] getDigest(InputSupplier<? extends InputStream> supplier, final MessageDigest md) throws IOException {
        return ByteStreams.readBytes(supplier, new ByteProcessor<byte[]>(){

            @Override
            public boolean processBytes(byte[] buf, int off, int len) {
                md.update(buf, off, len);
                return true;
            }

            @Override
            public byte[] getResult() {
                return md.digest();
            }
        });
    }

    public static int read(InputStream in, byte[] b2, int off, int len) throws IOException {
        int total;
        int result;
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        for (total = 0; total < len && (result = in.read(b2, off + total, len - total)) != -1; total += result) {
        }
        return total;
    }

    public static InputSupplier<InputStream> slice(final InputSupplier<? extends InputStream> supplier, final long offset, final long length) {
        Preconditions.checkNotNull(supplier);
        Preconditions.checkArgument(offset >= 0L, "offset is negative");
        Preconditions.checkArgument(length >= 0L, "length is negative");
        return new InputSupplier<InputStream>(){

            @Override
            public InputStream getInput() throws IOException {
                InputStream in = (InputStream)supplier.getInput();
                if (offset > 0L) {
                    try {
                        ByteStreams.skipFully(in, offset);
                    }
                    catch (IOException e2) {
                        Closeables.closeQuietly(in);
                        throw e2;
                    }
                }
                return new LimitInputStream(in, length);
            }
        };
    }

    public static InputSupplier<InputStream> join(final Iterable<? extends InputSupplier<? extends InputStream>> suppliers) {
        return new InputSupplier<InputStream>(){

            @Override
            public InputStream getInput() throws IOException {
                return new MultiInputStream(suppliers.iterator());
            }
        };
    }

    public static InputSupplier<InputStream> join(InputSupplier<? extends InputStream> ... suppliers) {
        return ByteStreams.join(Arrays.asList(suppliers));
    }

    private static class ByteArrayDataOutputStream
    implements ByteArrayDataOutput {
        final DataOutput output;
        final ByteArrayOutputStream byteArrayOutputSteam;

        ByteArrayDataOutputStream() {
            this(new ByteArrayOutputStream());
        }

        ByteArrayDataOutputStream(int size) {
            this(new ByteArrayOutputStream(size));
        }

        ByteArrayDataOutputStream(ByteArrayOutputStream byteArrayOutputSteam) {
            this.byteArrayOutputSteam = byteArrayOutputSteam;
            this.output = new DataOutputStream(byteArrayOutputSteam);
        }

        @Override
        public void write(int b2) {
            try {
                this.output.write(b2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void write(byte[] b2) {
            try {
                this.output.write(b2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void write(byte[] b2, int off, int len) {
            try {
                this.output.write(b2, off, len);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeBoolean(boolean v2) {
            try {
                this.output.writeBoolean(v2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeByte(int v2) {
            try {
                this.output.writeByte(v2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeBytes(String s2) {
            try {
                this.output.writeBytes(s2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeChar(int v2) {
            try {
                this.output.writeChar(v2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeChars(String s2) {
            try {
                this.output.writeChars(s2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeDouble(double v2) {
            try {
                this.output.writeDouble(v2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeFloat(float v2) {
            try {
                this.output.writeFloat(v2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeInt(int v2) {
            try {
                this.output.writeInt(v2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeLong(long v2) {
            try {
                this.output.writeLong(v2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeShort(int v2) {
            try {
                this.output.writeShort(v2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public void writeUTF(String s2) {
            try {
                this.output.writeUTF(s2);
                return;
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public byte[] toByteArray() {
            return this.byteArrayOutputSteam.toByteArray();
        }
    }

    private static class ByteArrayDataInputStream
    implements ByteArrayDataInput {
        final DataInput input;

        ByteArrayDataInputStream(byte[] bytes) {
            this.input = new DataInputStream(new ByteArrayInputStream(bytes));
        }

        ByteArrayDataInputStream(byte[] bytes, int start) {
            this.input = new DataInputStream(new ByteArrayInputStream(bytes, start, bytes.length - start));
        }

        @Override
        public void readFully(byte[] b2) {
            try {
                this.input.readFully(b2);
                return;
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public void readFully(byte[] b2, int off, int len) {
            try {
                this.input.readFully(b2, off, len);
                return;
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public int skipBytes(int n2) {
            try {
                return this.input.skipBytes(n2);
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public boolean readBoolean() {
            try {
                return this.input.readBoolean();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public byte readByte() {
            try {
                return this.input.readByte();
            }
            catch (EOFException e2) {
                throw new IllegalStateException(e2);
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }

        @Override
        public int readUnsignedByte() {
            try {
                return this.input.readUnsignedByte();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public short readShort() {
            try {
                return this.input.readShort();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public int readUnsignedShort() {
            try {
                return this.input.readUnsignedShort();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public char readChar() {
            try {
                return this.input.readChar();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public int readInt() {
            try {
                return this.input.readInt();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public long readLong() {
            try {
                return this.input.readLong();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public float readFloat() {
            try {
                return this.input.readFloat();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public double readDouble() {
            try {
                return this.input.readDouble();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public String readLine() {
            try {
                return this.input.readLine();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }

        @Override
        public String readUTF() {
            try {
                return this.input.readUTF();
            }
            catch (IOException e2) {
                throw new IllegalStateException(e2);
            }
        }
    }
}

