/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.io;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.io.AppendableWriter;
import com.timevale.guava.common.io.Closeables;
import com.timevale.guava.common.io.InputSupplier;
import com.timevale.guava.common.io.LineProcessor;
import com.timevale.guava.common.io.LineReader;
import com.timevale.guava.common.io.MultiReader;
import com.timevale.guava.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Beta
public final class CharStreams {
    private static final int BUF_SIZE = 2048;

    private CharStreams() {
    }

    public static InputSupplier<StringReader> newReaderSupplier(final String value) {
        Preconditions.checkNotNull(value);
        return new InputSupplier<StringReader>(){

            @Override
            public StringReader getInput() {
                return new StringReader(value);
            }
        };
    }

    public static InputSupplier<InputStreamReader> newReaderSupplier(final InputSupplier<? extends InputStream> in, final Charset charset) {
        Preconditions.checkNotNull(in);
        Preconditions.checkNotNull(charset);
        return new InputSupplier<InputStreamReader>(){

            @Override
            public InputStreamReader getInput() throws IOException {
                return new InputStreamReader((InputStream)in.getInput(), charset);
            }
        };
    }

    public static OutputSupplier<OutputStreamWriter> newWriterSupplier(final OutputSupplier<? extends OutputStream> out, final Charset charset) {
        Preconditions.checkNotNull(out);
        Preconditions.checkNotNull(charset);
        return new OutputSupplier<OutputStreamWriter>(){

            @Override
            public OutputStreamWriter getOutput() throws IOException {
                return new OutputStreamWriter((OutputStream)out.getOutput(), charset);
            }
        };
    }

    public static <W extends Appendable & Closeable> void write(CharSequence from, OutputSupplier<W> to) throws IOException {
        Preconditions.checkNotNull(from);
        Appendable out = (Appendable)to.getOutput();
        try {
            out.append(from);
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable)((Object)out), true);
            throw throwable;
        }
        Closeables.close((Closeable)((Object)out), false);
    }

    /*
     * Loose catch block
     */
    public static <R extends Readable & Closeable, W extends Appendable & Closeable> long copy(InputSupplier<R> from, OutputSupplier<W> to) throws IOException {
        boolean threw = true;
        Readable in = (Readable)from.getInput();
        Appendable out = (Appendable)to.getOutput();
        long count = CharStreams.copy(in, out);
        threw = false;
        Closeables.close((Closeable)((Object)out), false);
        Closeables.close((Closeable)((Object)in), false);
        return count;
        {
            catch (Throwable throwable) {
                try {
                    Closeables.close((Closeable)((Object)out), threw);
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    Closeables.close((Closeable)((Object)in), threw);
                    throw throwable2;
                }
            }
        }
    }

    public static <R extends Readable & Closeable> long copy(InputSupplier<R> from, Appendable to) throws IOException {
        long count;
        boolean threw = true;
        Readable in = (Readable)from.getInput();
        try {
            count = CharStreams.copy(in, to);
            threw = false;
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable)((Object)in), threw);
            throw throwable;
        }
        Closeables.close((Closeable)((Object)in), false);
        return count;
    }

    public static long copy(Readable from, Appendable to) throws IOException {
        int r2;
        CharBuffer buf = CharBuffer.allocate(2048);
        long total = 0L;
        while ((r2 = from.read(buf)) != -1) {
            buf.flip();
            to.append(buf, 0, r2);
            total += (long)r2;
        }
        return total;
    }

    public static String toString(Readable r2) throws IOException {
        return CharStreams.toStringBuilder(r2).toString();
    }

    public static <R extends Readable & Closeable> String toString(InputSupplier<R> supplier) throws IOException {
        return CharStreams.toStringBuilder(supplier).toString();
    }

    private static StringBuilder toStringBuilder(Readable r2) throws IOException {
        StringBuilder sb = new StringBuilder();
        CharStreams.copy(r2, (Appendable)sb);
        return sb;
    }

    private static <R extends Readable & Closeable> StringBuilder toStringBuilder(InputSupplier<R> supplier) throws IOException {
        StringBuilder stringBuilder;
        boolean threw = true;
        Readable r2 = (Readable)supplier.getInput();
        try {
            StringBuilder result = CharStreams.toStringBuilder(r2);
            threw = false;
            stringBuilder = result;
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable)((Object)r2), threw);
            throw throwable;
        }
        Closeables.close((Closeable)((Object)r2), false);
        return stringBuilder;
    }

    public static <R extends Readable & Closeable> String readFirstLine(InputSupplier<R> supplier) throws IOException {
        String string;
        boolean threw = true;
        Readable r2 = (Readable)supplier.getInput();
        try {
            String line = new LineReader(r2).readLine();
            threw = false;
            string = line;
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable)((Object)r2), threw);
            throw throwable;
        }
        Closeables.close((Closeable)((Object)r2), false);
        return string;
    }

    public static <R extends Readable & Closeable> List<String> readLines(InputSupplier<R> supplier) throws IOException {
        List<String> list;
        boolean threw = true;
        Readable r2 = (Readable)supplier.getInput();
        try {
            List<String> result = CharStreams.readLines(r2);
            threw = false;
            list = result;
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable)((Object)r2), threw);
            throw throwable;
        }
        Closeables.close((Closeable)((Object)r2), false);
        return list;
    }

    public static List<String> readLines(Readable r2) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        LineReader lineReader = new LineReader(r2);
        while ((line = lineReader.readLine()) != null) {
            result.add(line);
        }
        return result;
    }

    public static <R extends Readable & Closeable, T> T readLines(InputSupplier<R> supplier, LineProcessor<T> callback) throws IOException {
        Readable r2 = (Readable)supplier.getInput();
        try {
            String line;
            LineReader lineReader = new LineReader(r2);
            while ((line = lineReader.readLine()) != null && callback.processLine(line)) {
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Closeable)((Object)r2), true);
            throw throwable;
        }
        Closeables.close((Closeable)((Object)r2), false);
        return callback.getResult();
    }

    public static InputSupplier<Reader> join(final Iterable<? extends InputSupplier<? extends Reader>> suppliers) {
        return new InputSupplier<Reader>(){

            @Override
            public Reader getInput() throws IOException {
                return new MultiReader(suppliers.iterator());
            }
        };
    }

    public static InputSupplier<Reader> join(InputSupplier<? extends Reader> ... suppliers) {
        return CharStreams.join(Arrays.asList(suppliers));
    }

    public static void skipFully(Reader reader, long n2) throws IOException {
        while (n2 > 0L) {
            long amt = reader.skip(n2);
            if (amt == 0L) {
                if (reader.read() == -1) {
                    throw new EOFException();
                }
                --n2;
                continue;
            }
            n2 -= amt;
        }
    }

    public static Writer asWriter(Appendable target) {
        if (target instanceof Writer) {
            return (Writer)target;
        }
        return new AppendableWriter(target);
    }
}

