/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.io;

import com.timevale.guava.common.annotations.Beta;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.h;

@Beta
public final class Closeables {
    private static final Logger logger = Logger.getLogger(Closeables.class.getName());

    private Closeables() {
    }

    public static void close(@h Closeable closeable, boolean swallowIOException) throws IOException {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
            return;
        }
        catch (IOException e2) {
            if (swallowIOException) {
                logger.log(Level.WARNING, "IOException thrown while closing Closeable.", e2);
                return;
            }
            throw e2;
        }
    }

    public static void closeQuietly(@h Closeable closeable) {
        try {
            Closeables.close(closeable, true);
            return;
        }
        catch (IOException e2) {
            logger.log(Level.SEVERE, "IOException should not have been thrown.", e2);
            return;
        }
    }
}

