/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.io;

import com.timevale.guava.common.annotations.Beta;
import com.timevale.guava.common.base.Preconditions;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

@Beta
public final class LimitInputStream
extends FilterInputStream {
    private long left;
    private long mark = -1L;

    public LimitInputStream(InputStream in, long limit) {
        super(in);
        Preconditions.checkNotNull(in);
        Preconditions.checkArgument(limit >= 0L, "limit must be non-negative");
        this.left = limit;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.left);
    }

    @Override
    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark = this.left;
    }

    @Override
    public int read() throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read();
        if (result != -1) {
            --this.left;
        }
        return result;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read(b2, off, len = (int)Math.min((long)len, this.left));
        if (result != -1) {
            this.left -= (long)result;
        }
        return result;
    }

    @Override
    public void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.left = this.mark;
    }

    @Override
    public long skip(long n2) throws IOException {
        n2 = Math.min(n2, this.left);
        long skipped = this.in.skip(n2);
        this.left -= skipped;
        return skipped;
    }
}

