/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.guava.common.primitives;

import com.timevale.guava.common.annotations.VisibleForTesting;
import com.timevale.guava.common.base.Preconditions;
import com.timevale.guava.common.primitives.UnsignedLongs;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Comparator;
import sun.misc.Unsafe;

public final class UnsignedBytes {
    public static final byte MAX_POWER_OF_TWO = -128;

    private UnsignedBytes() {
    }

    public static int toInt(byte value) {
        return value & 0xFF;
    }

    public static byte checkedCast(long value) {
        Preconditions.checkArgument(value >> 8 == 0L, "out of range: %s", value);
        return (byte)value;
    }

    public static byte saturatedCast(long value) {
        if (value > 255L) {
            return -1;
        }
        if (value < 0L) {
            return 0;
        }
        return (byte)value;
    }

    public static int compare(byte a2, byte b2) {
        return UnsignedBytes.toInt(a2) - UnsignedBytes.toInt(b2);
    }

    public static byte min(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int min = UnsignedBytes.toInt(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            int next = UnsignedBytes.toInt(array[i2]);
            if (next >= min) continue;
            min = next;
        }
        return (byte)min;
    }

    public static byte max(byte ... array) {
        Preconditions.checkArgument(array.length > 0);
        int max = UnsignedBytes.toInt(array[0]);
        for (int i2 = 1; i2 < array.length; ++i2) {
            int next = UnsignedBytes.toInt(array[i2]);
            if (next <= max) continue;
            max = next;
        }
        return (byte)max;
    }

    public static String join(String separator, byte ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(UnsignedBytes.toInt(array[0]));
        for (int i2 = 1; i2 < array.length; ++i2) {
            builder.append(separator).append(UnsignedBytes.toInt(array[i2]));
        }
        return builder.toString();
    }

    public static Comparator<byte[]> lexicographicalComparator() {
        return LexicographicalComparatorHolder.BEST_COMPARATOR;
    }

    @VisibleForTesting
    static Comparator<byte[]> lexicographicalComparatorJavaImpl() {
        return LexicographicalComparatorHolder.PureJavaComparator.INSTANCE;
    }

    @VisibleForTesting
    static class LexicographicalComparatorHolder {
        static final String UNSAFE_COMPARATOR_NAME = LexicographicalComparatorHolder.class.getName() + "$UnsafeComparator";
        static final Comparator<byte[]> BEST_COMPARATOR = LexicographicalComparatorHolder.getBestComparator();

        LexicographicalComparatorHolder() {
        }

        static Comparator<byte[]> getBestComparator() {
            try {
                Class<?> theClass = Class.forName(UNSAFE_COMPARATOR_NAME);
                Comparator comparator = (Comparator)theClass.getEnumConstants()[0];
                return comparator;
            }
            catch (Throwable throwable) {
                return UnsignedBytes.lexicographicalComparatorJavaImpl();
            }
        }

        static enum PureJavaComparator implements Comparator<byte[]>
        {
            INSTANCE;


            @Override
            public int compare(byte[] left, byte[] right) {
                int minLength = Math.min(left.length, right.length);
                for (int i2 = 0; i2 < minLength; ++i2) {
                    int result = UnsignedBytes.compare(left[i2], right[i2]);
                    if (result == 0) continue;
                    return result;
                }
                return left.length - right.length;
            }
        }

        @VisibleForTesting
        static enum UnsafeComparator implements Comparator<byte[]>
        {
            INSTANCE;

            static final boolean littleEndian;
            static final Unsafe theUnsafe;
            static final int BYTE_ARRAY_BASE_OFFSET;

            @Override
            public int compare(byte[] left, byte[] right) {
                int i2;
                int minLength = Math.min(left.length, right.length);
                int minWords = minLength / 8;
                for (i2 = 0; i2 < minWords << 3; i2 += 8) {
                    int y2;
                    long rw;
                    long lw = theUnsafe.getLong(left, (long)BYTE_ARRAY_BASE_OFFSET + (long)i2);
                    long diff = lw ^ (rw = theUnsafe.getLong(right, (long)BYTE_ARRAY_BASE_OFFSET + (long)i2));
                    if (diff == 0L) continue;
                    if (!littleEndian) {
                        return UnsignedLongs.compare(lw, rw);
                    }
                    int n2 = 0;
                    int x2 = (int)diff;
                    if (x2 == 0) {
                        x2 = (int)(diff >>> 32);
                        n2 = 32;
                    }
                    if ((y2 = x2 << 16) == 0) {
                        n2 += 16;
                    } else {
                        x2 = y2;
                    }
                    y2 = x2 << 8;
                    if (y2 == 0) {
                        n2 += 8;
                    }
                    return (int)((lw >>> n2 & 0xFFL) - (rw >>> n2 & 0xFFL));
                }
                for (i2 = minWords << 3; i2 < minLength; ++i2) {
                    int result = UnsignedBytes.compare(left[i2], right[i2]);
                    if (result == 0) continue;
                    return result;
                }
                return left.length - right.length;
            }

            static {
                littleEndian = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN);
                theUnsafe = (Unsafe)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            Field f2 = Unsafe.class.getDeclaredField("theUnsafe");
                            f2.setAccessible(true);
                            return f2.get(null);
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            throw new Error();
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new Error();
                        }
                    }
                });
                BYTE_ARRAY_BASE_OFFSET = theUnsafe.arrayBaseOffset(byte[].class);
                if (theUnsafe.arrayIndexScale(byte[].class) != 1) {
                    throw new AssertionError();
                }
            }
        }
    }
}

