/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.seal.util;

import com.timevale.seal.graphics.suites.impl.b;
import com.timevale.seal.template.tools.Stamp;
import esign.utils.constant.type.Color;
import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.io.UnsupportedEncodingException;

public class GraphicsTextFont {
    private transient char character;
    private TextFont font = TextFont.SIMSUN;
    private int fontSize = 200;
    private Color color = Color.RED;
    private Integer fontRealWidth;
    private Integer fontRealHeight;

    public void cloneFrom(GraphicsTextFont that) {
        this.setColor(that.getColor());
        this.setFont(that.getFont());
        this.setFontSize(that.getFontSize());
        this.setFontRealHeight(that.getFontRealHeight());
        this.setFontRealWidth(that.getFontRealWidth());
    }

    public TextFont getFont() {
        return this.font;
    }

    public void setFont(TextFont font) {
        if (font != null) {
            this.font = font;
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(Integer fontSize) {
        if (fontSize != null) {
            this.fontSize = fontSize;
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.color = color;
        }
    }

    public Integer getFontRealWidth() {
        return this.fontRealWidth;
    }

    public void setFontRealWidth(Integer fontRealWidth) {
        this.fontRealWidth = fontRealWidth;
    }

    public Integer getFontRealHeight() {
        return this.fontRealHeight;
    }

    public void setFontRealHeight(Integer fontRealHeight) {
        this.fontRealHeight = fontRealHeight;
    }

    protected void draw(float x, float y, Graphics2D g2) throws SuperException {
        FontMetrics fm = g2.getFontMetrics();
        b scale = this.scaleCharacter(fm, this.character, this.getFontRealWidth(), this.getFontRealHeight());
        float baselineOffsetY = (float)(-fm.getDescent()) * scale.b();
        float baselineOffsetX = ((float)this.getFontRealWidth().intValue() - (float)fm.charWidth(this.character) * scale.a()) / 2.0f;
        g2.translate(x + baselineOffsetX, y + baselineOffsetY);
        g2.scale(scale.a(), scale.b());
        g2.drawString(String.valueOf(this.character), 0, 0);
        g2.scale(1.0f / scale.a(), 1.0f / scale.b());
        g2.translate(-x - baselineOffsetX, -y - baselineOffsetY);
    }

    private b scaleCharacter(FontMetrics fm, char character, Integer width, Integer height) throws SuperException {
        int ch = fm.getHeight() - fm.getLeading();
        int cw = fm.charWidth(character);
        float scaleX = width == null ? 1.0f : (float)width.intValue() / (float)cw;
        float scaleY = height == null ? 1.0f : (float)height.intValue() / (float)ch;
        try {
            if (1 == new Character(character).toString().getBytes("utf-8").length) {
                return new b(scaleY, scaleY);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorsDiscriptor.ar.e("utf-8");
        }
        return new b(scaleX, scaleY);
    }

    public void setCharacter(char character) {
        this.character = character;
    }

    public static enum TextFont {
        SONG(1, "simfang"),
        SIMSUN(2, "simsun");

        private int value;
        private String font;

        private TextFont(int value, String font) {
            this.font = font;
        }

        public String font() {
            return this.font;
        }

        public Font getAwtFont(int size) {
            return new Stamp().a(this.font, size);
        }

        public static TextFont from(int value) {
            for (TextFont font : TextFont.values()) {
                if (font.value != value) continue;
                return font;
            }
            return null;
        }
    }
}

