/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.timestamp.utils;

import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIFailureInfo;
import com.timevale.tgtext.bouncycastle.jce.provider.BouncyCastleProvider;
import com.timevale.tgtext.bouncycastle.tsp.TSPException;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampRequest;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampRequestGenerator;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampResponse;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampTokenInfo;
import com.timevale.timestamp.enums.DigestAlgorithm;
import com.timevale.timestamp.utils.a;
import com.timevale.timestamp.utils.b;
import com.timevale.timestamp.utils.c;
import com.timevale.timestamp.utils.d;
import com.timevale.timestamp.utils.f;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class e
implements d {
    private static final Logger m = LoggerFactory.getLogger(e.class);
    protected String a;
    protected String b;
    protected String c;
    protected String d;
    protected int e;
    protected String f;
    protected String g;
    protected f h;
    public static final int i = 4096;
    protected int j;
    public static final String k = "SHA-256";
    protected String l;

    public e() {
    }

    public e(String url) {
        this(url, null, null, 4096, k);
    }

    public e(String url, String username, String password) {
        this(url, username, password, 4096, k);
    }

    public e(String url, String proxyIp, int proxyPort) {
        this(url, null, null, 4096, k, proxyIp, proxyPort, null, null);
    }

    public e(String url, String proxyIp, int proxyPort, String proxyUsername, String proxyPassword) {
        this(url, null, null, 4096, k, proxyIp, proxyPort, proxyUsername, proxyPassword);
    }

    public e(String url, String username, String password, int tokSzEstimate, String digestAlgorithm) {
        this(url, username, password, tokSzEstimate, digestAlgorithm, null, 0, null, null);
    }

    public e(String url, String username, String password, int tokSzEstimate, String digestAlgorithm, String proxyIp, int proxyPort, String proxyUsername, String proxyPassword) {
        this.a = url;
        this.b = username;
        this.c = password;
        this.j = tokSzEstimate;
        this.l = digestAlgorithm;
        this.d = proxyIp;
        this.e = proxyPort;
        this.f = proxyUsername;
        this.g = proxyPassword;
    }

    public void a(f tsaInfo) {
        this.h = tsaInfo;
    }

    @Override
    public int a() {
        return this.j;
    }

    @Override
    public byte[] a(byte[] imprint) throws IOException, TSPException {
        return this.a(imprint, DigestAlgorithm.SHA1);
    }

    @Override
    public byte[] a(byte[] imprint, DigestAlgorithm digestAlgorithm) throws IOException, TSPException {
        TimeStampRequestGenerator tsqGenerator = new TimeStampRequestGenerator();
        tsqGenerator.setCertReq(true);
        TimeStampRequest request = tsqGenerator.generate(com.timevale.timestamp.utils.b.c(digestAlgorithm.getDigest()), imprint);
        byte[] requestBytes = request.getEncoded();
        byte[] respBytes = this.b(requestBytes);
        TimeStampResponse response = new TimeStampResponse(respBytes);
        response.validate(request);
        PKIFailureInfo failure = response.getFailInfo();
        int value = failure == null ? 0 : failure.intValue();
        if (value != 0) {
            throw new IOException("invalid.tsa.1.response.code.2");
        }
        TimeStampToken tsToken = response.getTimeStampToken();
        if (tsToken == null) {
            throw new IOException("tsa.1.failed.to.return.time.stamp.token.2");
        }
        TimeStampTokenInfo tsTokenInfo = tsToken.getTimeStampInfo();
        byte[] encoded = tsToken.getEncoded();
        m.info("Timestamp generated: " + tsTokenInfo.getGenTime());
        this.j = encoded.length + 32;
        return respBytes;
    }

    protected byte[] b(byte[] requestBytes) throws IOException {
        return this.c(requestBytes);
    }

    protected byte[] c(byte[] requestBytes) throws IOException {
        int bytesRead;
        String userPassword;
        URLConnection tsaConnection;
        if (this.a.startsWith("https")) {
            try {
                com.timevale.timestamp.utils.c.b();
            }
            catch (Exception exception) {
                Exception e2 = exception;
                exception.printStackTrace();
            }
        }
        URL url = new URL(this.a);
        try {
            if (this.d != null && this.e != 0) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.d, this.e));
                tsaConnection = url.openConnection(proxy);
                tsaConnection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1)");
            } else {
                tsaConnection = url.openConnection();
            }
        }
        catch (IOException iOException) {
            throw new IOException("failed.to.get.tsa.response.from.1");
        }
        tsaConnection.setDoInput(true);
        tsaConnection.setDoOutput(true);
        tsaConnection.setUseCaches(false);
        tsaConnection.setConnectTimeout(1500);
        tsaConnection.setReadTimeout(1500);
        tsaConnection.setRequestProperty("Content-Type", "application/timestamp-query");
        tsaConnection.setRequestProperty("Content-Transfer-Encoding", "binary");
        if (this.b != null && !this.b.equals("")) {
            userPassword = this.b + ":" + this.c;
            tsaConnection.setRequestProperty("Authorization", "Basic " + com.timevale.timestamp.utils.a.a(userPassword.getBytes()));
        }
        if (this.f != null && !this.f.equals("")) {
            userPassword = this.f + ":" + this.g;
            tsaConnection.setRequestProperty("Proxy-Authorization", "Basic " + com.timevale.timestamp.utils.a.a(userPassword.getBytes()));
        }
        OutputStream out = tsaConnection.getOutputStream();
        out.write(requestBytes);
        out.close();
        InputStream inp = tsaConnection.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((bytesRead = inp.read(buffer, 0, 1024)) >= 0) {
            baos.write(buffer, 0, bytesRead);
        }
        byte[] respBytes = baos.toByteArray();
        String encoding = tsaConnection.getContentEncoding();
        if (encoding != null && encoding.equalsIgnoreCase("base64")) {
            respBytes = com.timevale.timestamp.utils.a.a(new String(respBytes));
        }
        return respBytes;
    }

    public static boolean a(byte[] src, byte[] timestamp) throws com.timevale.timestamp.exception.a {
        TimeStampResponse response;
        try {
            response = new TimeStampResponse(timestamp);
        }
        catch (Exception e2) {
            m.error("invalid timestamp", (Throwable)e2);
            return false;
        }
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            TimeStampRequestGenerator reqgen = new TimeStampRequestGenerator();
            MessageDigest md = MessageDigest.getInstance(com.timevale.timestamp.utils.b.a(response.getTimeStampToken().getTimeStampInfo().getHashAlgorithm().getAlgorithm().toString()));
            md.update(src);
            byte[] tsImprint = md.digest();
            TimeStampRequest req = reqgen.generate(response.getTimeStampToken().getTimeStampInfo().getMessageImprintAlgOID(), tsImprint);
            response.validate(req);
            return true;
        }
        catch (Exception exception) {
            m.warn("validate timestamp failed.");
            return false;
        }
    }
}

