/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageUtil {
    public static byte[] transferAlpha(BufferedImage image) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIcon imageIcon = new ImageIcon(image);
            BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 6);
            Graphics2D g2D = (Graphics2D)bufferedImage.getGraphics();
            g2D.drawImage(imageIcon.getImage(), 0, 0, imageIcon.getImageObserver());
            for (int j1 = bufferedImage.getMinY(); j1 < bufferedImage.getHeight(); ++j1) {
                for (int j2 = bufferedImage.getMinX(); j2 < bufferedImage.getWidth(); ++j2) {
                    int rgb = bufferedImage.getRGB(j2, j1);
                    int R = rgb >> 16 & 0xFF;
                    int G = rgb >> 8 & 0xFF;
                    int B = rgb & 0xFF;
                    if (255 - R > 160 && 255 - G > 160 && 255 - B > 160) {
                        rgb = 0x1000000 | rgb & 0xFFFFFF;
                    }
                    bufferedImage.setRGB(j2, j1, rgb);
                }
            }
            g2D.drawImage((Image)bufferedImage, 0, 0, imageIcon.getImageObserver());
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        return byteArrayOutputStream.toByteArray();
    }
}

