/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.utils;

import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSACertUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSACertUtil.class);

    public static PublicKey getPublicKeyByCert(X509Certificate signCert) {
        PublicKey publicKey = null;
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(signCert.getEncoded());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (bIn.available() > 0) {
                Certificate x509cert = cf.generateCertificate(bIn);
                publicKey = x509cert.getPublicKey();
            }
        }
        catch (Exception ex) {
            LOGGER.error("\u83b7\u53d6\u516c\u94a5\u5931\u8d25", (Throwable)ex);
        }
        return publicKey;
    }
}

