/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtil.class);

    public static Document parseStringToXML(String xmlString) {
        try {
            if (xmlString.contains("&")) {
                xmlString = xmlString.replace("&", "&amp;");
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource input = new InputSource();
            input.setCharacterStream(new StringReader(xmlString));
            Document document = builder.parse(input);
            return document;
        }
        catch (Exception exception) {
            LOGGER.error("get xml error, string:{}", (Object)xmlString);
            return null;
        }
    }

    public static Document parseFileToXML(File xmlFile) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlFile);
            return document;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Document parseFileToXML(InputStream xmlInputStream) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlInputStream);
            return document;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Document createDocument() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    public static void saveDocument(Document document, String fileName) throws FileNotFoundException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        DOMSource source = new DOMSource(document);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        PrintWriter pw = new PrintWriter(new FileOutputStream(fileName));
        StreamResult result = new StreamResult(pw);
        transformer.transform(source, result);
        if (pw != null) {
            pw.close();
        }
    }

    public static Node selectSingleNode(String express, Element root) {
        Node result = null;
        try {
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            result = (Node)xpath.evaluate(express, root, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            XPathExpressionException var5 = xPathExpressionException;
            xPathExpressionException.printStackTrace();
        }
        return result;
    }

    public static Element getElement(Element root, String tag) {
        NodeList nodes = root.getElementsByTagName(tag);
        if (nodes != null && nodes.getLength() > 0) {
            return (Element)nodes.item(0);
        }
        return null;
    }

    public static String getElementText(Element root, String tag) {
        NodeList nodes = root.getElementsByTagName(tag);
        if (nodes != null && nodes.getLength() > 0) {
            String text = nodes.item(0).getTextContent().trim();
            return text;
        }
        return null;
    }
}

