/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.asserts;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssertSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssertSupport.class);

    public static void checkPoint(boolean checked, String msg, Object ... args) {
        if (!checked) {
            LOGGER.warn(msg, args);
            LOGGER.warn("check point:", new Throwable());
        }
    }

    public static <T, E extends Exception> T assertNotnull(T t, E e2) throws E {
        AssertSupport.assertTrue(t != null, e2);
        return t;
    }

    public static <T, E extends Exception> void assertNull(T t, E e2) throws E {
        AssertSupport.assertTrue(t == null, e2);
    }

    public static <E extends Exception> void assertAllNotnull(E e2, Object ... ts) throws E {
        Object[] objectArray = ts;
        int n2 = ts.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object t = objectArray[i2];
            AssertSupport.assertNotnull(t, e2);
        }
    }

    public static <E extends Exception> void assertNotallNull(E e2, Object ... ts) throws E {
        Object[] objectArray = ts;
        int n2 = ts.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object t = objectArray[i2];
            if (t == null) continue;
            return;
        }
        throw e2;
    }

    public static <T, E extends Exception> Collection<T> assertNotnull(Collection<T> t, E e2) throws E {
        AssertSupport.assertTrue(t != null && !t.isEmpty(), e2);
        return t;
    }

    public static <T, E extends Exception> void assertNull(Collection<T> t, E e2) throws E {
        AssertSupport.assertTrue(t == null || t.isEmpty(), e2);
    }

    public static <T, E extends Exception> T[] assertNotnull(T[] t, E e2) throws E {
        AssertSupport.assertTrue(t != null && t.length > 0, e2);
        return t;
    }

    public static <T, E extends Exception> void assertNull(T[] t, E e2) throws E {
        AssertSupport.assertTrue(t == null || 0 == t.length, e2);
    }

    public static <E extends Exception> String assertNotnull(String t, E e2) throws E {
        AssertSupport.assertTrue(!StringUtils.isEmpty((String)t), e2);
        return t;
    }

    public static <E extends Exception> String assertNull(String t, E e2) throws E {
        AssertSupport.assertTrue(StringUtils.isEmpty((String)t), e2);
        return t;
    }

    public static <E extends Exception> void assertAllNotnull(E e2, String ... ts) throws E {
        String[] stringArray = ts;
        int n2 = ts.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String t = stringArray[i2];
            AssertSupport.assertNotnull(t, e2);
        }
    }

    public static <E extends Exception> void assertNotallNull(E e2, String ... ts) throws E {
        String[] stringArray = ts;
        int n2 = ts.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String t = stringArray[i2];
            if (StringUtils.isEmpty((String)t)) continue;
            return;
        }
        throw e2;
    }

    public static <E extends Exception> void assertTrue(boolean value, E e2) throws E {
        if (!value) {
            throw e2;
        }
    }
}

