/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.security.provider;

import esign.utils.exception.ErrorsDiscriptor;
import esign.utils.exception.SuperException;
import esign.utils.security.model.AsymmetricAlgorithmModel;
import esign.utils.security.model.DigestAlgorithmModel;
import esign.utils.security.provider.impl.SignDigestAdapter;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SignerProivder implements esign.utils.enumadp.b<AsymmetricAlgorithmModel, SignerProivder>
{
    RSA(AsymmetricAlgorithmModel.RSA, "RSA"),
    DSA(AsymmetricAlgorithmModel.DSA, "DSA");

    private String signAlg;
    private AsymmetricAlgorithmModel signType;
    private static final esign.utils.enumadp.a<SignerProivder, AsymmetricAlgorithmModel, SignerProivder> adapter;
    private static final Logger LOGGER;

    private SignerProivder(AsymmetricAlgorithmModel signType, String signAlg) {
        this.signType = signType;
        this.signAlg = signAlg;
    }

    public static SignerProivder from(AsymmetricAlgorithmModel model) {
        return adapter.a(model);
    }

    public Signature signer(DigestAlgorithmModel digest, String pkcs8Key) throws SuperException {
        return this.signer(digest, esign.utils.a.a(pkcs8Key));
    }

    public Signature signer(DigestAlgorithmModel digest, byte[] pkcs8Key) throws SuperException {
        return this.createSignature(digest, pkcs8Key, new b());
    }

    public Signature verifier(DigestAlgorithmModel digest, byte[] x509Key) throws SuperException {
        return this.createSignature(digest, x509Key, new c());
    }

    private Signature createSignature(DigestAlgorithmModel digest, byte[] key, a initKey) throws SuperException {
        Signature sig;
        KeyFactory keyFactory;
        try {
            keyFactory = KeyFactory.getInstance(this.signAlg);
        }
        catch (NoSuchAlgorithmException e2) {
            LOGGER.error("no such alg. alg:{}", (Object)this.signAlg);
            LOGGER.error("exception:", (Throwable)e2);
            throw ErrorsDiscriptor.aJ_.e(e2);
        }
        String signDigestWithAlg = SignDigestAdapter.from(digest).generateSignDigestAlgDiscription(this.signAlg);
        try {
            sig = Signature.getInstance(signDigestWithAlg);
        }
        catch (NoSuchAlgorithmException e3) {
            LOGGER.error("no such alg. alg:{}", (Object)signDigestWithAlg);
            LOGGER.error("exception:", (Throwable)e3);
            throw ErrorsDiscriptor.aJ_.e(e3);
        }
        initKey.a(keyFactory, sig, key);
        return sig;
    }

    @Override
    public AsymmetricAlgorithmModel getFrom() {
        return this.signType;
    }

    @Override
    public SignerProivder getTo() {
        return this;
    }

    static {
        adapter = new esign.utils.enumadp.a(SignerProivder.class);
        LOGGER = LoggerFactory.getLogger(SignerProivder.class);
    }

    private static interface a {
        public void a(KeyFactory var1, Signature var2, byte[] var3) throws SuperException;
    }

    private class b
    implements a {
        private b() {
        }

        @Override
        public void a(KeyFactory keyFactory, Signature signature, byte[] key) throws SuperException {
            try {
                PrivateKey pk = esign.utils.security.c.b(keyFactory, key);
                signature.initSign(pk);
                return;
            }
            catch (InvalidKeyException e2) {
                LOGGER.error("invalid key.", (Throwable)e2);
                throw ErrorsDiscriptor.aK_.e(e2);
            }
            catch (InvalidKeySpecException e3) {
                LOGGER.error("invalid key.", (Throwable)e3);
                throw ErrorsDiscriptor.aK_.e(e3);
            }
        }
    }

    private class c
    implements a {
        private c() {
        }

        @Override
        public void a(KeyFactory keyFactory, Signature signature, byte[] key) throws SuperException {
            try {
                PublicKey pk = esign.utils.security.c.a(keyFactory, key);
                signature.initVerify(pk);
                return;
            }
            catch (InvalidKeyException e2) {
                LOGGER.error("invalid key.", (Throwable)e2);
                throw ErrorsDiscriptor.aK_.e(e2);
            }
            catch (InvalidKeySpecException e3) {
                LOGGER.error("invalid key.", (Throwable)e3);
                throw ErrorsDiscriptor.aK_.e(e3);
            }
        }
    }
}

