﻿using System;
using System.IO;
using System.Windows.Forms;

namespace WindowsFormsApp1.Core
{
    class GetFileInfo
    {

        //获取文件大小
        public static int GetFileLength(string path)
        {
            int length = 0;
            FileInfo fileInfo = null;
            try
            {
                fileInfo = new System.IO.FileInfo(path);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
                // 其他处理异常的代码
            }
            // 如果文件存在
            if (fileInfo != null && fileInfo.Exists)
            {
                System.Diagnostics.FileVersionInfo info = System.Diagnostics.FileVersionInfo.GetVersionInfo(path);
                length = (int)Math.Ceiling(fileInfo.Length / 1024.0);
            }
            else
            {
                Console.WriteLine("指定的文件路径不正确!");
            }
            return length;
        }

        //获取文件ContentMD5
        public static string GetContentMD5FromFile(string filePath)
        {
            string ContentMD5 = null;
            try
            {
                FileStream file = new FileStream(filePath, FileMode.Open, FileAccess.Read);
                System.Security.Cryptography.MD5 md5 = new System.Security.Cryptography.MD5CryptoServiceProvider();
                // 先计算出上传内容的MD5，其值是一个128位（128 bit）的二进制数组
                byte[] retVal = md5.ComputeHash(file);
                file.Close();
                // 再对这个二进制数组进行base64编码
                ContentMD5 = Convert.ToBase64String(retVal).ToString();
                return ContentMD5;
            }
            catch (Exception ex)
            {
                MessageBox.Show("错误信息", "计算文件的Content-MD5值时发生异常：" + ex.Message);
                return ContentMD5;
            }
        }

        //读取文件byte[]
        public static byte[] FileContent(string filePath)
        {
            using (FileStream fs = new FileStream(filePath, FileMode.Open, FileAccess.Read))
            {
                try
                {
                    byte[] buffur = new byte[fs.Length];
                    fs.Read(buffur, 0, (int)fs.Length);
                    return buffur;
                }
                catch (Exception ex)
                {
                    throw ex;
                }
            }
        }

    }
}
