﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.request;
using WindowsFormsApp1.Factory.response.account;

namespace WindowsFormsApp1.Factory.account
{
    class DeleteOrganizationsByOrgId : EsignRequest<DeleteOrganizationsByOrgIdResponse>
    {
        [JsonIgnore]
        public string orgId;

        public DeleteOrganizationsByOrgId(string orgId)
        {
            this.orgId = orgId;
        }

        public DeleteOrganizationsByOrgId build() {
            base.Url = "/v1/organizations/" + orgId;
            base.ReqType = HttpType.DELETE;
            return this;
        }
    }
}
