﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.request;
using WindowsFormsApp1.Factory.response.account;

namespace WindowsFormsApp1.Factory.account
{
    class DeletePersonByAccountId : EsignRequest<DeletePersonByAccountIdResponse>
    {
        [JsonIgnore]
        public string accountId;
        public DeletePersonByAccountId(string accountId)
        {
            this.accountId = accountId;
        }

        public DeletePersonByAccountId build() {
            base.Url = "/v1/accounts/" + accountId;
            base.ReqType = HttpType.DELETE;
            return this;
        }
    }
}
