﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.request;
using WindowsFormsApp1.Factory.response.filetemp;

namespace WindowsFormsApp1.Factory.filetemp
{
    /**
     *通过上传方式创建文件 */
    class GetFileUploadUrl : EsignRequest<GetFileUploadUrlResponse>
    {
        public GetFileUploadUrl(string contentMd5, string contentType, bool convert2Pdf, string fileName, int fileSize)
        {
            this.contentMd5 = contentMd5;
            this.contentType = contentType;
            this.convert2Pdf = convert2Pdf;
            this.fileName = fileName;
            this.fileSize = fileSize;
        }

        public string contentMd5 { set; get; }
        public string contentType { set; get; }
        public bool convert2Pdf { set; get; }
        public string fileName { set; get; }
        public int fileSize { set; get; }
        public string accountId { set; get; }

        public GetFileUploadUrl build()
        {
            this.Url = "/v1/files/getUploadUrl";
            this.ReqType = HttpType.POST;
            return this;
        }
    }
}
