﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.response.filetemp;
using WinTechWrapperDemo.demoUtils;

namespace WindowsFormsApp1.Factory.filetemp
{
    class UploadFile
    {
        public UploadFile(string filePath, string contentType, string url)
        {
            this.filePath = filePath;
            this.contentType = contentType;
            this.url = url;
        }

        public string filePath { set; get; }
        public string contentType { set; get; }
        public string url { set; get; }

        /**
        * 上传文件
        * @return
        * @throws DefineException
        * @throws IOException
        */
        public int Execute()
        {
            HttpHelper httpHelper = new HttpHelper();
            String contentMd5 = Core.GetFileInfo.GetContentMD5FromFile(this.filePath);
            int resp = httpHelper.SendPUT(this.url,this.filePath, httpHelper.getPUTHeaders(contentMd5, "UTF-8"),this.contentType);
            return resp;
        }
    }
}
