﻿using log4net;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.response;
using WindowsFormsApp1.Factory.response.account;
using WinTechWrapperDemo.demoUtils;

namespace WindowsFormsApp1.Factory.request
{
    abstract class EsignRequest<T> where T : class
    {
        private static ILog Logger = LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);
        [JsonIgnore]
        public string ReqType { get; set; }
        [JsonIgnore]
        public string Url { get; set; }

        public T Execute() {

            // 请求参数JSON字符串
            string reqData = JSONHelper.EntityToJSON(this);
            Console.WriteLine(reqData);
            // 如果请求Body体为空时，需要对空JSON进行ContentMD5计算
            if (null == reqData)
            {
                reqData = "{}";
            }
            Logger.Info(reqData);
            string contentType = "application/json; charset=UTF-8";

            string HTTPMethod = ReqType;
            string Accept = contentType;
            string Url = this.Url;
            string ContentMD5 = DigestHelper.doContentMD5(reqData);
            string Date = "";
            string SignHeaders = "";

            // 构建待签名字符串
            System.Text.StringBuilder sb = new System.Text.StringBuilder();
            sb.Append(HTTPMethod).Append("\n").Append(Accept).Append("\n").Append(ContentMD5).Append("\n")
                .Append(contentType).Append("\n").Append(Date).Append("\n");
            if ("".Equals(SignHeaders))
            {
                sb.Append(SignHeaders).Append(Url);
            }
            else
            {
                sb.Append(SignHeaders).Append("\n").Append(Url);
            }

            // 构建参与请求签名计算的明文
            string stringToSign = sb.ToString();
            // 计算请求签名值
            string reqSignature = DigestHelper.doSignatureBase64(stringToSign, Config.Config.App_Secret);

            HttpHelper httpHelper = new HttpHelper();

            // 获取时间戳毫秒级
            string timeStamp = Convert.ToString(TimestampHelper.GetTimestamp());

            Dictionary<string, string> postHeaders = httpHelper.builderPOSTHeaders(Config.Config.AppId, reqSignature, timeStamp, ContentMD5, "HmacSHA256", "UTF-8");
            HttpRespResult resp = null;
            // 网络调用接口
            if (HttpType.GET.Equals(ReqType))
            {
                resp = httpHelper.Get(Config.Config.Host + this.Url, reqData, postHeaders, contentType);
            }
            else
            {
                resp = httpHelper.SendHttp(Config.Config.Host + this.Url, ReqType, reqData, postHeaders, contentType);
            }
            Console.WriteLine((string)resp.RespData);
            T eResp = JSONHelper.DeserializeJsonToObject<T>((string)resp.RespData);
            Type t = typeof(EsignResponse);//类名
            MethodInfo set_status = t.GetMethod("set_status");//加载方法
            set_status.Invoke(eResp, new object[] { resp.HttpStatusCode});
            MethodInfo set_body = t.GetMethod("set_body");//加载方法
            set_body.Invoke(eResp, new object[] { resp.RespData });
            return eResp;

        }

    }
}
