﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using WindowsFormsApp1.Core;
using WindowsFormsApp1.Factory.request;
using WindowsFormsApp1.Factory.response.seals;

namespace WindowsFormsApp1.Factory.seals
{
    /**
     * 创建个人模板印章*/
    class CreatePersonalTemplate : EsignRequest<CreatePersonalTemplateResponse>
    {
        [JsonIgnore]
        public string accountId { get; set; }
        public string alias { get; set; }
        public string color { get; set; }
        public int height { get; set; } = 95;
        public int width { get; set; } = 95;
        public string type { get; set; }

        public CreatePersonalTemplate(string accountId, string color, string type)
        {
            this.accountId = accountId;
            this.color = color;
            this.type = type;
        }

        public CreatePersonalTemplate build()
        {
            this.Url = "/v1/accounts/" + accountId + "/seals/personaltemplate";
            this.ReqType = HttpType.POST;
            return this;
        }
    }
}
